<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'salary_monthly_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'salary_monthly_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php
$calander_db = fetch_calander_name();
    $months_array = array(
    '1' => print_lang($app_lang,'january'),
    '2' => print_lang($app_lang,'february'),
    '3' => print_lang($app_lang,'march'),
    '4' => print_lang($app_lang,'april'),
    '5' => print_lang($app_lang,'may'),
    '6' => print_lang($app_lang,'june'),
    '7' => print_lang($app_lang,'july'),
    '8' => print_lang($app_lang,'august'),
    '9' => print_lang($app_lang,'september'),
    '10' => print_lang($app_lang,'October'),
    '11' => print_lang($app_lang,'November'),
    '12' => print_lang($app_lang,'December'),
);


$month_name = array_key_exists($search_month,$months_array) ? $months_array[$search_month] : NULL;

?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'salary_sheet_of').' '.$month_name.' '.$search_year; ?></h2>

                    <form id="salary-monthly-report-search-form" action="<?= url('/salary-report-monthly'); ?>">
                    <div class="row">
                        <input type="hidden" name="calander_db" value="<?= $calander_db; ?>">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="month">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'month'); ?> --</option>
                                                <option value="1" <?php if($search_month == '1'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'january'); ?></option>
                                                <option value="2" <?php if($search_month == '2'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'february'); ?></option>
                                                <option value="3" <?php if($search_month == '3'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'march'); ?></option>
                                                <option value="4" <?php if($search_month == '4'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'april'); ?></option>
                                                <option value="5" <?php if($search_month == '5'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'may'); ?></option>
                                                <option value="6" <?php if($search_month == '6'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'june'); ?></option>
                                                <option value="7" <?php if($search_month == '7'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'july'); ?></option>
                                                <option value="8" <?php if($search_month == '8'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'august'); ?></option>
                                                <option value="9" <?php if($search_month == '9'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'september'); ?></option>
                                                <option value="10" <?php if($search_month == '10'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'October'); ?></option>
                                                <option value="11" <?php if($search_month == '11'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'November'); ?></option>
                                                <option value="12" <?php if($search_month == '12'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'December'); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="year">

                                                <?php $current_year = date('Y'); for($y = 0; $y < 5; $y++){ $run_year = $current_year--; ?>
                                                    <option value="<?= $run_year; ?>" <?php if($search_year == $run_year){ echo 'selected="selected"'; } ?>><?= $run_year; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'basic_salary'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'earnings'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'monthly_salary_total_days'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'monthly_salary_total_absents'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'deductions'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'paid_advance'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'net_salary'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'signature'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php $i = 1; foreach($pageData as $row){

                                    if(array_key_exists($row['employee'],$employees))
                                    {
                                        $employee_data = $employees[$row['employee']];
                                        if($search_currency != $employee_data['currency']){ continue; }                                    
                                    ?>

                                        <tr class="text-center">
                                            <td><?= $i++; ?></td>
                                            <td><?= $employee_data['name']; ?></td>
                                            <td><?= round_decimels_digits((float)$row['basic_salary']); ?></td>
                                            <td><?= round_decimels_digits((float)$row['total_earning']); ?></td>
                                            <td><?= $row['total_month_days']; ?></td>
                                            <td><?= $row['total_absents']; ?></td>
                                            <td><?= round_decimels_digits((float)$row['total_deduction']); ?></td>
                                            <td><?= round_decimels_digits((float)$row['advance_amount']); ?></td>
                                            <td><?= round_decimels_digits((float)$row['net_salary']); ?></td>
                                            <td><?= $row['narration']; ?></td>
                                            <td></td>
                                        </tr>

                                    <?php } ?>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>