<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'salary_yearly_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'salary_yearly_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'salary_yearly_report'); ?></h2>

                    <form id="salary-yearly-report-search-form" action="<?= url('/salary-report-yearly'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="from">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'from_month'); ?> --</option>
                                                <option value="1" <?php if($search_from == '1'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'january'); ?></option>
                                                <option value="2" <?php if($search_from == '2'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'february'); ?></option>
                                                <option value="3" <?php if($search_from == '3'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'march'); ?></option>
                                                <option value="4" <?php if($search_from == '4'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'april'); ?></option>
                                                <option value="5" <?php if($search_from == '5'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'may'); ?></option>
                                                <option value="6" <?php if($search_from == '6'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'june'); ?></option>
                                                <option value="7" <?php if($search_from == '7'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'july'); ?></option>
                                                <option value="8" <?php if($search_from == '8'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'august'); ?></option>
                                                <option value="9" <?php if($search_from == '9'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'september'); ?></option>
                                                <option value="10" <?php if($search_from == '10'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'October'); ?></option>
                                                <option value="11" <?php if($search_from == '11'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'November'); ?></option>
                                                <option value="12" <?php if($search_from == '12'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'December'); ?></option>
                                                
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="to">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'to_month'); ?> --</option>
                                                <option value="1" <?php if($search_to == '1'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'january'); ?></option>
                                                <option value="2" <?php if($search_to == '2'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'february'); ?></option>
                                                <option value="3" <?php if($search_to == '3'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'march'); ?></option>
                                                <option value="4" <?php if($search_to == '4'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'april'); ?></option>
                                                <option value="5" <?php if($search_to == '5'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'may'); ?></option>
                                                <option value="6" <?php if($search_to == '6'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'june'); ?></option>
                                                <option value="7" <?php if($search_to == '7'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'july'); ?></option>
                                                <option value="8" <?php if($search_to == '8'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'august'); ?></option>
                                                <option value="9" <?php if($search_to == '9'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'september'); ?></option>
                                                <option value="10" <?php if($search_to == '10'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'October'); ?></option>
                                                <option value="11" <?php if($search_to == '11'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'November'); ?></option>
                                                <option value="12" <?php if($search_to == '12'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'December'); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="year">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'year'); ?> --</option>

                                                <?php $current_year = date('Y'); for($y = 0; $y < 5; $y++){ $run_year = $current_year--; ?>
                                                    <option value="<?= $run_year; ?>" <?php if($search_year == $run_year){ echo 'selected="selected"'; } ?>><?= $run_year; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_net_salary'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php

                                $calander_db = fetch_calander_name();
                                $months_array = array(
                                    '1' => print_lang($app_lang,'january'),
                                    '2' => print_lang($app_lang,'february'),
                                    '3' => print_lang($app_lang,'march'),
                                    '4' => print_lang($app_lang,'april'),
                                    '5' => print_lang($app_lang,'may'),
                                    '6' => print_lang($app_lang,'june'),
                                    '7' => print_lang($app_lang,'july'),
                                    '8' => print_lang($app_lang,'august'),
                                    '9' => print_lang($app_lang,'september'),
                                    '10' => print_lang($app_lang,'October'),
                                    '11' => print_lang($app_lang,'November'),
                                    '12' => print_lang($app_lang,'December'),
                                );
                                
                                ?>

                                <?php $i = 1; foreach($pageData as $month => $details){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><a href="<?= url('salary-report-monthly').'?currency='.$search_currency.'&month='.$month.'&year='.$search_year.'&calander_db='.$calander_db; ?>"><?= array_key_exists($month,$months_array) ? $months_array[$month] : NULL; ?></a></td>

                                        <?php
                                        $net_salaries = array();
                                        foreach($details as $row)
                                        {
                                            if(array_key_exists($row['employee'],$employees))
                                            {
                                                $employee_data = $employees[$row['employee']];
                                                if($search_currency == $employee_data['currency'])
                                                {
                                                    $net_salaries[] = (float)$row['net_salary'];
                                                }
                                            }
                                        }
                                        ?>

                                        <td><a href="<?= url('salary-report-monthly').'?currency='.$search_currency.'&month='.$month.'&year='.$search_year.'&calander_db='.$calander_db; ?>"><?= round_decimels_digits(array_sum($net_salaries)); ?></a></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>