<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'sales_service_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_service_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_service_report'); ?></h2>

                    <form id="sales-service-report-search-form" action="<?= url('/reports/sales-service'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="currency">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                        <?php foreach($currencies as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="client">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                        <?php foreach($clients as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $qty_total = array();
                                $qty_cost = array();
                                $qty_sale_price = array();
                                $qty_profit = array();
                                $i = 1; 
                                foreach($pageData as $row){
                                    $qty_total[] = $row['qty'];
                                    $qty_cost[] = $row['cost'];
                                    $qty_sale_price[] = $row['sale_price'];
                                    $qty_profit[] = $row['profit'];
                                ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date($row['date']); ?></td>
                                    <td><a target="_blank" href="<?= url('sales/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice_number']; ?></a></td>
                                    <td><?= ucwords($row['item']); ?></td>
                                    <td><?= $row['unit']; ?></td>
                                    <td><?= $row['qty']; ?></td>
                                    <td><?= $row['cost']; ?></td>
                                    <td><?= $row['sale_price']; ?></td>
                                    <td><?= $row['profit']; ?></td>
                                    <td>
                                        <a href="<?= url('/sales/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i><?= print_lang($app_lang,'invoice'); ?></a>
                                    </td>
                                </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date("Y-m-d")); ?></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= array_sum($qty_total); ?></strong></td>
                                    <td><strong><?= array_sum($qty_cost); ?></strong></td>
                                    <td><strong><?= array_sum($qty_sale_price); ?></strong></td>
                                    <td><strong><?= array_sum($qty_profit); ?></strong></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>
                </div>
            </div>
        </div>
    </div>
    
</div>