<?php $item_settings = get_item_settings(); ?>
<?php if($live_search_data == 'no'){ ?>
<style>
    .pagination {
        margin: 0 !important;
    }
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_sale_stock_rep_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_sale_stock_rep_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_sale_stock_rep_title'); ?></h2>

                    <form id="sale-stock-report-search-form" action="<?= url('/reports/sale-stock'); ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="category">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'category'); ?> --</option>
                                            <?php foreach($product_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_category == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="tpcp">
                                            <option value="tp" <?php if($search_tpcp == 'tp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'tp'); ?></option>
                                            <option value="cp" <?php if($search_tpcp == 'cp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cp'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2" style="padding: 2px;">
                            <div class="form-group">
                                <div>
                                    <select data-placeholder="<?= print_lang($app_lang,'marketer'); ?>" name="marketer" class="chosen-select" multiple tabindex="4">
                                        
                                        <?php foreach($marketers as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if(in_array($row['uid'], $search_marketer)){ echo 'selected="selected"'; } ?>  ><?= $row['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <!-- custom live search -->
                        <div class="custom-search-input" style="position: relative; top: 30px; z-index: 1;">
                            <input style="width: 200px; height: 30px;" type="text" title="Search" placeholder="Search" name="_hp_live_search" value="<?= $_search; ?>" class="form-control" data-params="category,marketer,from,to" data-action="<?= url('/reports/sale-stock'); ?>">
                        </div>
                        <!-- custom live search -->
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_sr'); ?></th>
                                    <th class="text-center" style="min-width: 120px;"><?= print_lang($app_lang,'mod_sale_stock_rep_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_batch'); ?></th>
                                    <th class="text-center" style="min-width: 80px;"><?= print_lang($app_lang,'mod_sale_stock_rep_mfg'); ?></th>
                                    <th class="text-center" style="min-width: 80px;"><?= print_lang($app_lang,'mod_sale_stock_rep_expiry'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_opening'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_purchased'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_bt_in'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_t_in'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_bt_out'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_t_out'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_net_sale'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_closing_stock'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_closing_value'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="page-records-body">
<?php } ?>
                                <?php
                                $i = $records['from'];
                                $branch_transfer_in_units = 0;
                                $branch_transfer_out_units = 0;
                                $avail_units_amount = 0;
                                foreach($pageData as $item)
                                {
                                    $item_stats = _handle_item_inventory(['item' => $item, 'start_date' => $search_from, 'end_date' => $search_to, 'marketer' => $search_marketer]);
                                    $avail_units = $item_stats['closing_units'];
                                    $opening_units = $item_stats['opening_units'];
                                    $item_avg_cost = $item_stats['avg_cost'];
                                    $item_tp = $item_stats['sale_price'];
                                    if(!empty($search_from))
                                    {
                                        $avail_units = $avail_units - $opening_units;
                                    }

                                    $currency_symbol = array_key_exists($item['currency'], $currencies) ? $currencies[$item['currency']]['symbol'] : NULL;
                                    if(!empty($search_currency))
                                    {
                                        $currency_symbol = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['symbol'] : NULL;
                                        $item_avg_cost = amount_conversion($item_avg_cost, $item['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        $item_tp = amount_conversion($item_tp, $item['currency_usd_equalance'], $currency_data['usd_equalance']);
                                    }

                                    if($search_tpcp == 'cp')
                                    {
                                        $item_avg_cost = round_decimels_digits($item_avg_cost);
                                    }
                                    else
                                    {
                                        $item_avg_cost = round_decimels_digits($item_tp);
                                    }

                                    $avail_units_amount = $item_avg_cost * $avail_units;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $item['name']; ?></td>
                                        <td><?= $item_avg_cost; ?></td>
                                        <td><span class="text-info font-bold"><?= array_key_exists($item['purchase_unit'], $units) ? $units[$item['purchase_unit']]['short'] : NULL; ?></span></td>
                                        <td><?= $item_stats['batch']; ?></td>
                                        <td><?= $item_stats['mfg_date']; ?></td>
                                        <td><?= $item_stats['expiry_date']; ?></td>

                                        <td><?= round_decimels_digits( $item_stats['opening_units'] ); $item_opening_units_total[] = $item_stats['opening_units']; ?> </td>
                                        <td><?= round_decimels_digits( $item_stats['purchase'] ); $purchase_units_total[] = $item_stats['purchase']; ?> </td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_in_units ); $branch_transfer_in_units_total[] = $branch_transfer_in_units; ?> </td>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $item_stats['transfer_in'] ); $ph_transfer_in_units_total[] = $item_stats['transfer_in']; ?> </td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_out_units ); $branch_transfer_out_units_total[] = $branch_transfer_out_units; ?> </td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $item_stats['transfer_out'] ); $ph_transfer_out_units_total[] = $item_stats['transfer_out']; ?> </td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits( $item_stats['sales'] ); $sale_units_total[] = $item_stats['sales']; ?> </td>
                                        <td><?= round_decimels_digits( $item_stats['sales_return'] ); $sale_return_units_total[] = $item_stats['sales_return']; ?> </td>
                                        <td><?= round_decimels_digits( $item_stats['net_sales'] ); $net_sale_units_total[] = $item_stats['net_sales']; ?> </td>
                                        <td><?= round_decimels_digits( $avail_units ); $avail_units_total[] = $avail_units; ?> </td>
                                        <td><?= round_decimels_digits( $avail_units_amount ); ?> </td>

                                    </tr>
                                <?php } ?>

<?php if($live_search_data == 'no'){ ?>

                            </tbody>
                        </table>    
                    </div>

                    <div class="pagination-wrap">
                        <div class="row">
                            <div class="col-md-6" id="pagination-stats">
                                <span class="records-stats">Showing <?= (float)$records['from']; ?> - <?= (float)$records['to']; ?> of <?= $records['total']; ?></span>
                            </div>
                            <div class="col-md-6 text-right" id="pagination-pages">
                                <?= $pagination; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>