<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_sale_stock_rep_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_sale_stock_rep_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_sale_stock_rep_title'); ?></h2>

                    <form id="sale-stock-report-search-form" action="<?= url('/reports/sale-stock'); ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="category">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'category'); ?> --</option>
                                            <?php foreach($product_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_category == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="tpcp">
                                            <option value="tp" <?php if($search_tpcp == 'tp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'tp'); ?></option>
                                            <option value="cp" <?php if($search_tpcp == 'cp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cp'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2" style="padding: 2px;">
                            <div class="form-group">
                                <div>
                                    <select data-placeholder="<?= print_lang($app_lang,'marketer'); ?>" name="marketer" class="chosen-select" multiple tabindex="4">
                                        
                                        <?php foreach($marketers as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if(in_array($row['uid'], $search_marketer)){ echo 'selected="selected"'; } ?>  ><?= $row['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_opening'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_purchased'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_bt_in'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_t_in'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_bt_out'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_t_out'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_net_sale'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_b_to_b_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_production_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_production_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_closing_stock'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_closing_value'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1; 
                                $item_opening_units_amount_total = [];
                                $purchase_units_amount_total = [];
                                $ph_transfer_in_units_amount_total = [];
                                $ph_transfer_out_units_amount_total = [];
                                $sale_units_amount_total = [];
                                $sale_return_units_amount_total = [];
                                $net_sale_units_amount_total = [];
                                $items_production_in_units_amount_total = [];
                                $items_production_out_units_amount_total = [];
                                $items_production_in_units_amount_total = [];
                                $items_production_out_units_amount_total = [];
                                $avail_units_total = [];
                                $avail_units_amount_total = [];
                                $branch_id = active_branch_id();
                                foreach($pageData as $row){ 
                                    $item_details = json_decode($row['stats'],true);

                                    // items calculation
                                    $items_registration = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_registration'] : 0;
                                    $items_purchases = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_purchases'] : 0;
                                    $items_purchases_bonus = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_purchases_bonus'] : 0;
                                    $items_transfer_in = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_transfer_in'] : 0;
                                    $items_transfer_in_bonus = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_transfer_in_bonus'] : 0;
                                    $items_return = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_sales_return'] : 0;
                                    $items_return_bonus = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_sales_return_bonus'] : 0;
                                    $items_sales = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_sales'] : 0;
                                    $items_sales_bonus = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_sales_bonus'] : 0;
                                    $items_transfer_out = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_transfer_out'] : 0;
                                    $items_transfer_out_bonus = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_transfer_out_bonus'] : 0;
                                    $items_damage = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_damage'] : 0;
                                    $items_branch_to_branch_transfer_in_units = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_branch_to_branch_transfer_in_units'] : 0;
                                    $items_branch_to_branch_transfer_out_units = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_branch_to_branch_transfer_out_units'] : 0;
                                    $items_production_in_units = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_production_in_units'] : 0;
                                    $items_production_out_units = array_key_exists($row['uid'], $inventory['items_inventory']) ? $inventory['items_inventory'][$row['uid']]['items_production_out_units'] : 0;
                                    // items calculation

                                    if(!empty($search_from))
                                    {
                                        if(!empty($search_marketer))
                                        {
                                            // opening stock calculation
                                            $op_items_registration = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_registration'] : 0;
                                            $op_items_purchases = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_purchases'] : 0;
                                            $op_items_purchases_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_purchases_bonus'] : 0;
                                            $op_items_transfer_in = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_in'] : 0;
                                            $op_items_transfer_in_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_in_bonus'] : 0;
                                            $op_items_return = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers_opening']) ? $inventory['items_sales_and_return_marketers_opening'][$row['uid']]['items_sales_return'] : 0;
                                            $op_items_return_bonus = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers_opening']) ? $inventory['items_sales_and_return_marketers_opening'][$row['uid']]['items_sales_return_bonus'] : 0;
                                            $op_items_sales = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers_opening']) ? $inventory['items_sales_and_return_marketers_opening'][$row['uid']]['items_sales'] : 0;
                                            $op_items_sales_bonus = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers_opening']) ? $inventory['items_sales_and_return_marketers_opening'][$row['uid']]['items_sales_bonus'] : 0;
                                            $op_items_transfer_out = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_out'] : 0;
                                            $op_items_transfer_out_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_out_bonus'] : 0;
                                            $op_items_damage = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_damage'] : 0;
                                            $op_items_branch_to_branch_transfer_in_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_branch_to_branch_transfer_in_units'] : 0;
                                            $op_items_branch_to_branch_transfer_out_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_branch_to_branch_transfer_out_units'] : 0;
                                            $op_items_production_in_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_production_in_units'] : 0;
                                            $op_items_production_out_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_production_out_units'] : 0;
                                            // opening stock calculation

                                            $items_return = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales_return'] : 0;
                                            $items_return_bonus = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales_return_bonus'] : 0;
                                            $items_sales = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales'] : 0;
                                            $items_sales_bonus = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales_bonus'] : 0;
                                        }
                                        else
                                        {
                                            // opening stock calculation
                                            $op_items_registration = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_registration'] : 0;
                                            $op_items_purchases = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_purchases'] : 0;
                                            $op_items_purchases_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_purchases_bonus'] : 0;
                                            $op_items_transfer_in = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_in'] : 0;
                                            $op_items_transfer_in_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_in_bonus'] : 0;
                                            $op_items_return = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_sales_return'] : 0;
                                            $op_items_return_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_sales_return_bonus'] : 0;
                                            $op_items_sales = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_sales'] : 0;
                                            $op_items_sales_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_sales_bonus'] : 0;
                                            $op_items_transfer_out = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_out'] : 0;
                                            $op_items_transfer_out_bonus = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_transfer_out_bonus'] : 0;
                                            $op_items_damage = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_damage'] : 0;
                                            $op_items_branch_to_branch_transfer_in_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_branch_to_branch_transfer_in_units'] : 0;
                                            $op_items_branch_to_branch_transfer_out_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_branch_to_branch_transfer_out_units'] : 0;
                                            $op_items_production_in_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_production_in_units'] : 0;
                                            $op_items_production_out_units = array_key_exists($row['uid'], $inventory['items_inventory_opening']) ? $inventory['items_inventory_opening'][$row['uid']]['items_production_out_units'] : 0;
                                            // opening stock calculation
                                        }
                                    }
                                    else
                                    {
                                        if(!empty($search_marketer))
                                        {
                                            $items_return = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales_return'] : 0;
                                            $items_return_bonus = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales_return_bonus'] : 0;
                                            $items_sales = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales'] : 0;
                                            $items_sales_bonus = array_key_exists($row['uid'], $inventory['items_sales_and_return_marketers']) ? $inventory['items_sales_and_return_marketers'][$row['uid']]['items_sales_bonus'] : 0;
                                        }
                                        // opening stock calculation
                                        $op_items_registration = 0;
                                        $op_items_purchases = 0;
                                        $op_items_purchases_bonus = 0;
                                        $op_items_transfer_in = 0;
                                        $op_items_transfer_in_bonus = 0;
                                        $op_items_return = 0;
                                        $op_items_return_bonus = 0;
                                        $op_items_sales = 0;
                                        $op_items_sales_bonus = 0;
                                        $op_items_transfer_out = 0;
                                        $op_items_transfer_out_bonus = 0;
                                        $op_items_damage = 0;
                                        $op_items_branch_to_branch_transfer_in_units = 0;
                                        $op_items_branch_to_branch_transfer_out_units = 0;
                                        $op_items_production_in_units = 0;
                                        $op_items_production_out_units = 0;
                                        // opening stock calculation
                                    }

                                    $net_sales = ($items_sales + $items_sales_bonus) - ($items_return + $items_return_bonus);
                                    $items_opening_stock = ($op_items_purchases + $op_items_purchases_bonus + $op_items_transfer_in + $op_items_transfer_in_bonus + $op_items_return + $op_items_return_bonus + $op_items_branch_to_branch_transfer_in_units + $op_items_production_in_units) - ($op_items_sales + $op_items_sales_bonus + $op_items_transfer_out + $op_items_transfer_out_bonus + $op_items_damage + $op_items_branch_to_branch_transfer_out_units + $op_items_production_out_units);
                                    // echo ($items_opening_stock).'<br>';
                                    // echo ($items_registration).'<br>';
                                    $available_units = ($items_registration + $items_opening_stock + $items_purchases + $items_purchases_bonus + $items_transfer_in + $items_transfer_in_bonus + $items_return + $items_return_bonus + $items_branch_to_branch_transfer_in_units + $items_production_in_units) - ($items_sales + $items_sales_bonus + $items_transfer_out + $items_transfer_out_bonus + $items_damage + $items_branch_to_branch_transfer_out_units + $items_production_out_units);
                                    // print_rr($available_units);
                                    // items opening stock

                                    // item avg cost
                                    if($row['_avg_cost'] == 0)
                                    {
                                        $avg_cost = (float)$item_details['last_cost'];
                                    }
                                    else
                                    {
                                        $avg_cost = (float)$row['_avg_cost'];
                                    }
                                    $last_profit = (float)$item_details['last_profit'];
                                    // $sale_price = $avg_cost + $last_profit;
                                    $sale_price = (float)$row['sale_price'];
                                    // item avg cost

                                    // expiry and mfg date calculation
                                    $item_batch_last = NULL;

                                    $currency_symbol = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                    if(!empty($search_currency))
                                    {
                                        $currency_symbol = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['symbol'] : NULL;
                                        $avg_cost = amount_conversion($avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        $sale_price = amount_conversion($sale_price, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                    }

                                    if($search_tpcp == 'cp')
                                    {
                                        $avg_cost = round_decimels_digits($avg_cost);
                                    }
                                    else
                                    {
                                        $avg_cost = round_decimels_digits($sale_price);
                                    }

                                    $available_units_amount = $available_units * $avg_cost;
                                    $mfg_date = NULL;
                                    $expiry_date = NULL;
                                    if(!empty($row['last_mfg_date']) AND $row['last_mfg_date'] != '0000-00-00'){$mfg_date = display_true_date($row['last_mfg_date']);}
                                    if(!empty($row['last_expiry_date']) AND $row['last_expiry_date'] != '0000-00-00'){$expiry_date = display_true_date($row['last_expiry_date']);}
                                ?>
                                    <tr class="text-center">                                        
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= $avg_cost; ?></td>
                                        <td><span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span></td>

                                        <td><?= round_decimels_digits($items_opening_stock); $item_opening_units_amount_total[] = $items_opening_stock;  ?></td>
                                        <td><?= round_decimels_digits($items_registration + $items_purchases + $items_purchases_bonus); $purchase_units_amount_total[] = ($items_registration + $items_purchases + $items_purchases_bonus) * $avg_cost;  ?></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td></td>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits($items_transfer_in + $items_transfer_in_bonus); $ph_transfer_in_units_amount_total[] = ($items_transfer_in + $items_transfer_in_bonus) * $avg_cost;  ?></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits($items_transfer_out + $items_transfer_out_bonus); $ph_transfer_out_units_amount_total[] = ($items_transfer_out + $items_transfer_out_bonus) * $avg_cost;  ?></td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits($items_sales + $items_sales_bonus); $sale_units_amount_total[] = ($items_sales + $items_sales_bonus) * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($items_return + $items_return_bonus); $sale_return_units_amount_total[] = ($items_return + $items_return_bonus) * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($net_sales); $net_sale_units_amount_total[] = $net_sales * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($items_branch_to_branch_transfer_in_units); $items_branch_to_branch_transfer_in_units_amount_total[] = $items_branch_to_branch_transfer_in_units * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($items_branch_to_branch_transfer_out_units); $items_branch_to_branch_transfer_out_units_amount_total[] = $items_branch_to_branch_transfer_out_units * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($items_production_in_units); $items_production_in_units_amount_total[] = $items_production_in_units * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($items_production_out_units); $items_production_out_units_amount_total[] = $items_production_out_units * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($available_units); $avail_units_total[] = $available_units * $avg_cost;  ?></td>
                                        <td><?= round_decimels_digits($available_units_amount); $avail_units_amount_total[] = $available_units_amount;  ?></td>

                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><strong></strong></td>
                                        <td><strong><?= print_lang($app_lang,'mod_sale_stock_rep_total_value'); ?></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($item_opening_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($purchase_units_amount_total) ); ?></strong></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <?php //echo round_decimels_digits( array_sum([$branch_transfer_in_units_amount_total]) ); ?>
                                            <td><strong><?php echo round_decimels_digits( array_sum([]) ); ?></strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($ph_transfer_in_units_amount_total) ); ?></strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <?php //echo round_decimels_digits( array_sum($branch_transfer_out_units_amount_total) ); ?>
                                            <td><strong><?php echo round_decimels_digits( array_sum([]) ); ?></strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($ph_transfer_out_units_amount_total) ); ?></strong></td>
                                        <?php } ?>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_return_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($net_sale_units_amount_total) ); ?></strong></td>                                        
                                        <td><strong><?= round_decimels_digits( array_sum($items_production_in_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($items_production_out_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($items_production_in_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($items_production_out_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($avail_units_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($avail_units_amount_total) ); ?></strong></td>
                                        
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>