<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_sale_stock_rep_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_sale_stock_rep_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_sale_stock_rep_title'); ?></h2>

                    <form id="sale-stock-report-search-form" action="<?= url('/reports/sale-stock'); ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="category">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'category'); ?> --</option>
                                            <?php foreach($product_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_category == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="tpcp">
                                            <option value="tp" <?php if($search_tpcp == 'tp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'tp'); ?></option>
                                            <option value="cp" <?php if($search_tpcp == 'cp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cp'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2" style="padding: 2px;">
                            <div class="form-group">
                                <div>
                                    <select data-placeholder="<?= print_lang($app_lang,'marketer'); ?>" name="marketer" class="chosen-select" multiple tabindex="4">
                                        
                                        <?php foreach($marketers as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if(in_array($row['uid'], $search_marketer)){ echo 'selected="selected"'; } ?>  ><?= $row['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_batch'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_mfg'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_expiry'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_opening'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_purchased'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_bt_in'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_t_in'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_bt_out'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_t_out'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_net_sale'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_closing_stock'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_sale_stock_rep_closing_value'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $active_branch_id = active_branch_id();
                                $item_opening_units_total = array();
                                $purchase_units_total = array();
                                $branch_transfer_in_units_total = array();
                                $ph_transfer_in_units_total = array();
                                $total_stock_total = array();
                                $sale_units_total = array();
                                $sale_return_units_total = array();
                                $net_sale_units_total = array();
                                $damage_units_total = array();
                                $branch_transfer_out_units_total = array();
                                $ph_transfer_out_units_total = array();
                                $avail_units_total = array();
                                $item_opening_units_amount_total = array();
                                $purchase_units_amount_total = array();
                                $branch_transfer_in_units_amount_total = array();
                                $ph_transfer_in_units_amount_total = array();
                                $total_stock_amount_total = array();
                                $sale_units_amount_total = array();
                                $sale_return_units_amount_total = array();
                                $net_sale_units_amount_total = array();
                                $damage_units_amount_total = array();
                                $branch_transfer_out_units_amount_total = array();
                                $ph_transfer_out_units_amount_total = array();
                                $avail_units_amount_total = array();
                                $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">                                        
                                        <?php

                                        if(!empty($search_from))
                                        {
                                            // will have items opening stats before from date if from date set in search filter
                                            $item_opening_units = array_key_exists($row['uid'], $opening_stock_units) ? sum_up_array_values($opening_stock_units[$row['uid']]['stats']['avail_units']) : 0;
                                        }
                                        else
                                        {
                                            $item_opening_units = sum_up_array_values($row['stats']['opening_units']);
                                        }
                                        
                                        $purchase_units = sum_up_array_values($row['stats']['purchase_units']);
                                        
                                        $branch_transfer_in_units = sum_up_array_values($row['stats']['branch_transfer_in_units']);
                                        $ph_transfer_in_units = sum_up_array_values($row['stats']['transfer_in_pharma']);
                                        
                                        $total_stock = $item_opening_units + $purchase_units + $branch_transfer_in_units + $ph_transfer_in_units;;
                                        
                                        
                                        $sale_units = sum_up_array_values($row['stats']['sale_units']);
                                        $sale_return_units = sum_up_array_values($row['stats']['sale_return_units']);
                                        $branch_transfer_out_units = sum_up_array_values($row['stats']['branch_transfer_out_units']);
                                        $ph_transfer_out_units = sum_up_array_values($row['stats']['transfer_out_pharma']);
                                        $damage_units = sum_up_array_values($row['stats']['damage_units']);
                                        $net_sale_units = sum_up_array_values($row['stats']['sale_units']) - sum_up_array_values($row['stats']['sale_return_units']);
                                        $avail_units = sum_up_array_values($row['stats']['avail_units']);

                                        $item_avg_cost = $row['stats']['avg_cost'];
                                        $item_last_profit = $row['stats']['last_profit'];
                                        
                                        if(!empty($search_from))
                                        {
                                            $avail_units = $avail_units + $item_opening_units - $row['opening_stock'];
                                        }

                                        $currency_symbol = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                        if(!empty($search_currency))
                                        {
                                            $currency_symbol = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['symbol'] : NULL;
                                            $item_avg_cost = amount_conversion($item_avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_profit = amount_conversion($item_last_profit, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        $batch_sale_price_last = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['uid'])->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->whereNotNull('sale_price')->orderBy('module_created_at','desc')->orderBy('id','desc')->get()->first());
                                        $item_avg_cost_batch = (float)$batch_sale_price_last['sale_price'];
                                        // if($batch_sale_price_last['currency'] == $row['currency'])
                                        // {
                                        //     // no conversion
                                        //     $item_avg_cost_batch = (float)$item_avg_cost_batch;
                                        // }
                                        // else
                                        // {
                                        //     // apply conversion
                                        //     $item_avg_cost_batch = amount_conversion((float)$item_avg_cost_batch, $batch_sale_price_last['currency_usd_equalance'], $row['currency_usd_equalance']);
                                        // }
                                        // print_rr($batch_sale_price_last);
                                        if(!empty($search_currency))
                                        {
                                            $item_avg_cost_batch = amount_conversion($item_avg_cost_batch, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }


                                        $item_tp = (float)$row['sale_price'];
                                        if(!empty($search_currency))
                                        {
                                            $item_tp = amount_conversion($item_tp, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        $item_batch_last_data = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['uid'])->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->whereNotNull('batch')->orderBy('module_created_at','desc')->get()->first());

                                        if(!empty($item_batch_last_data))
                                        {
                                            $item_batch_last = $item_batch_last_data['batch'];
                                        }
                                        else
                                        {
                                            $item_batch_last = NULL;
                                        }

                                        $expiry = std_obj_to_array(DB::table("batch_wise_stock")->where('branch',$active_branch_id)->where('item',$row['uid'])->where('batch',$item_batch_last)->where('status','passed')->where('module','!=','sales')->where('module','!=','transfer_out')->where('module','!=','damage')->where('status','passed')->whereNotNull('expiry_date')->orderBy('module_created_at','desc')->get()->first());
                                        $mfg = std_obj_to_array(DB::table("batch_wise_stock")->where('branch',$active_branch_id)->where('item',$row['uid'])->where('batch',$item_batch_last)->where('status','passed')->where('module','!=','sales')->where('module','!=','transfer_out')->where('module','!=','damage')->where('status','passed')->whereNotNull('mfg_date')->orderBy('module_created_at','desc')->get()->first());

                                        if(empty($expiry['expiry_date'])){ $expiry_date = ''; }else{ $expiry_date = display_true_date($expiry['expiry_date']); }
                                        if(empty($mfg['mfg_date'])){ $mfg_date = ''; }else{ $mfg_date = display_true_date($mfg['mfg_date']); }

                                        if($search_tpcp == 'cp')
                                        {
                                            $item_avg_cost = round_decimels_digits($item_avg_cost);
                                        }
                                        else
                                        {
                                            $item_avg_cost = round_decimels_digits($item_tp);
                                        }

                                        $item_opening_units_amount = $item_opening_units * $item_avg_cost;
                                        $item_opening_units_amount_total[] = $item_opening_units_amount;

                                        $purchase_units_amount = $purchase_units * $item_avg_cost;
                                        $purchase_units_amount_total[] = $purchase_units_amount;

                                        $branch_transfer_in_units_amount = $branch_transfer_in_units * $item_avg_cost;
                                        $branch_transfer_in_units_amount_total[] = $branch_transfer_in_units_amount;

                                        $ph_transfer_in_units_amount = $ph_transfer_in_units * $item_avg_cost;
                                        $ph_transfer_in_units_amount_total[] = $ph_transfer_in_units_amount;

                                        $total_stock_amount = $total_stock * $item_avg_cost;

                                        $sale_units_amount = $sale_units * $item_avg_cost;
                                        $sale_units_amount_total[] = $sale_units_amount;

                                        $sale_return_units_amount = $sale_return_units * $item_avg_cost;
                                        $sale_return_units_amount_total[] = $sale_return_units_amount;

                                        $net_sale_units_amount = $net_sale_units * $item_avg_cost;
                                        $net_sale_units_amount_total[] = $net_sale_units_amount;

                                        $branch_transfer_out_units_amount = $branch_transfer_out_units * $item_avg_cost;
                                        $branch_transfer_out_units_amount_total[] = $branch_transfer_out_units_amount;

                                        $ph_transfer_out_units_amount = $ph_transfer_out_units * $item_avg_cost;
                                        $ph_transfer_out_units_amount_total[] = $ph_transfer_out_units_amount;

                                        $damage_units_amount = $damage_units * $item_avg_cost;

                                        $avail_units_amount = $avail_units * $item_avg_cost;
                                        $avail_units_amount_total[] = $avail_units_amount;

                                        ?>
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= $item_avg_cost; ?></td>
                                        <td><span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span></td>
                                        <td><?= $item_batch_last; ?></td>
                                        <td><?= $mfg_date; ?></td>
                                        <td><?= $expiry_date; ?></td>

                                        <td><?= round_decimels_digits( $item_opening_units ); $item_opening_units_total[] = $item_opening_units; ?> </td>
                                        <td><?= round_decimels_digits( $purchase_units ); $purchase_units_total[] = $purchase_units; ?> </td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_in_units ); $branch_transfer_in_units_total[] = $branch_transfer_in_units; ?> </td>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $ph_transfer_in_units ); $ph_transfer_in_units_total[] = $ph_transfer_in_units; ?> </td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_out_units ); $branch_transfer_out_units_total[] = $branch_transfer_out_units; ?> </td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $ph_transfer_out_units ); $ph_transfer_out_units_total[] = $ph_transfer_out_units; ?> </td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits( $sale_units ); $sale_units_total[] = $sale_units; ?> </td>
                                        <td><?= round_decimels_digits( $sale_return_units ); $sale_return_units_total[] = $sale_return_units; ?> </td>
                                        <td><?= round_decimels_digits( $net_sale_units ); $net_sale_units_total[] = $net_sale_units; ?> </td>
                                        <td><?= round_decimels_digits( $avail_units ); $avail_units_total[] = $avail_units; ?> </td>
                                        <td><?= round_decimels_digits( $avail_units_amount ); ?> </td>

                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><strong></strong></td>
                                        <td><strong><?= print_lang($app_lang,'mod_sale_stock_rep_total_value'); ?></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($item_opening_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($purchase_units_amount_total) ); ?></strong></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($branch_transfer_in_units_amount_total) ); ?></strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($ph_transfer_in_units_amount_total) ); ?></strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($branch_transfer_out_units_amount_total) ); ?></strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($ph_transfer_out_units_amount_total) ); ?></strong></td>
                                        <?php } ?>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_return_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($net_sale_units_amount_total) ); ?></strong></td>                                        
                                        <td><strong><?= round_decimels_digits( array_sum($avail_units_amount_total) ); ?></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($avail_units_amount_total) ); ?></strong></td>
                                        
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>