<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'sales_reports'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_reports'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_reports'); ?></h2>

                    <form id="sales-report-search-form" action="<?= url('/reports/sales'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="client">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                                <?php foreach($clients as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'received'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remaining'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'transport_expenses'); ?></th>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <?php } ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $totals_invoice_total[] = array();
                                $totals_received_total[] = array();
                                $totals_remaining_total[] = array();
                                $totals_trans_exp_total[] = array();
                                $totals_profit_total[] = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><a target="_blank" href="<?= url('sales/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                        <td><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($row['sub_total']); $totals_invoice_total[] = $row['sub_total']; ?></td>
                                        <td><?= round_decimels_digits($row['cash_received']); $totals_received_total[] = $row['cash_received']; ?></td>
                                        <td><?= round_decimels_digits($row['remaining_amount']); $totals_remaining_total[] = $row['remaining_amount']; ?></td>
                                        <td><?= round_decimels_digits($row['trans_expense']); $totals_trans_exp_total[] = $row['trans_expense']; ?></td>
                                        <?php
                                        $item_details = json_decode($row['items_details'],true);
                                        $sale_profits = array();
                                        foreach($item_details as $inner_row)
                                        {
                                            $sale_profits[] = $inner_row['profit'];
                                        }
                                        ?>
                                        <?php if(check_user_access('system_profit') === TRUE){ ?>
                                            <td><?= round_decimels_digits($row['total_profit_amount']); $totals_profit_total[] = $row['total_profit_amount']; ?></td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= round_decimels_digits(array_sum($totals_invoice_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($totals_received_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($totals_remaining_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($totals_trans_exp_total)); ?></td>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <td><?= round_decimels_digits(array_sum($totals_profit_total)); ?></td>
                                    <?php } ?>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>