<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'sales_item_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_item_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_item_report'); ?></h2>

                    <form id="sales-items-report-search-form" action="<?= url('/reports/sales-items'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="currency">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                    <?php foreach($currencies as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="item">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'item'); ?> --</option>
                                                    <?php foreach($items as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="client">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                    <?php foreach($clients as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="marketer">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'marketer'); ?> --</option>
                                                    <?php foreach($marketers as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_marketer == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']." ".$row['last_name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'category'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bonus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bonus_value'); ?></th>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'token_thead'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                $sales_total = array();
                                $total_sales_qty = array();
                                $total_sales_bonus = array();
                                $total_sales_bonus_value = array();
                                $total_token_value = array();
                                $total_sale_amount = array();
                                $total_sale_discount = array();
                                $i = 1;
                                foreach($pageData as $row)
                                {
                                    $item_bonus_value = 0;
                                    $item_details = json_decode($row['items_details'],true);
                                    foreach($item_details as $inner_row)
                                    {
                                        if(!empty($search_item))
                                        {
                                            if($inner_row['item'] != $search_item){ continue; }
                                        }

                                        $item_total_amount = (float)$inner_row['item_total'];
                                        $item_qty = (float)$inner_row['qty'];
                                        $item_bonus = (float)$inner_row['bonus'];
                                        $item_sale_price = (float)$inner_row['sale_price'];
                                        $item_discount_per = (float)$inner_row['discount'];
                                        $item_bonus_value = $item_bonus * $item_sale_price;
                                        
                                        $item_sale_amount = $item_sale_price * $item_qty;
                                        $item_discount_amount = ($item_sale_price * $item_discount_per) / 100;
                                        $item_discount_amount = $item_discount_amount * $item_qty;

                                        $total_sales_qty[] = $item_qty;
                                        $total_sales_bonus[] = $item_bonus;
                                        $total_sales_bonus_value[] = $item_bonus_value;
                                        $total_sale_amount[] = $item_sale_amount;
                                        $total_sale_discount[] = $item_discount_amount;

                                        $unit_name = NULL;
                                        $item_name = NULL;
                                        $item_category = 'NULL';
                                        if(array_key_exists($inner_row['item'], $items))
                                        {
                                            $selected_item = $items[$inner_row['item']];
                                            $item_name = $selected_item['name'];
                                            $item_category = $selected_item['category'];
                                            if($inner_row['unit'] == 'purchase')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['purchase_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL;
                                            }
                                            if($inner_row['unit'] == 'sale')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['sale_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL;
                                            }
                                            if($inner_row['unit'] == 'production')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['production_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL;
                                            }
                                        }
                                        $sales_total[] = $item_total_amount;
                                    ?>

                                        <tr class="text-center">
                                            <td><?= $i++; ?></td>
                                            <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                            <td><?= $item_name; ?></td>
                                            <td><?= array_key_exists($item_category, $product_categories) ? $product_categories[$item_category]['name'] : NULL; ?></td>
                                            <td><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                            <td><a target="_blank" href="<?= url('sales/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                            <td><?= array_key_exists($inner_row['warehouse'], $warehouses) ? $warehouses[$inner_row['warehouse']]['name'] : NULL; ?></td>
                                            <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                            <td><?= round_decimels_digits($inner_row['sale_price']); ?></td>
                                            <td><?= round_decimels_digits($inner_row['qty']); ?></td>
                                            <td><?= round_decimels_digits($inner_row['bonus']); ?></td>
                                            <td><?= round_decimels_digits($item_bonus_value); ?></td>
                                            <?php if($item_settings['item_token'] == 'enable'){ ?>
                                                <td><?= isset($inner_row['item_token']) ? $inner_row['item_token'] : null; $total_token_value[] = isset($inner_row['item_token']) ? (float)$inner_row['item_token'] : 0; ?></td>
                                            <?php } ?>
                                            <td><?= round_decimels_digits($item_sale_amount); ?></td>
                                            <td><?= round_decimels_digits($item_discount_amount); ?></td>
                                            <td><?= $unit_name; ?></td>
                                            <td><?= $inner_row['batch']; ?></td>
                                        </tr>

                                    <?php } ?>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sales_qty)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sales_bonus)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sales_bonus_value)); ?></strong></td>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <td><strong><?= round_decimels_digits(array_sum($total_token_value)); ?></strong></td>
                                    <?php } ?>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sale_amount)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sale_discount)); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(!empty($search_item)){ ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title text-center">
                        <h2 class="font-bold"><?= print_lang($app_lang,'item_sales_graph_heading'); ?></h2>
                      <!--  <p>Following graph presents work performance of last 12 months</p> -->
                    </div>
                    <div class="ibox-content">
                        <div style="width: 80%; margin: 0 auto;">
                            <canvas id="barChart" height="140"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    
</div>




<?php if(!empty($search_item)){ ?>
    <!-- ChartJS-->
    <script src="<?= url('/'); ?>/assets/js/plugins/chartJs/Chart.min.js"></script>

    <script type="text/javascript">
        
        

        // months = ['1','2','3','4','5','6'];
        // pharmacy_incomes = ['200','300','50','500','600','700'];
        months = JSON.parse('<?= json_encode($graph_data['months']); ?>');
        qty = JSON.parse('<?= json_encode($graph_data['qty']); ?>');

        var barData = {
            labels: months,
            datasets: [
                {
                    label: "Item Sales",
                    backgroundColor: 'rgba(26,179,148,0.5)',
                    borderColor: "rgba(26,179,148,0.7)",
                    pointBackgroundColor: "rgba(26,179,148,1)",
                    pointBorderColor: "#ccc",
                    data: qty
                }
            ]
        };

        var barOptions = {
            responsive: true
        };


        var ctx2 = document.getElementById("barChart").getContext("2d");
        new Chart(ctx2, {type: 'bar', data: barData, options:barOptions});
    </script>
<?php } ?>