<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'sale_warehouse_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sale_warehouse_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_warehouse_items_listing'); ?></h2>

                    <form id="warehouses-report-search-form" action="<?= url('/reports/sales-warehouses'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="unit">
                                                <option selected="" value="">-- <?= print_lang($app_lang,'unit'); ?> --</option>
                                                <?php foreach($units as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_unit == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'category'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'avg_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'last_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'first_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'branch_transfer_in_short'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'branch_transfer_out_short'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'damage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'available'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                    $i = 1; 
                                    $total_avg_cost = array();
                                    $total_last_cost = array();
                                    $total_first_cost = array();
                                    $total_sales_price = array();
                                    $total_stock_in_units = array();
                                    $total_stock_out_units = array();
                                    $total_branch_transfer_in_units = array();
                                    $total_branch_transfer_out_units = array();
                                    $total_stock_damage_units = array();
                                    $total_stock_b_to_b_in = array();
                                    $total_stock_b_to_out = array();
                                    $total_stock_production_in = array();
                                    $total_stock_production_out = array();
                                    $total_stock_avail_units = array();
                                    foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= array_key_exists($row['category'], $product_categories) ? $product_categories[$row['category']]['name'] : NULL; ?></td>
                                        
                                        <?php
                                        $currency_name = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                        if(!empty($search_currency))
                                        {
                                            $currency_name = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['name'] : NULL;
                                        }
                                        ?>

                                        <td><?= $currency_name; ?></td>
                                        
                                        <td>
                                            <?php if($row['purchase_unit'] == $search_unit){ ?>
                                                <span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span>
                                            <?php }else if($row['sale_unit'] == $search_unit){ ?>
                                                <span class="text-info font-bold"><?= array_key_exists($row['sale_unit'], $units) ? $units[$row['sale_unit']]['short'] : NULL; ?></span>
                                            <?php }else if($row['production_unit'] == $search_unit){ ?>
                                                <span class="text-info font-bold"><?= array_key_exists($row['production_unit'], $units) ? $units[$row['production_unit']]['short'] : NULL; ?></span>
                                            <?php }else{ ?>
                                                <span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span>
                                            <?php } ?>
                                        </td>

                                        <?php

                                        // currency conversion
                                        $item_avg_cost = $row['stats']['avg_cost'];
                                        $item_last_cost = $row['stats']['last_cost'];
                                        $item_first_cost = $row['cost'];
                                        $item_sale_price = $row['stats']['avg_cost'] + $row['stats']['last_profit'];

                                        $item_stock_in_units = sum_up_array_values($row['stats']['stock_in_units']);
                                        $item_stock_out_units = sum_up_array_values($row['stats']['stock_out_units']);
                                        $item_branch_transfer_in_units = sum_up_array_values($row['stats']['branch_transfer_in_units']);
                                        $item_branch_transfer_out_units = sum_up_array_values($row['stats']['branch_transfer_out_units']);
                                        $item_damage_units = sum_up_array_values($row['stats']['damage_units']);
                                        $item_avail_units = sum_up_array_values($row['stats']['avail_units']);
                                        $item_b_to_b_in_units = sum_up_array_values($row['stats']['branch_to_branch_transfer_in_units']);
                                        $item_b_to_b_out_units = sum_up_array_values($row['stats']['branch_to_branch_transfer_out_units']);
                                        $item_production_in_units = sum_up_array_values($row['stats']['production_in_units']);
                                        $item_production_out_units = sum_up_array_values($row['stats']['production_out_units']);

                                        if(!empty($search_currency))
                                        {
                                            $item_avg_cost = amount_conversion($item_avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_cost = amount_conversion($item_last_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_first_cost = amount_conversion($item_first_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_sale_price = amount_conversion($item_sale_price, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        if(!empty($search_unit))
                                        {
                                            if($row['purchase_unit'] == $search_unit){ $unit_identifier = 'purchase'; }
                                            else if($row['sale_unit'] == $search_unit){ $unit_identifier = 'sale'; }
                                            else if($row['production_unit'] == $search_unit){ $unit_identifier = 'production'; }
                                            else{ $unit_identifier = 'purchase'; }

                                            $item_avg_cost = amount_unit_based_conversion($row,$unit_identifier,$item_avg_cost);
                                            $item_last_cost = amount_unit_based_conversion($row,$unit_identifier,$item_last_cost);
                                            $item_first_cost = amount_unit_based_conversion($row,$unit_identifier,$item_first_cost);
                                            $item_sale_price = amount_unit_based_conversion($row,$unit_identifier,$item_sale_price);

                                            $item_stock_in_units = unit_based_conversion($row,$unit_identifier,$item_stock_in_units);
                                            $item_stock_out_units = unit_based_conversion($row,$unit_identifier,$item_stock_out_units);
                                            $item_branch_transfer_in_units = unit_based_conversion($row,$unit_identifier,$item_branch_transfer_in_units);
                                            $item_branch_transfer_out_units = unit_based_conversion($row,$unit_identifier,$item_branch_transfer_out_units);
                                            $item_damage_units = unit_based_conversion($row,$unit_identifier,$item_damage_units);
                                            $item_avail_units = unit_based_conversion($row,$unit_identifier,$item_avail_units);
                                            $item_b_to_b_in_units = unit_based_conversion($row,$unit_identifier,$item_b_to_b_in_units);
                                            $item_b_to_b_out_units = unit_based_conversion($row,$unit_identifier,$item_b_to_b_out_units);
                                            $item_production_in_units = unit_based_conversion($row,$unit_identifier,$item_production_in_units);
                                            $item_production_out_units = unit_based_conversion($row,$unit_identifier,$item_production_out_units);
                                        }

                                        ?>

                                        <td><?= round_decimels_digits($item_avg_cost); $total_avg_cost[] = $item_avg_cost; ?></td>
                                        <td><?= round_decimels_digits($item_last_cost); $total_last_cost[] = $item_last_cost; ?></td>
                                        <td><?= round_decimels_digits($item_first_cost); $total_first_cost[] = $item_first_cost; ?></td>
                                        <td><?= round_decimels_digits($item_sale_price); $total_sales_price[] = $item_sale_price; ?></td>
                                        
                                        <td><?= round_decimels_digits($item_stock_in_units); $total_stock_in_units[] = $item_stock_in_units; ?></td>
                                        <td><?= round_decimels_digits($item_stock_out_units); $total_stock_out_units[] = $item_stock_out_units; ?></td>
                                        <td><?= round_decimels_digits($item_branch_transfer_in_units); $total_branch_transfer_in_units[] = $item_branch_transfer_in_units; ?></td>
                                        <td><?= round_decimels_digits($item_branch_transfer_out_units); $total_branch_transfer_out_units[] = $item_branch_transfer_out_units; ?></td>
                                        <td><?= round_decimels_digits($item_b_to_b_in_units); $total_stock_b_to_b_in[] = $item_b_to_b_in_units; ?></td>
                                        <td><?= round_decimels_digits($item_b_to_b_out_units); $total_stock_b_to_out[] = $item_b_to_b_out_units; ?></td>
                                        <td><?= round_decimels_digits($item_production_in_units); $total_stock_production_in[] = $item_production_in_units; ?></td>
                                        <td><?= round_decimels_digits($item_production_out_units); $total_stock_production_out[] = $item_production_out_units; ?></td>
                                        <td><?= round_decimels_digits($item_damage_units); $total_stock_damage_units[] = $item_damage_units; ?></td>
                                        <td><?= round_decimels_digits($item_avail_units); $total_stock_avail_units[] = $item_avail_units; ?></td>
                                        
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(date('Y-m-d')); ?></td>
                                        <td><?= print_lang($app_lang,'total'); ?></td>
                                        <td></td>
                                        <td></td>
                                        <td><?= round_decimels_digits(array_sum($total_avg_cost)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_last_cost)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_first_cost)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_sales_price)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_in_units)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_out_units)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_branch_transfer_in_units)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_branch_transfer_out_units)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_b_to_b_in)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_b_to_out)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_production_in)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_production_out)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_damage_units)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_stock_avail_units)); ?></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>