<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'services_items_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'services_items_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'services_items_report'); ?></h2>

                    <form id="services-items-report-search-form" action="<?= url('/reports/services-items'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="currency">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                        <?php foreach($currencies as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="service">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'service'); ?> --</option>
                                                        <?php foreach($services_cat as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_service == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="client">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                        <?php foreach($clients as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="row">
                                        <div class="col-md-6" style="padding: 2px;">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6" style="padding: 2px;">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_rate'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_item_rep_thead_total'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $rate_total = array();
                                $qty_total = array();
                                $total_array = array();
                                $i = 1;
                                foreach($pageData as $row)
                                {
                                    $item_details = json_decode($row['details'],true);
                                    foreach($item_details as $inner_row)
                                    {
                                        if(!empty($search_service))
                                        {
                                            if($inner_row['title_id'] != $search_service){ continue; }
                                        }

                                        $unit = $inner_row['unit'];
                                        $item_qty = (float)$inner_row['qty'];
                                        $item_rate = (float)$inner_row['rate'];
                                        $total = $item_qty * $item_rate;

                                        $qty_total[] = $item_qty;
                                        $rate_total[] = $item_rate;
                                        $total_array[] = $total;
                                    ?>

                                        <tr class="text-center">
                                            <td><?= $i++; ?></td>
                                            <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                            <td><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                            <td><a target="_blank" href="<?= url('services/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                            <td><?= array_key_exists($inner_row['title_id'], $services_cat) ? $services_cat[$inner_row['title_id']]['name'] : NULL; ?></td>
                                            <td><?= $inner_row['unit']; ?></td>
                                            <td><?= round_decimels_digits($inner_row['qty']); ?></td>
                                            <td><?= round_decimels_digits($inner_row['rate']); ?></td>
                                            <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL; ?> <?= round_decimels_digits($total); ?></td>
                                        </tr>

                                    <?php } ?>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><strong><?= $i++; ?></strong></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($qty_total)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($rate_total)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_array)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>
                </div>
            </div>
        </div>
    </div>
    
</div>