<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'shareholder_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'shareholder_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'shareholder_report_listing'); ?></h2>

                    <form id="shareholder-report-search-form" action="<?= url('/reports/shareholder-ledger'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <label><?= print_lang($app_lang,'shareholder_report_filter_thead_currency'); ?></label>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <label><?= print_lang($app_lang,'shareholder_report_filter_thead_shareholder'); ?></label>
                                            <select class="form-control chosen-select" name="shareholder">
                                                <option value="">-- <?= print_lang($app_lang,'shareholder_report_filter_thead_shareholder'); ?> --</option>
                                                <?php foreach($shareholder as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_shareholder == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' '.$row['last_name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'shareholder_report_filter_thead_from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'shareholder_report_filter_thead_to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button style="margin-top: 23px;" class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shareholder_report_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shareholder_report_view_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shareholder_report_view_thead_shareholder'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shareholder_report_view_thead_debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shareholder_report_view_thead_credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shareholder_report_view_thead_balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $total_credit = array();
                                $total_debit = array();
                                $i = 1;
                                foreach($pageData as $row){ 
                                    $credit = $row['credit'];
                                    $debit = $row['debit'];
                                    ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['event_date']); ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td><?= ucfirst($row['shareholder_name']); ?></td>
                                        <td style="color: #3ec007 !important;"><?= amount_number_format($debit); $total_debit[] = $debit; ?></td>
                                        <td style="color: #f90606 !important;"><?= amount_number_format($credit); $total_credit[] = $credit; ?></td>
                                        <td><?= amount_number_format(array_sum($total_debit) - array_sum($total_credit)); ?></td>
                                    </tr>
                                <?php } ?>
                                
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td><?= amount_number_format(array_sum($total_debit)); ?></td>
                                    <td><?= amount_number_format(array_sum($total_credit)); ?></td>
                                    <td><?= amount_number_format(array_sum($total_debit) - array_sum($total_credit)); ?></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>