<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'stock_general_ledger_report_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_general_ledger_report_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <form id="stock-general-ledger-report-search-form" action="<?= url('/reports/stock-general-ledger'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'mod_item_stock_rep_filter_item'); ?></label>
                                        <select class="form-control chosen-select" name="item">
                                            <option disabled="disabled" value="" selected="">-- <?= print_lang($app_lang,'stock_general_ledger_report_filter_item_placehlder'); ?> --</option>
                                            <?php foreach($items as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>  data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name'].' '.$row['details'].' ('.$row['item_id'].')'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'stock_general_ledger_report_filter_unit'); ?></label>
                                        <select class="form-control chosen-select" name="unit">
                                            <option disabled="disabled" value="" selected="">-- <?= print_lang($app_lang,'stock_general_ledger_report_filter_unit_placehlder'); ?> --</option>
                                            <?php if(!empty($search_item_data)){?>
                                                <?php if(isset($search_item_data['production_unit'])){ ?>
                                                    <option <?php if($search_unit == 'purchase'){ echo 'selected="selected"'; } ?> value="purchase"><?= array_key_exists($search_item_data['purchase_unit'],$units) ? $units[$search_item_data['purchase_unit']]['name'] : NULL; ?></option>
                                                    <?php if($search_item_data['purchase_unit'] != $search_item_data['sale_unit']){?>
                                                        <option <?php if($search_unit == 'sale'){ echo 'selected="selected"'; } ?> value="sale"><?= array_key_exists($search_item_data['sale_unit'],$units) ? $units[$search_item_data['sale_unit']]['name'] : NULL; ?></option>
                                                    <?php } ?>

                                                    <?php if($search_item_data['production_unit'] != $search_item_data['purchase_unit'] && $search_item_data['production_unit'] != $search_item_data['sale_unit']){?>
                                                        <option <?php if($search_unit == 'production'){ echo 'selected="selected"'; } ?> value="production"><?= array_key_exists($search_item_data['production_unit'],$units) ? $units[$search_item_data['production_unit']]['name'] : NULL; ?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'stock_general_ledger_report_view_title'); ?></h2>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_action'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_general_ledger_report_thead_balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $debit_totals = [];
                                $credit_totals = [];
                                $balance_totals = [];
                                $details = null;
                                $action = null;
                                $debit = null;
                                $credit = null;
                                $balance = null;

                                $unit_name = null;
                                $i = 1;
                                if(!empty($search_item)){
                                    if($search_unit == 'purchase')
                                    {
                                        $unit_data = isset($units[$search_item_data['purchase_unit']]) ? $units[$search_item_data['purchase_unit']] : [];
                                        $unit_name = isset($unit_data['short']) ? $unit_data['short'] : null;
                                    }
                                    if($search_unit == 'sale')
                                    {
                                        $unit_data = isset($units[$search_item_data['sale_unit']]) ? $units[$search_item_data['sale_unit']] : [];
                                        $unit_name = isset($unit_data['short']) ? $unit_data['short'] : null;
                                    }
                                    if($search_unit == 'production')
                                    {
                                        $unit_data = isset($units[$search_item_data['production_unit']]) ? $units[$search_item_data['production_unit']] : [];
                                        $unit_name = isset($unit_data['short']) ? $unit_data['short'] : null;
                                    }
                                foreach($stats as $row){

                                    if($search_unit == 'purchase')
                                    {
                                        $row['debit'] = $row['purchase_unit_stock_in'] + $row['purchase_unit_bonus_in'];
                                        $row['credit'] = $row['purchase_unit_stock_out'] + $row['purchase_unit_bonus_out'];
                                    }
                                    else if($search_unit == 'sale')
                                    {
                                        $row['debit'] = $row['sale_unit_stock_in'] + $row['sale_unit_bonus_in'];
                                        $row['credit'] = $row['sale_unit_stock_out'] + $row['sale_unit_bonus_out'];
                                    }
                                    else if($search_unit == 'production')
                                    {
                                        $row['debit'] = $row['production_unit_stock_in'] + $row['production_unit_bonus_in'];
                                        $row['credit'] = $row['production_unit_stock_out'] + $row['production_unit_bonus_out'];
                                    }
                                    else
                                    {
                                        $row['debit'] = $row['purchase_unit_stock_in'] + $row['purchase_unit_bonus_in'];
                                        $row['credit'] = $row['purchase_unit_stock_out'] + $row['purchase_unit_bonus_out'];
                                    }

                                    if($row['module_name'] == 'items')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_items_opening');
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_items');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }

                                    if($row['module_name'] == 'purchases')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_purchases_text').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_from').' '.$row['account_name'].' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_purchases');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }


                                    if($row['module_name'] == 'sales')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_sales').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_to').' '.$row['account_name'].' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_sales');
                                        $credit = $row['credit'];
                                        $debit = null;
                                        $credit_totals[] = $row['credit'];
                                    }

                                    if($row['module_name'] == 'sales_return')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_sales_return').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_to').' '.$row['account_name'].' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_sales_return');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }                                 

                                    if($row['module_name'] == 'production_out')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_production_out').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_production');
                                        $credit = $row['credit'];
                                        $debit = null;
                                        $credit_totals[] = $row['credit'];
                                    }

                                    if($row['module_name'] == 'production_in')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_production_in').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_production');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }

                                    if($row['module_name'] == 'transfer_in')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_transfer_in').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_from').' '.$row['account_name'].' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_transfer_in');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }

                                    if($row['module_name'] == 'transfer_out')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_transfer_out').' '.print_lang($app_lang,'stock_general_ledger_report_module_text_to').' '.$row['account_name'].' '.print_lang($app_lang,'stock_general_ledger_report_module_text_invoice').' '.$row['invoice'];
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_transfer_out');
                                        $credit = $row['credit'];
                                        $debit = null;
                                        $credit_totals[] = $row['credit'];
                                    }

                                    if($row['module_name'] == 'damage')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_damage');
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_damage');
                                        $credit = $row['credit'];
                                        $debit = null;
                                        $credit_totals[] = $row['credit'];
                                    }

                                    if($row['module_name'] == 'warehouse_transfer_in')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_warehouse_transfer_in');
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_warehouse_transfer');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }

                                    if($row['module_name'] == 'warehouse_transfer_out')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_warehouse_transfer_out');
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_warehouse_transfer');
                                        $credit = $row['credit'];
                                        $debit = null;
                                        $credit_totals[] = $row['credit'];
                                    }

                                    if($row['module_name'] == 'branch_to_branch_transfer_in')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_branch_to_branch_transfer_in');
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_branch_to_branch_transfer');
                                        $debit = $row['debit'];
                                        $credit = null;
                                        $debit_totals[] = $row['debit'];
                                    }

                                    if($row['module_name'] == 'branch_to_branch_transfer_out')
                                    {
                                        $details = print_lang($app_lang,'stock_general_ledger_report_module_branch_to_branch_transfer_out');
                                        $action = print_lang($app_lang,'stock_general_ledger_report_module_branch_to_branch_transfer');
                                        $credit = $row['credit'];
                                        $debit = null;
                                        $credit_totals[] = $row['credit'];
                                    }
                                    if(empty($credit) AND empty($debit)){continue;}
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['event_date']); ?></td>
                                        <td><?= $details; ?></td>
                                        <td><?= $action; ?></td>
                                        <td style="color: #1caf00 !important;">
                                            <?php if(!empty($debit)){?>
                                                <?= $debit.' ('.$unit_name.')'; ?>
                                            <?php } ?>
                                        </td>
                                        <td style="color: #c80000 !important;">
                                            <?php if(!empty($credit)){?>
                                                <?= $credit.' ('.$unit_name.')'; ?>
                                            <?php } ?>
                                        </td>
                                        <td style="color: #006dff !important;"><?= array_sum($debit_totals) - array_sum($credit_totals).' ('.$unit_name.')'; ?></td>
                                    </tr>
                                <?php }} ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(date('Y-m-d')); ?></td>
                                        <td></td>
                                        <td></td>
                                        <td style="color: #1caf00 !important;">
                                            <?= array_sum($debit_totals); ?>
                                        </td>
                                        <td style="color: #c80000 !important;">
                                            <?= array_sum($credit_totals); ?>
                                        </td>
                                        <td style="color: #006dff !important;"><?= array_sum($debit_totals) - array_sum($credit_totals); ?></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>