<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'stock_in_out_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_in_out_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>
<?php $item_settings = get_item_settings(); //print_rr($pageData['stock_in']); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'stock_in_out_report'); ?></h2>

                    <div class="row">
                        <div class="col-sm-12 b-r">
                            <form role="form" id="stock-in-out-report-search-form" action="<?php echo url('/stock-in-out-report'); ?>">

                                <div class="row" style="margin-bottom: 5px;">
                                    <div class="col-md-9">
                                        <div class="row">
                                            <div class="col-md-2" style="padding: 3px;">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'currency'); ?> </label>
                                                    <select class="form-control chosen-select" name="currency" id="stock-report-currency-dropdown">
                                                        <?php foreach($currencies as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($currency == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-2" style="padding: 3px;">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'client'); ?> </label>
                                                    <select class="form-control chosen-select" name="client">
                                                        <option selected="" value="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                        <?php foreach($clients as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($client == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-2" style="padding: 3px;">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'warehouse'); ?> </label>
                                                    <select class="form-control chosen-select" name="warehouse">
                                                        <option selected="" value="">-- <?= print_lang($app_lang,'warehouse'); ?> --</option>
                                                        <?php foreach($warehouses as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($warehouse == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'from'); ?> </label>
                                                    <?php if($branch_calander == 'persian'){ ?>
                                                        <input type="text" class="form-control persian-date" value="<?= $from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                    <?php }else{ ?>
                                                        <input type="date" class="form-control" name="from" value="<?= $from; ?>">
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'to'); ?> </label>
                                                    <?php if($branch_calander == 'persian'){ ?>
                                                        <input type="text" class="form-control persian-date" value="<?= $to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                    <?php }else{ ?>
                                                        <input type="date" class="form-control" name="to" value="<?= $to; ?>">
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 text-right" style="margin-top: 21px;">
                                        <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                                        <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6" style="border: 1px solid #ece6e6; padding: 20px 5px;">
                            <h3 style="text-align: center;"><?= print_lang($app_lang,'stock_in'); ?></h3>
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover dataTables-view">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'total_qty'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'receipt_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'view'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sr_in = 1;
                                            foreach($stock_in as $row){ ?>
                                            <tr>
                                                <td class="text-center"><?= $sr_in++; ?></td>
                                                <td class="text-center"><?= display_true_date($row['stock_date']); ?></td>
                                                <td class="text-center"><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                                <td class="text-center"><?= $row['total_qty']; ?></td>
                                                <td class="text-center"><?= $row['invoice']; ?></td>
                                                <td class="text-center"><?= array_key_exists($row['warehouse'], $warehouses) ? $warehouses[$row['warehouse']]['name'] : NULL; ?></td>
                                                <td class="text-center">
                                                    <?php if(check_user_access('add_stock_in') === TRUE){ ?>
                                                        <a href="<?= url('/stock-in/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>    
                            </div>
                        </div>
                        <div class="col-md-6" style="border: 1px solid #ece6e6; padding: 20px 5px;">
                            <h3 style="text-align: center;"><?= print_lang($app_lang,'stock_out'); ?></h3>
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover dataTables-view">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'stock_qty_total'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'receipt_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'view'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sr_out = 1;
                                            foreach($stock_out as $row){ ?>
                                            <tr>
                                                <td class="text-center"><?= $sr_out++; ?></td>
                                                <td class="text-center"><?= display_true_date($row['stock_date_out']); ?></td>
                                                <td class="text-center"><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                                <td class="text-center"><?= $row['total_qty']; ?></td>
                                                <td class="text-center"><?= $row['invoice']; ?></td>
                                                <td class="text-center"><?= array_key_exists($row['warehouse'], $warehouses) ? $warehouses[$row['warehouse']]['name'] : NULL; ?></td>
                                                <td class="text-center"><?= $row['gross_total']; ?></td>
                                                <td class="text-center">
                                                    <?php if(check_user_access('add_stock_out') === TRUE){ ?>
                                                        <a href="<?= url('/stock-out/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>    
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>