<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'stock_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>
<?php $item_settings = get_item_settings(); //print_rr($pageData['stock_in']); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'stock_report'); ?></h2>

                    <div class="row">
                        <div class="col-sm-12 b-r">
                            <form role="form" id="stock-report-search-form" action="<?php echo url('/stock-report'); ?>">

                                <div class="row" style="margin-bottom: 5px;">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'currency'); ?> </label>
                                            <select class="form-control chosen-select" name="currency" id="stock-report-currency-dropdown">
                                                <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'client'); ?> </label>
                                            <select class="form-control chosen-select" name="client" id="stock-report-client-dropdown">
                                                <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                                <?php foreach($clients as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'stock_report_receipt_#'); ?> </label>
                                            <select class="form-control chosen-select" name="invoice" id="stock-report-invoice-dropdown">
                                                <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'stock_report_receipt_#'); ?> --</option>
                                                <?php foreach($stock_in_receipts as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_invoice == $row['uid']){echo "selected='selected'";}?>><?= $row['invoice']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <button style="width: 100%; margin-top: 23px;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php if(!empty($pageData['stock_in'])){?>
                    <div class="row" style="margin-top: 10px;">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'agent'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'in_receipt'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'qty_in'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'qty_out'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'qty_ava'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="stock-report-info-table-body">
                                        <tr>
                                            <td class="text-center"><?php echo display_true_date($pageData['stock_in']['stock_date']); ?></td>
                                            <td class="text-center"><?php echo array_key_exists($pageData['stock_in']['client'], $clients) ? $clients[$pageData['stock_in']['client']]['name'] : NULL;?></td>
                                            <td class="text-center"><?= $pageData['stock_in']['agent']; ?></td>
                                            <td class="text-center"><?php echo array_key_exists($pageData['stock_in']['warehouse'], $warehouse) ? $warehouse[$pageData['stock_in']['warehouse']]['name'] : NULL;?></td>
                                            <td class="text-center"><?= $pageData['stock_in']['invoice']; ?></td>
                                            <td class="text-center"><?= $pageData['stock_in']['total_qty']; ?></td>
                                            <td class="text-center"><?= $pageData['out_qty']; ?></td>
                                            <td class="text-center"><?= $pageData['ava_qty']; ?></td>
                                        </tr>
                                    </tbody>
                                </table>    
                            </div>
                        </div>
                    </div>


                    <div class="row" style="margin-top: 10px;">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'total_item_qty'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'receipt_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'receipt_total'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'paid'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'pending'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="stock-report-out-info-table-body">
                                        <?php
                                        $sr = 1;
                                        $gross_total = array();
                                        $paid = array();
                                        $pending = array();
                                        $total_qty = array();
                                        foreach($pageData['stock_out'] as $row){
                                            $gross_total[] = $row['gross_total'];
                                            $paid[] = $row['cash_paid'];
                                            $pending[] = $row['pending'];
                                            $total_qty[] = $row['total_qty'];
                                        ?>
                                        <tr>
                                            <td class="text-center"><?= $sr++;?></td>
                                            <td class="text-center"><?php echo display_true_date($row['stock_date_out']); ?></td>
                                            <td class="text-center"><?= $row['total_qty']; ?></td>
                                            <td class="text-center"><?php echo array_key_exists($row['warehouse'], $warehouse) ? $warehouse[$row['warehouse']]['name'] : NULL;?></td>
                                            <td class="text-center"><?= $row['invoice']; ?></td>
                                            <td class="text-center"><?= $row['gross_total']; ?></td>
                                            <td class="text-center"><?= $row['cash_paid']; ?></td>
                                            <td class="text-center"><?= $row['pending']; ?></td>
                                            <td class="text-center">
                                                <?php if(check_user_access('add_stock_out') === TRUE){ ?>
                                                    <a href="<?= url('/stock-out/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                                <?php } ?>
                                                <?php if(check_user_access('edit_stock_out') === TRUE){ ?>
                                                    <a href="<?= url('/stock-out/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i></a>
                                                <?php } ?>
                                                <?php if(check_user_access('delete_stock_out') === TRUE){ ?>
                                                    <a href="<?= url('/stock-out/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i></a>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                        <?php } ?>

                                        <tr>
                                            <td class="text-center"><?= $sr++;?></td>
                                            <td class="text-center"><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                            <td class="text-center"><strong><?= array_sum($total_qty); ?></strong></td>
                                            <td class="text-center"></td>
                                            <td class="text-center"></td>
                                            <td class="text-center"><strong><?= array_sum($gross_total); ?></strong></td>
                                            <td class="text-center"><strong><?= array_sum($paid); ?></strong></td>
                                            <td class="text-center"><strong><?= array_sum($pending); ?></strong></td>
                                            <td class="text-center"></td>
                                        </tr>

                                    </tbody>
                                </table>    
                            </div>
                        </div>
                    </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    </div>
</div>