<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'stock_warehouse_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_warehouse_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>
<?php $item_settings = get_item_settings(); //print_rr($pageData['stock_in']); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'stock_warehouse_report'); ?></h2>

                    <div class="row">
                        <div class="col-sm-12 b-r">
                            <form role="form" id="stock-warehouse-report-search-form" action="<?php echo url('/warehouse-report'); ?>">

                                <div class="row" style="margin-bottom: 5px;">
                                    <div class="col-md-9">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'client'); ?></label>
                                                    <select class="form-control chosen-select" name="client">
                                                        <option selected="" value="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                        <?php foreach($clients as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($client == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'from'); ?></label>
                                                    <?php if($branch_calander == 'persian'){ ?>
                                                        <input type="text" class="form-control persian-date" value="<?= $from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                    <?php }else{ ?>
                                                        <input type="date" class="form-control" name="from" value="<?= $from; ?>">
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'to'); ?></label>
                                                    <?php if($branch_calander == 'persian'){ ?>
                                                        <input type="text" class="form-control persian-date" value="<?= $to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                    <?php }else{ ?>
                                                        <input type="date" class="form-control" name="to" value="<?= $to; ?>">
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 text-right" style="margin-top: 21px;">
                                        <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                                        <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover dataTables-view">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'agent'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'qty_in'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'qty_out'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'qty_ava'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'in_receipt'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sr_in = 1;
                                            foreach($pageData as $row){ ?>
                                            <tr>
                                                <td class="text-center"><?= $sr_in++; ?></td>
                                                <td class="text-center"><?= display_true_date($row['stock_date']); ?></td>
                                                <td class="text-center"><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                                <td class="text-center"><?= $row['agent']; ?></td>
                                                <td class="text-center"><?= $row['item']; ?></td>
                                                <td class="text-center"><?= $row['unit']; ?></td>
                                                <td class="text-center"><?= $row['qty_in']; ?></td>
                                                <td class="text-center"><?= $row['qty_out']; ?></td>
                                                <td class="text-center"><?= $row['qty_ava']; ?></td>
                                                <td class="text-center"><?= $row['invoice']; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>    
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>