<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_title'); ?></h2>

                    <form id="transfer-in-report-search-form" action="<?= url('/reports/transfer-in-discount-2'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_th_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_transfer_out_dis_2_rep_discount'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_sales_amount = array();
                                $total_discount_per = array();
                                $total_discount_amount = array();
                                $i = 1;
                                foreach($pageData as $row){ ?>
                                    <?php
                                    $purchase_percentages = array();
                                    $purchase_items = json_decode($row['items'],true);
                                    foreach($purchase_items as $inner_row)
                                    {
                                        $purchase_percentages[] = isset($inner_row['discount']) ? $inner_row['discount_2'] : NULL;
                                    }
                                    ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><a target="_blank" href="<?= url('transfer-out/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                        <td><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($row['grand_total']); $total_sales_amount[] = $row['grand_total']; ?></td>
                                        <td><?= round_decimels_digits($row['total_discount_amount_2']); $total_discount_amount[] = $row['total_discount_amount_2']; ?></td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><strong><?= $i++; ?></strong></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sales_amount)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_discount_amount)); ?></strong></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>