<style type="text/css">
    .blink_me {
      animation: blinker 0.6s linear infinite;
    }

    @keyframes blinker {
      50% {
        opacity: 0;
      }
</style>
<div id="confirm_msg_div" class="row wrapper border-bottom white-bg page-heading confirm-leave">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_sale'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/sales'); ?>"><?= print_lang($app_lang,'sales'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_sale'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>

<?php
$item_settings = get_item_settings();
if($item_settings['item_measurements'] == 'get')
{
    $items_input_width_class = 'col-md-6';
    $batch_input_width_class = 'col-md-3';
    $unit_input_width_class = 'col-md-3';
}
else
{
    $items_input_width_class = 'col-md-4';
    $batch_input_width_class = 'col-md-2';
    $unit_input_width_class = 'col-md-3';
}

$first_row_width = 'col-md-12';
$first_row_extra_inputs = 'display-none';
// fuel parts inputs
if($item_settings['fuel_parts'] == 'enable')
{
    $first_row_width = 'col-md-9';
    $first_row_extra_inputs = 'col-md-3';
}
?>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?> &nbsp;&nbsp;&nbsp;<span class="customer-address-span"><?= print_lang($app_lang,'customer_address'); ?>:</span>&nbsp;&nbsp;&nbsp;<span class="customer-address-span-text text-danger"></span></h5>
        
        <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
            <a href="javascript:void(0);" class="btn btn-primary btn-facebook btn-outline sets-modal-btn">
                <i class="fa fa-plus"> </i> <?= print_lang($app_lang,'mod_items_sets_sales_popup_btn'); ?>
            </a>
            <a class="btn btn-primary btn-facebook btn-outline" data-toggle="modal" data-target="#extra-service-modal">
                <i class="fa fa-plus"> </i> <?= print_lang($app_lang,'extra_service'); ?>
            </a>
            <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.get_serial_id('sales'); ?>" placeholder="<?= print_lang($app_lang,'invoice_#'); ?>" readonly="">
        </div>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <?php if(check_user_access('system_profit') === TRUE){ ?>
            <input type="hidden" name="system_profit" id="system_profit" value="yes">
        <?php }else{ ?>
            <input type="hidden" name="system_profit" id="system_profit" value="no">
        <?php } ?>
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="sales-items-temp-form">

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="<?= $first_row_width; ?>">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="row">
                                        <div class="col-md-4 sales-fix-row <?php if(!empty($quotation_data['uid'])){ echo 'pointer-none'; } ?>">
                                            <div class="form-group">
                                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                                <select class="form-control chosen-select" name="temp_currency">
                                                    <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                    <?php foreach($currencies as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>" <?php if($quotation_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>

                                        <?php 
                                            if($item_settings['distribution'] == 'disable')
                                            {
                                                $col_length = 6;
                                            }
                                            else
                                            {
                                                $col_length = 3;
                                            }
                                        ?>


                                        <div class="col-md-<?= $col_length; ?>" style="padding: 2px;">
                                            <div class="form-group">
                                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong>&nbsp;&nbsp;<span id="sales-client-balance-span" class="blink_me" style="font-size: 15px; font-weight: 700; color: red;"></span></label>
                                                <select class="form-control chosen-select temp_client_edit" name="temp_client" id="sales-add-client-dropdown">
                                                    <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                                                    <?php foreach($clients as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" data-address="<?= $row['address']; ?>" <?php if($quotation_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Client)'; ?></option>
                                                    <?php } ?>
                                                    <?php if($item_settings['b_to_b_business'] == 'enable'){?>
                                                        <?php foreach($suppliers as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" data-address="<?= $row['address']; ?>" <?php if($quotation_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Supplier)'; ?></option>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>

                                        <?php if($item_settings['distribution'] == 'enable'){ ?>
                                            <div class="col-md-3 <?php if(!empty($is_marketer)){echo "pointer-none";}?>" style="padding: 2px;">
                                                <div class="form-group">
                                                    <label><?= print_lang($app_lang,'marketer'); ?> <strong class="text-danger">*</strong></label>
                                                    <select class="form-control chosen-select temp_marketer_edit" name="temp_marketer" id="sales-add-marketer-dropdown">
                                                        <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'marketer'); ?> --</option>
                                                        <?php foreach($marketers as $row){ ?>
                                                            <option <?php if($is_marketer == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        
                                        <div class="col-md-2" style="padding: 2px;">
                                            <div class="form-group">
                                                <label><?= print_lang($app_lang,'invoice_#'); ?> <strong class="text-danger">*</strong></label>
                                                <input type="text" class="form-control pointer-none" name="temp_invoice" value="<?= $invoice_number; ?>" placeholder="<?= print_lang($app_lang,'invoice_#'); ?>" readonly="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'date'); ?></label>
                                        <?php $edate = display_true_date( date('y-m-d') ); ?>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="temp_sdate" value="<?= true_date_for_inputs($edate); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="temp_sdate" value="<?= date("Y-m-d",strtotime(true_date_for_inputs($edate))); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'memo'); ?></label>
                                        <textarea style="height: 35px;" class="form-control temp_memo_edit" name="temp_memo" rows="1" placeholder="<?= print_lang($app_lang,'memo'); ?>"><?= $quotation_data['memo']; ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="<?= $first_row_extra_inputs; ?>">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'agent'); ?></label>
                                        <input type="text" class="form-control" name="temp_agent" placeholder="<?= print_lang($app_lang,'agent'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'plate_num'); ?></label>
                                        <input type="text" class="form-control" name="temp_plate_num" placeholder="<?= print_lang($app_lang,'plate_num'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="<?= $items_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_item">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                            <?php $icount = 1; foreach($items as $row){ ?>
                                                <?php
                                                $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                                $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                                foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                                    $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouse) ? $warehouse[$warehouse_uid]['name'] : NULL;
                                                ?>
                                                    <option value="<?= $row['uid']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-item-currency="<?= $row['currency']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-last-cost="<?= $row['stats']['last_cost']; ?>" data-last-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].' - '.$row['details'].' - '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="<?= $batch_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'batch'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_batch">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_batch'); ?> --</option>
                                        </select>
                                    </div>
                                </div>
                                <?php if($item_settings['item_measurements'] != 'get'){ ?>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                            <input type="number" class="form-control" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="<?= $unit_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_unit">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'bonus'); ?></label>
                                <input type="number" class="form-control" name="temp_bonus" placeholder="<?= print_lang($app_lang,'bonus'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'extra_narration'); ?></label>
                                <textarea style="height: 35px;" class="form-control" name="temp_narration" rows="1" placeholder="<?= print_lang($app_lang,'extra_narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                        <div class="row" style="margin-bottom: 5px;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'width'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_width" placeholder="<?= print_lang($app_lang,'width'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'height'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_height" placeholder="<?= print_lang($app_lang,'height'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control sale-item-qty-iput" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'m2'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control sale-item-m2-iput" name="temp_m2" placeholder="<?= print_lang($app_lang,'m2'); ?>">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="row extra-mar-botm" id="cash-sale-client-info-row" <?php if(strpos($quotation_data['client'],"CASHSALE") === FALSE){echo "style='display: none'";}else{echo "style='display: block'";} ?>>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client_name_sale'); ?></label>
                                <input type="text" name="temp_client_name" class="form-control temp_client_name_edit" placeholder="<?= print_lang($app_lang,'client_name_sale'); ?>" value="<?= $quotation_data['cash_client_name']; ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client_mob_sale'); ?></label>
                                <input type="text" name="temp_client_mobile" class="form-control temp_client_mobile_edit" placeholder="<?= print_lang($app_lang,'client_mob_sale'); ?>" value="<?= $quotation_data['cash_client_mobile']; ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_to_sale'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="sales-form" action="<?php echo url('/sales/save'); ?>">
            <input type="hidden" name="system_item_token" value="<?= $item_settings['item_token']; ?>">
            <input type="hidden" name="system_bundle_toop" value="<?= $item_settings['bundle_toop']; ?>">
            <input type="hidden" name="system_distribution" id="system_distribution" value="<?= $item_settings['distribution']; ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-8">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <?php if($item_settings['distribution'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'discount_2'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'bundle_thead'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'toop_thead'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'token_thead'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="sales-items-table-body" class="<?php if($item_settings['fuel_parts'] == 'enable'){ echo 'fuel-parts-are-enabled'; }?>">
                                <?php
                                $item_details = json_decode($quotation_data['items_details'],true);
                                foreach($item_details as $row){
                                    $sale_item_data = fetch_table_where('items','uid',$row['item'],true);
                                ?>
                                    <tr class="text-center sales-item-row">

                                        <td class="sales-item-self">
                                            <span><?= isset($sale_item_data['name']) ? $sale_item_data['name'] : NULL; ?></span>
                                            <input type="hidden" name="currency[]" value="<?= $quotation_data['currency']; ?>">
                                            <input type="hidden" class="client_edit_input" name="client[]" value="<?= $quotation_data['client']; ?>">
                                            <input type="hidden" name="invoice[]" value="<?= $invoice_number; ?>">
                                            <input type="hidden" class="memo_edit_input" name="memo[]" value="<?= $quotation_data['memo']; ?>">
                                            <input type="hidden" name="item[]" value="<?= $row['item']; ?>">
                                            <?php
                                                $item_uqid = isset($row['item_uqid']) ? $row['item_uqid'] : NULL;
                                            ?>
                                            <input type="hidden" name="item_uqid[]" value="<?= $item_uqid; ?>">
                                            <input type="hidden" name="batch[]" value="<?= $row['batch']; ?>">
                                            <input type="hidden" name="warehouse[]" value="<?= $row['warehouse']; ?>">
                                            <input type="hidden" name="narration[]" value="<?= $row['narration']; ?>">
                                            
                                            <input type="hidden" name="plate[]" value="<?= isset($row['plate']) ? $row['plate'] : NULL; ?>">
                                            <input type="hidden" name="agent[]" value="<?= isset($row['agent']) ? $row['agent'] : NULL; ?>">
                                            
                                            <input type="hidden" name="m2[]" value="<?= $row['m2']; ?>" class="item-m2-iput">
                                            <input type="hidden" name="width[]" value="<?= $row['width']; ?>" class="item-width-iput">
                                            <input type="hidden" name="height[]" value="<?= $row['height']; ?>" class="item-height-iput">
                                            <input type="hidden" class="cash_client_name_input" name="cash_client_name[]" value="<?= $quotation_data['cash_client_name']; ?>">
                                            <input type="hidden" class="cash_client_mobile_input" name="cash_client_mobile[]" value="<?= $quotation_data['cash_client_mobile']; ?>">
                                        </td>
                                        <td class="sales-item-warehouse">
                                            <span>
                                                <?php
                                                    $sale_item_data = isset($sale_item_data['uid']) ? $sale_item_data : array('purchase_unit' => NULL, 'sale_unit' => NULL, 'production_unit' => NULL);
                                                    $sale_item_unit_name = NULL;
                                                    if($row['unit'] == 'purchase')
                                                    {
                                                        $sale_item_unit_name = array_key_exists($sale_item_data['purchase_unit'],$units) ? $units[$sale_item_data['purchase_unit']]['name'] : NULL;
                                                    }
                                                    if($row['unit'] == 'sale')
                                                    {
                                                        $sale_item_unit_name = array_key_exists($sale_item_data['sale_unit'],$units) ? $units[$sale_item_data['sale_unit']]['name'] : NULL;
                                                    }
                                                    if($row['unit'] == 'production')
                                                    {
                                                        $sale_item_unit_name = array_key_exists($sale_item_data['production_unit'],$units) ? $units[$sale_item_data['production_unit']]['name'] : NULL;
                                                    }
                                                    echo $sale_item_unit_name;
                                                ?>
                                            </span>
                                            <input type="hidden" name="unit[]" value="<?= $row['unit']; ?>">
                                        </td>
                                        <td class="sales-item-cost">
                                            <span><?= amount_number_format($row['cost']); ?></span>
                                            <input type="hidden" name="cost[]" value="<?= $row['cost']; ?>">
                                        </td>
                                        <td class="sales-item-sale-price">
                                            <input type="number" name="sale_price[]" value="<?= $row['sale_price']; ?>" class="sales-editable-iputs">
                                        </td>
                                        <td class="sales-item-qty">
                                            <input type="number" name="qty[]" value="<?= $row['qty']; ?>" class="sales-editable-iputs">
                                        </td>
                                        <td class="sales-item-discount">
                                            <input type="number" name="discount[]" value="<?= $row['discount']; ?>" class="sales-editable-iputs">
                                        </td>
                                        <td class="sales-item-profit">
                                            <span><?= amount_number_format($row['profit']); ?></span>
                                            <input type="hidden" name="profit[]" value="<?= $row['profit']; ?>">
                                        </td>
                                        <td class="sales-item-total">
                                            <span><?= amount_number_format($row['item_total']); ?></span>
                                            <input type="hidden" name="item_total[]" value="<?= $row['item_total']; ?>">
                                        </td>
                                        <td>
                                            <a class="btn btn-danger btn-sm sales-item-del-trigger" href="javascript:void(0);"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>
                    
                    <div class="row sales-under-table-totals">
                        <div class="col-md-3 total-sales-cel">
                            <strong><?= print_lang($app_lang,'total_sale'); ?>: </strong>
                            <span><?= amount_number_format($quotation_data['total_sales_amount']); ?></span>
                            <input type="hidden" name="total_sales_amount" value="<?= $quotation_data['total_sales_amount']; ?>">
                        </div>
                        <div class="col-md-3 total-diss-cel">
                            <strong><?= print_lang($app_lang,'total_discount'); ?>: </strong>
                            <span><?= amount_number_format($quotation_data['total_discount_amount']); ?></span>
                            <input type="hidden" name="total_discount_amount" value="<?= $quotation_data['total_discount_amount']; ?>">
                            <input type="hidden" name="total_discount_amount_1" class="sales-discount-amount-1">
                            <input type="hidden" name="total_discount_amount_2" class="sales-discount-amount-2">
                        </div>
                        <div class="col-md-3 gross-total-cel">
                            <strong><?= print_lang($app_lang,'gross_total'); ?>: </strong>
                            <span><?= amount_number_format($quotation_data['gross_total_amount']); ?></span>
                            <input type="hidden" name="gross_total_amount" value="<?= $quotation_data['gross_total_amount']; ?>">
                        </div>
                        <div class="col-md-3 total-profit-cel">
                            <strong><?= print_lang($app_lang,'total_profit'); ?>: </strong>
                            <span><?= amount_number_format($quotation_data['total_profit_amount']); ?></span>
                            <input type="hidden" name="total_profit_amount" value="<?= $quotation_data['total_profit_amount']; ?>">
                        </div>
                    </div>

                </div>

                <div class="col-md-4 bg-muted items-calculations-wrapper sales-totals-box">
                    <div class="row items-calculations-row sales-total-amount-row" style="margin-top: 10px;">
                        <div class="col-md-4" style="padding-right: 0;">
                            <strong><?= print_lang($app_lang,'sales_total'); ?>: </strong>
                        </div>
                        <div class="col-md-8">
                            <span class="cals-span"><?= amount_number_format($quotation_data['gross_total_amount']); ?></span>
                            <input class="cals-input" type="hidden" name="sales_total" value="<?= $quotation_data['gross_total_amount']; ?>">
                        </div>
                    </div>
                    <div class="row items-calculations-row sales-trans-exp-row">
                        <div class="col-md-4" style="padding-right: 0;">
                            <strong><?= print_lang($app_lang,'transport_expenses'); ?>: </strong>
                        </div>
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-5 sales_trans_exp_input" style="padding-right: 0;">
                                    <input class="cals-input" type="number" name="trans_expense">
                                </div>
                                <div class="col-md-7 sales_trans_exp_account" style="padding-left: 0;">
                                    <select class="form-group chosen-select" name="expense_account">
                                        <option disabled="" selected="">- <?= print_lang($app_lang,'account'); ?> -</option>
                                        <?php foreach($accounts as $row){ ?>
                                            <?php if($row['type'] == 'expense' OR $row['type'] == 'cashbook' OR $row['type'] == 'transit'){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row items-calculations-row sales-sub-total-row">
                        <div class="col-md-4" style="padding-right: 0;">
                            <strong><?= print_lang($app_lang,'sub_total'); ?>: </strong>
                        </div>
                        <div class="col-md-8">
                            <span class="cals-span"><?= amount_number_format($quotation_data['gross_total_amount']); ?></span>
                            <input class="cals-input" type="hidden" name="sub_total" value="<?= $quotation_data['gross_total_amount']; ?>">
                        </div>
                    </div>
                    <div class="row items-calculations-row sales-cash-received-row">
                        <div class="col-md-4" style="padding-right: 0;">
                            <strong><?= print_lang($app_lang,'cash_received'); ?>: </strong>
                        </div>
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-5 sales_trans_exp_input" style="padding-right: 0;">
                                    <input class="cals-input" type="number" name="cash_received">
                                </div>
                                <div class="col-md-7 sales_trans_exp_account" style="padding-left: 0;">
                                    <select class="form-group chosen-select" name="cash_received_account">
                                        <option disabled="" selected="">- <?= print_lang($app_lang,'account'); ?> -</option>
                                        <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                            <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                        <?php }} ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row items-calculations-row sales-remaining-amount-row">
                        <div class="col-md-4" style="padding-right: 0;">
                            <strong><?= print_lang($app_lang,'remaining'); ?>: </strong>
                        </div>
                        <div class="col-md-8">
                            <span class="cals-span"><?= amount_number_format($quotation_data['gross_total_amount']); ?></span>
                            <input class="cals-input" type="hidden" name="remaining_amount" value="<?= $quotation_data['gross_total_amount']; ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div>
                                    <label class="checkbox-inline i-checks">
                                        <input type="radio" name="delivery_type" value="full" id="delivery_type_full_checkbox" checked> &nbsp; <?= print_lang($app_lang,'full_delivery'); ?>
                                    </label>
                                    <label class="checkbox-inline i-checks">
                                        <input type="radio" name="delivery_type" value="pending" id="delivery_type_pending_checkbox"> &nbsp; <?= print_lang($app_lang,'pending_delivery'); ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <input class="cals-input" type="hidden" name="quotation_id" value="<?= $quotation_data['uid']; ?>">
                            <input type="submit" style="width: 100%;" class="btn btn-primary btn-sm" value="<?= print_lang($app_lang,'save_print'); ?>">
                        </div>
                    </div>
                </div>

            </div>
        </form>

    </div>

</div>


<div class="modal inmodal" id="sets-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
    <form id="sales-sets-form">        
        <div class="modal-content animated fadeInRight">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'mod_items_sets_sales_popup_title'); ?></h4>
            </div>
            <div class="modal-body" style="background: #fff;">
                <div class="row extra-mar-botm">
                    <div class="col-md-12" style="padding: 5px;">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_items_sets_sales_popup_select_sets'); ?> <strong class="text-danger">*</strong></label>
                            <select class="form-group chosen-select" name="set_select">
                                <option disabled="" selected="">- <?= print_lang($app_lang,'mod_items_sets_sales_popup_select_sets'); ?> -</option>
                                <?php foreach($sets as $row){ ?>
                                    <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'mod_items_sets_sales_popup_select_add'); ?></button>
            </div>
        </form>
    </div>
</div>