<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'sales_man_rep_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/sales-man'); ?>"><?= print_lang($app_lang,'sales_man_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_man_rep_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">

        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_man_rep_view_title'); ?></h2>
                    <form id="sales-man-report-search-form" action="<?= url('/sales-man/report').'/'.$uid; ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'sales_man_rep_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_mobile'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_net_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_received'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_rep_view_thead_pending'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                if(!empty($pageData)){
                                $i = 1; 
                                $return_total = 0;
                                $net_sales = 0;
                                $active_branch_id = active_branch_id();
                                $sales_total = array();
                                $return_totals = array();
                                $net_sales_total = array();
                                $received_total = array();
                                $pending_total = array();
                                foreach($pageData as $row){
                                    $return_total = DB::table('sales_return')->where('branch',$active_branch_id)->where('currency',$row['currency'])->where('client',$row['client_uid'])->sum('refund_total');
                                    $net_sales = (float)$row['sales'] - $return_total;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= ucfirst($row['name']); ?></td>
                                        <td><?= ucfirst($row['mobile']); ?></td>
                                        <td><?= $currency_symbol.' '.amount_number_format((float)$row['sales']); $sales_total[] = (float)$row['sales']; ?></td>
                                        <td><?= $currency_symbol.' '.amount_number_format($return_total); $return_totals[] = $return_total; ?></td>
                                        <td><?= $currency_symbol.' '.amount_number_format($net_sales); $net_sales_total[] = $net_sales; ?></td>
                                        <td><?= $currency_symbol.' '.amount_number_format((float)$row['received']); $received_total[] = (float)$row['received']; ?></td>
                                        <td><?= $currency_symbol.' '.amount_number_format((float)$row['remaining']); $pending_total[] = (float)$row['remaining']; ?></td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td></td>
                                        <td><strong><?= display_true_date(date("Y-m-d")); ?></strong></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td><strong><?= $currency_symbol.' '.amount_number_format(array_sum($sales_total)); ?></strong></td>
                                        <td><strong><?= $currency_symbol.' '.amount_number_format(array_sum($return_totals)); ?></strong></td>
                                        <td><strong><?= $currency_symbol.' '.amount_number_format(array_sum($net_sales_total)); ?></strong></td>
                                        <td><strong><?= $currency_symbol.' '.amount_number_format(array_sum($received_total)); ?></strong></td>
                                        <td><strong><?= $currency_symbol.' '.amount_number_format(array_sum($pending_total)); ?></strong></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>