<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'sales_man_sales_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/sales-man'); ?>"><?= print_lang($app_lang,'sales_man_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_man_sales_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_man_sales_view_title'); ?></h2>

                    <form id="sales-man-sales-search-form" action="<?= url('/sales-man/sales').'/'.$uid; ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'convert_currency'); ?></label>
                                        <select class="form-control chosen-select" name="convert_currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'convert_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_convert_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'client'); ?></label>
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_total_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'received'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remaining'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'transport_expenses'); ?></th>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $total_sales_amount = array();
                                $total_sales_amount_overall = array();
                                $total_received_amount = array();
                                $total_remaining_amount = array();
                                $total_trans_exp_amount = array();
                                $total_profit_amount = array();
                                $total_discount_amount = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){

                                        $row_sub_total = $row['sub_total'];
                                        $row_invoice_total = $row['total_sales_amount'];
                                        $row_cash_received = $row['cash_received'];
                                        $row_remaining_amount = $row['remaining_amount'];
                                        $row_trans_expense = $row['trans_expense'];
                                        $row_total_profit_amount = $row['total_profit_amount'];
                                        $row_total_discount_amount = $row['total_discount_amount'];

                                        $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                        $currency_show_symbol = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                        
                                        if(!empty($search_convert_currency))
                                        {
                                            $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                            $currency_show = $convert_currency_record['name'];
                                            $currency_show_symbol = $convert_currency_record['symbol'];
                                            $amount_currency_equalance = $row['currency_usd_equalance'];
                                            $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                            if($row['currency'] == $search_convert_currency)
                                            {
                                                $amount_currency_equalance = 1;
                                                $convert_currency_equalance = 1;
                                            }
                                            
                                            $row_sub_total = amount_conversion($row['sub_total'], $amount_currency_equalance, $convert_currency_equalance);
                                            $row_invoice_total = amount_conversion($row['total_sales_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                            $row_cash_received = amount_conversion($row['cash_received'], $amount_currency_equalance, $convert_currency_equalance);
                                            $row_remaining_amount = amount_conversion($row['remaining_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                            $row_trans_expense = amount_conversion($row['trans_expense'], $amount_currency_equalance, $convert_currency_equalance);
                                            $row_total_profit_amount = amount_conversion($row['total_profit_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                            $row_total_discount_amount = amount_conversion($row['total_discount_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                            
                                        }

                                        $total_sales_amount[] = $row_sub_total;
                                        $total_sales_amount_overall[] = $row_invoice_total;
                                        $total_received_amount[] = $row_cash_received;
                                        $total_remaining_amount[] = $row_remaining_amount;
                                        $total_trans_exp_amount[] = $row_trans_expense;
                                        $total_profit_amount[] = $row_total_profit_amount;
                                        $total_discount_amount[] = $row_total_discount_amount;

                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td>
                                            <?php 
                                            if(strpos($row['client'],"CASHSALE") === FALSE){
                                                echo array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; 
                                            }
                                            else
                                            {
                                                echo $row['cash_client_name'];
                                            }
                                            ?>
                                        </td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= $currency_show_symbol.' '.round_decimels_digits($row_invoice_total); ?></td>
                                        <td><?= $currency_show_symbol.' '.round_decimels_digits($row_total_discount_amount); ?></td>
                                        <td><?= $currency_show_symbol.' '.round_decimels_digits($row_sub_total); ?></td>
                                        <td><?= $currency_show_symbol.' '.round_decimels_digits($row_cash_received); ?></td>
                                        <td><?= $currency_show_symbol.' '.round_decimels_digits($row_remaining_amount); ?></td>
                                        <td><?= $currency_show_symbol.' '.round_decimels_digits($row_trans_expense); ?></td>
                                        <?php if(check_user_access('system_profit') === TRUE){ ?>
                                            <td><?= $currency_show_symbol.' '.round_decimels_digits($row_total_profit_amount); ?></td>
                                        <?php } ?>
                                        <td>
                                            <a href="<?= url('/sales/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sales_amount_overall)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_discount_amount)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_sales_amount)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_received_amount)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_remaining_amount)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_trans_exp_amount)); ?></strong></td>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <td><strong><?= round_decimels_digits(array_sum($total_profit_amount)); ?></strong></td>
                                    <?php } ?>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>