<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'sales_man_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_man_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_sales_man') === TRUE){ ?>
                <a href="<?php echo url('/sales-man/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'sales_man_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'sales_man_view_title'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'sales_man_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_view_thead_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_view_thead_last_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_view_thead_mobile'); ?></th>
                                    <th class="text-center" style="min-width:160px; max-width:160px;"><?= print_lang($app_lang,'sales_man_view_thead_address'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_view_thead_cnic'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_view_thead_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales_man_view_thead_report'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'client_category_listing_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= ucfirst($row['name']); ?></td>
                                        <td><?= ucfirst($row['last_name']); ?></td>
                                        <td><?= ucfirst($row['mobile']); ?></td>
                                        <td><?= ucfirst($row['address']); ?></td>
                                        <td><?= ucfirst($row['cnic']); ?></td>
                                        <td>
                                            <?php if(check_user_access('sales_report_sales_man') === TRUE){ ?>
                                                <a href="<?php echo url('/sales-man/sales').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-success url-elem"><i class="fa fa-eye"></i></a>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('view_report_sales_man') === TRUE){ ?>
                                                <a href="<?php echo url('/sales-man/report').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-info url-elem"><i class="fa fa-eye"></i></a>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('edit_sales_man') === TRUE){ ?>
                                                <a href="<?= url('/sales-man/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'client_category_listing_action_edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_sales_man') === TRUE){ ?>
                                                <a href="<?= url('/sales-man/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'client_category_listing_delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>