<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'sales_return_edit_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/sales-return'); ?>"><?= print_lang($app_lang,'sales_return_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'sales_return_edit_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->

        <form id="refund-seach-invoice-form" action="<?php echo url('/sales-return/add'); ?>">
            <div class="row pointer-none">
                <div class="col-md-4">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'account'); ?></label>
                        <select class="form-control chosen-select" name="client">
                            <option value="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                            <?php foreach($clients as $row){ ?>
                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Client)'; ?></option>
                            <?php } ?>
                            <?php foreach($suppliers as $row){ ?>
                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Supplier)'; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'sales_return_add_select_invoice'); ?></label>
                        <select class="form-control chosen-select" name="invoice">
                            <option value="" selected="">-- <?= print_lang($app_lang,'sales_return_add_select_invoice'); ?> --</option>
                            <?php if(!empty($invoices)){?>
                                <?php foreach($invoices as $invoice){?>
                                    <option <?php if($editing_data['invoice'] == $invoice['invoice']){ echo 'selected="selected"'; } ?> value="<?= $invoice['invoice']; ?>"><?= $invoice['invoice']; ?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-2" style="margin-top: 23px;">
                    <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
                        <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.$editing_data['serial_id']; ?>" readonly="">
                    </div>
                </div>
            </div>
        </form>

        <?php if(!empty($editing_data)){?>
            <form role="form" id="sales-return-form" action="<?php echo url('/sales-return/update').'/'.$editing_data['uid']; ?>">
                <div class="row" style="margin-top: 10px;">
                    <div class="col-md-8">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'bonus'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'sales_return_add_thead_discount_1'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'sales_return_add_thead_discount_2'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                        <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'sales_return_add_thead_return_qty'); ?></th>
                                        <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'sales_return_add_thead_r_bonus_qty'); ?></th>
                                    </tr>
                                </thead>

                                <tbody id="sales-items-table-body" class="<?php if($item_settings['fuel_parts'] == 'enable'){ echo 'fuel-parts-are-enabled'; }?>">
                                    <?php
                                    $item_details = json_decode($editing_data['items_details'],true);
                                    foreach($item_details as $row){
                                        if(strpos($row['item'],"MITNAME_") === FALSE){
                                            $sale_item_data = fetch_table_where('items','uid',$row['item'],true);
                                    ?>
                                        <tr class="text-center sales-item-row">
                                            <td class="sales-item-self">
                                                <span><?= isset($sale_item_data['name']) ? $sale_item_data['name'] : NULL; ?></span>
                                                <input type="hidden" name="currency[]" value="<?= $editing_data['currency']; ?>">
                                                <?php $edate = display_true_date( explode(' ',$editing_data['created_at'])[0] ); ?>
                                                <input type="hidden" name="sdate[]" value="<?= true_date_for_inputs($edate); ?>">
                                                <input type="hidden" class="client_edit_input" name="client[]" value="<?= $editing_data['client']; ?>">
                                                <input type="hidden" class="marketer_edit_input" name="marketer[]" value="<?= $editing_data['marketer']; ?>">
                                                <input type="hidden" class="sales_man_edit_input" name="sales_man[]" value="<?= $editing_data['sales_man']; ?>">
                                                <input type="hidden" name="invoice[]" value="<?= $editing_data['invoice']; ?>">
                                                <input type="hidden" class="memo_edit_input" name="memo[]" value="<?= $editing_data['memo']; ?>">
                                                <input type="hidden" name="item[]" class="sale-form-item-name" value="<?= $row['item']; ?>">
                                                <?php
                                                    $item_uqid = isset($row['item_uqid']) ? $row['item_uqid'] : NULL;
                                                ?>
                                                <input type="hidden" name="item_uqid[]" value="<?= $item_uqid; ?>">
                                                <input type="hidden" name="batch[]" value="<?= $row['batch']; ?>">
                                                <input type="hidden" name="warehouse[]" value="<?= $row['warehouse']; ?>">
                                                <input type="hidden" name="narration[]" value="<?= $row['narration']; ?>">

                                                <input type="hidden" name="plate[]" value="<?= isset($row['plate']) ? $row['plate'] : NULL; ?>">
                                                <input type="hidden" name="agent[]" value="<?= isset($row['agent']) ? $row['agent'] : NULL; ?>">

                                                <input type="hidden" name="m2[]" value="<?php if(isset($row['m2'])){echo $row['m2'];}else{echo '';}; ?>" class="item-m2-iput">
                                                <input type="hidden" name="width[]" value="<?php if(isset($row['width'])){echo $row['width'];}else{echo '';}; ?>" class="item-width-iput">
                                                <input type="hidden" name="height[]" value="<?php if(isset($row['height'])){echo $row['height'];}else{echo '';}; ?>" class="item-height-iput">
                                                <input type="hidden" name="cash_client_name[]" class="cash_client_name_input" value="<?= $editing_data['cash_client_name']; ?>">
                                                <input type="hidden" name="cash_client_mobile[]" class="cash_client_mobile_input" value="<?= $editing_data['cash_client_mobile']; ?>">
                                                <input type="hidden" name="profit[]" value="<?= $row['profit']; ?>">
                                            </td>
                                            <td class="sales-item-warehouse">
                                                <span>
                                                    <?php
                                                        $sale_item_data = isset($sale_item_data['uid']) ? $sale_item_data : array('purchase_unit' => NULL, 'sale_unit' => NULL, 'production_unit' => NULL);
                                                        $sale_item_unit_name = NULL;
                                                        if($row['unit'] == 'purchase')
                                                        {
                                                            $sale_item_unit_name = array_key_exists($sale_item_data['purchase_unit'],$units) ? $units[$sale_item_data['purchase_unit']]['name'] : NULL;
                                                        }
                                                        if($row['unit'] == 'sale')
                                                        {
                                                            $sale_item_unit_name = array_key_exists($sale_item_data['sale_unit'],$units) ? $units[$sale_item_data['sale_unit']]['name'] : NULL;
                                                        }
                                                        if($row['unit'] == 'production')
                                                        {
                                                            $sale_item_unit_name = array_key_exists($sale_item_data['production_unit'],$units) ? $units[$sale_item_data['production_unit']]['name'] : NULL;
                                                        }
                                                        echo $sale_item_unit_name;
                                                    ?>
                                                </span>
                                                <input type="hidden" name="unit[]" value="<?= $row['unit']; ?>">
                                            </td>
                                            <td class="sales-item-cost">
                                                <?php if(check_user_access('system_profit') === TRUE){ ?>
                                                    <span><?= amount_number_format($row['cost']); ?></span>
                                                <?php }else{ ?>
                                                    <span><?= amount_number_format(0); ?></span>
                                                <?php } ?>
                                                <input type="hidden" name="cost[]" value="<?= $row['cost']; ?>">
                                            </td>
                                            <td class="sales-item-sale-price">
                                                <span><?= amount_number_format($row['sale_price']); ?></span>
                                                <input type="hidden" name="sale_price[]" value="<?= $row['sale_price']; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td class="sales-item-qty">
                                                <span><?= amount_number_format($row['qty']); ?></span>
                                                <input type="hidden" name="qty[]" value="<?= $row['qty']; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td>
                                                <?php
                                                    $sale_item_bonus = isset($row['bonus']) ? (float)$row['bonus'] : 0;
                                                ?>
                                                <span><?= amount_number_format($sale_item_bonus); ?></span>
                                                <input type="hidden" name="bonus[]" value="<?= $sale_item_bonus; ?>">
                                            </td>
                                            <td class="sales-item-discount">
                                                <span><?= amount_number_format($row['discount']); ?></span>
                                                <input type="hidden" name="discount[]" value="<?= $row['discount']; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td class="sales-item-discount-2">
                                                <?php if(isset($row['discount_2'])){ $discount_2 = (float)$row['discount_2']; }else{ $discount_2 = 0; }?>
                                                <span><?= amount_number_format($discount_2); ?></span>
                                                <input type="hidden" name="discount_2[]" value="<?= $discount_2; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td class="sales-item-total">
                                                <span><?= amount_number_format($row['item_total']); ?></span>
                                                <input type="hidden" name="item_total[]" value="<?= $row['item_total']; ?>">
                                            </td>
                                            <?php
                                                $discount = isset($row['discount']) ? (float)$row['discount'] : 0;
                                                $discount_2 = isset($row['discount_2']) ? (float)$row['discount_2'] : 0;
                                            ?>
                                            <td>
                                                <input type="number" name="return_qty[]" class="return-qty-input" data-sale-price="<?= $row['sale_price']; ?>" data-qty="<?= $row['qty']; ?>" data-discount="<?= $discount; ?>" data-discount-2="<?= $discount_2; ?>" value="<?= $row['r_qty']; ?>" style="width: 60px;">
                                                <input type="hidden" name="return_row_amount[]" class="return_row_amount" value="<?php echo $row['r_item_total']; ?>">
                                            </td>
                                            <td class="sales-item-refund-td">
                                                <?php
                                                    $sale_item_bonus_r = isset($row['r_bonus']) ? (float)$row['r_bonus'] : 0;
                                                ?>
                                                <input type="number" name="return_qty_bns[]" value="<?= $sale_item_bonus_r; ?>" class="return-qty-bns-input" data-bonus="<?= $sale_item_bonus; ?>" style="width: 60px;">
                                            </td>
                                        </tr>
                                    <?php }else{ ?>
                                        <tr class="text-center sales-item-row">
                                            <td class="sales-item-self">
                                                <span><?= str_replace('MITNAME_', '', $row['item']); ?></span>
                                                <input type="hidden" name="currency[]" value="<?= $editing_data['currency']; ?>">
                                                <input type="hidden" name="sdate[]" value="<?= true_date_for_inputs($edate); ?>">
                                                <input type="hidden" name="client[]" value="<?= $editing_data['client']; ?>">
                                                <input type="hidden" name="marketer[]" value="<?= $editing_data['marketer']; ?>">
                                                <input type="hidden" name="invoice[]" value="<?= $editing_data['invoice']; ?>">
                                                <input type="hidden" name="memo[]" value="<?= $editing_data['memo']; ?>">
                                                <input type="hidden" name="item[]" class="sale-form-item-name" value="<?= $row['item']; ?>">
                                                <?php
                                                    $item_uqid = isset($row['item_uqid']) ? $row['item_uqid'] : NULL;
                                                ?>
                                                <input type="hidden" name="item_uqid[]" value="<?= $item_uqid; ?>">
                                                <input type="hidden" name="batch[]" value="<?= $row['batch']; ?>">
                                                <input type="hidden" name="warehouse[]" value="<?= $row['warehouse']; ?>">
                                                <input type="hidden" name="narration[]" value="<?= $row['narration']; ?>">

                                                <input type="hidden" name="plate[]" value="<?= isset($row['plate']) ? $row['plate'] : NULL; ?>">
                                                <input type="hidden" name="agent[]" value="<?= isset($row['agent']) ? $row['agent'] : NULL; ?>">

                                                <input type="hidden" name="m2[]" value="<?php if(isset($row['m2'])){echo $row['m2'];}else{echo '';}; ?>" class="item-m2-iput">
                                                <input type="hidden" name="width[]" value="<?php if(isset($row['width'])){echo $row['width'];}else{echo '';}; ?>" class="item-width-iput">
                                                <input type="hidden" name="height[]" value="<?php if(isset($row['height'])){echo $row['height'];}else{echo '';}; ?>" class="item-height-iput">
                                                <input type="hidden" name="cash_client_name[]" value="<?= $editing_data['cash_client_name']; ?>">
                                                <input type="hidden" name="cash_client_mobile[]" value="<?= $editing_data['cash_client_mobile']; ?>">
                                                <input type="hidden" name="profit[]" value="<?= $row['profit']; ?>">
                                            </td>
                                            <td class="sales-item-warehouse">
                                                <span><?= $row['unit']; ?></span>
                                                <input type="hidden" name="unit[]" value="<?= $row['unit']; ?>">
                                            </td>
                                            <td class="sales-item-cost">
                                                <?php if(check_user_access('system_profit') === TRUE){ ?>
                                                    <span><?= amount_number_format($row['cost']); ?></span>
                                                <?php }else{ ?>
                                                    <span><?= amount_number_format(0); ?></span>
                                                <?php } ?>
                                                <input type="hidden" name="cost[]" value="<?= $row['cost']; ?>">
                                            </td>
                                            <td class="sales-item-sale-price">
                                                <input type="number" name="sale_price[]" value="<?= $row['sale_price']; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td class="sales-item-qty">
                                                <input type="number" name="qty[]" value="<?= $row['qty']; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td>
                                                <?php
                                                    $sale_item_bonus = isset($row['r_bonus']) ? (float)$row['r_bonus'] : 0;
                                                ?>
                                                <input type="hidden" name="bonus[]" value="<?= $sale_item_bonus; ?>">
                                            </td>
                                            <td class="sales-item-discount">
                                                <input type="number" name="discount[]" value="<?= $row['discount']; ?>" class="sales-editable-iputs">
                                            </td>
                                            <td class="sales-item-total">
                                                <span><?= amount_number_format($row['item_total']); ?></span>
                                                <input type="hidden" name="item_total[]" value="<?= $row['item_total']; ?>">
                                            </td>
                                            <td>
                                                <input type="number" name="return_qty" class="return-qty-input" data-sale-price="<?= $row['sale_price']; ?>" value="<?= $row['r_qty']; ?>" data-qty="<?= $row['qty']; ?>" style="width: 60px;">
                                                <input type="hidden" name="return_row_amount" class="return_row_amount" value="<?= $editing_data['refund_total']; ?>">
                                            </td>
                                            <td class="sales-item-refund-td">
                                                <?php
                                                    $sale_item_bonus_r = isset($row['r_bonus']) ? (float)$row['r_bonus'] : 0;
                                                ?>
                                                <input type="number" name="return_qty_bns[]" value="<?= $sale_item_bonus_r; ?>" class="return-qty-bns-input" data-bonus="<?= $sale_item_bonus; ?>" style="width: 60px;">
                                            </td>
                                        </tr>
                                    <?php }} ?>
                                </tbody>
                            </table>    
                        </div>

                        <div class="row sales-under-table-totals">
                            <div class="col-md-3 total-sales-cel">
                                <strong><?= print_lang($app_lang,'total_sale'); ?>: </strong>
                                <span><?= round_decimels_digits($editing_data['total_sales_amount']); ?></span>
                                <input type="hidden" name="total_sales_amount" value="<?= $editing_data['total_sales_amount']; ?>">
                            </div>
                            <div class="col-md-3 total-diss-cel">
                                <strong><?= print_lang($app_lang,'total_discount'); ?>: </strong>
                                <span><?= round_decimels_digits($editing_data['total_discount_amount']); ?></span>
                                <input type="hidden" name="total_discount_amount" value="<?= $editing_data['total_discount_amount']; ?>">
                                <input type="hidden" name="total_discount_amount_1" class="sales-discount-amount-1" value="<?= $editing_data['total_discount_amount_1']; ?>">
                                <input type="hidden" name="total_discount_amount_2" class="sales-discount-amount-2" value="<?= $editing_data['total_discount_amount_2']; ?>">
                            </div>
                            <div class="col-md-3 gross-total-cel">
                                <strong><?= print_lang($app_lang,'gross_total'); ?>: </strong>
                                <span><?= round_decimels_digits($editing_data['gross_total_amount']); ?></span>
                                <input type="hidden" name="gross_total_amount" value="<?= $editing_data['gross_total_amount']; ?>">
                            </div>
                            <div class="col-md-3 total-refund-amount-cel">
                                <strong><?= print_lang($app_lang,'sales_return_add_total_refund'); ?>: </strong>
                                <span><?= round_decimels_digits($editing_data['refund_total']); ?></span>
                                <input type="hidden" name="total_profit_amount" value="<?= $editing_data['total_profit_amount']; ?>">
                                <input type="hidden" name="total_refund_amount" value="<?= $editing_data['refund_total']; ?>">
                            </div>
                        </div>

                    </div>

                    <div class="col-md-4 bg-muted items-calculations-wrapper sales-totals-box">

                        <input class="cals-input" type="hidden" name="trans_expense" value="<?= $editing_data['trans_expense']; ?>">
                        <input class="cals-input" type="hidden" name="expense_account" value="<?= $editing_data['expense_account']; ?>">
                        <input class="cals-input" type="hidden" name="sub_total" value="<?= $editing_data['sub_total']; ?>">
                        <input class="cals-input" type="hidden" name="cash_received" value="<?= $editing_data['cash_received']; ?>">
                        <input class="cals-input" type="hidden" name="cash_received_account" value="<?= $editing_data['cash_received_account']; ?>">
                        <input class="cals-input" type="hidden" name="remaining_amount" value="<?= $editing_data['remaining_amount']; ?>">

                        <div class="row items-calculations-row sales-total-amount-row" style="margin-top: 10px;">
                            <div class="col-md-4" style="padding-right: 0;">
                                <strong><?= print_lang($app_lang,'sales_total'); ?>: </strong>
                            </div>
                            <div class="col-md-8">
                                <span class="cals-span"><?= round_decimels_digits($editing_data['sales_total']); ?></span>
                                <input class="cals-input" type="hidden" name="sales_total" value="<?= $editing_data['sales_total']; ?>">
                            </div>
                        </div>

                        <div class="row items-calculations-row sales-total-refund-amount-row" style="margin-top: 10px;">
                            <div class="col-md-4" style="padding-right: 0;">
                                <strong><?= print_lang($app_lang,'sales_return_add_total_refund'); ?>: </strong>
                            </div>
                            <div class="col-md-8">
                                <span class="cals-span"><?= round_decimels_digits($editing_data['refund_total']); ?></span>
                                <input class="cals-input" type="hidden" name="sales_total_return" value="<?= $editing_data['refund_total']; ?>">
                            </div>
                        </div>
                        <div class="row items-calculations-row sales-cash-received-row">
                            <div class="col-md-4" style="padding-right: 0;">
                                <strong><?= print_lang($app_lang,'cash_paid'); ?>: </strong>
                            </div>
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-5 sales_trans_exp_input" style="padding-right: 0;">
                                        <input class="cals-input" type="number" name="cash_received_return" value="<?= $editing_data['refund_received']; ?>">
                                    </div>
                                    <div class="col-md-7 sales_trans_exp_account" style="padding-left: 0;">
                                        <select class="form-group chosen-select" name="cash_received_account_refund">
                                            <option disabled="" selected="">- <?= print_lang($app_lang,'account'); ?> -</option>
                                            <?php foreach($accounts as $row){ ?>
                                            <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                                <option <?php if($editing_data['refund_account'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php }} ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'memo'); ?></label>
                                    <textarea style="height: 35px;" class="form-control" name="return_memo" rows="1" placeholder="<?= print_lang($app_lang,'memo'); ?>"><?= $editing_data['return_memo']; ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <input type="submit" style="width: 100%;" class="btn btn-primary btn-sm" value="<?= print_lang($app_lang,'update'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        <?php } ?>

    </div>

</div>