<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'services_mod_breadcrumb_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'services_mod_breadcrumb_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_services_sales_rights') === TRUE){ ?>
                <a href="<?= url('/services/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'services_mod_add_new'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'services_mod_listing_title'); ?></h2>

                    <form id="services-search-form" action="<?= url('/services'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'services_mod_view_filter_currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'services_mod_view_filter_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'convert_currency'); ?></label>
                                        <select class="form-control chosen-select" name="convert_currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'convert_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_convert_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'services_mod_view_filter_client'); ?></label>
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'services_mod_view_filter_client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'marketer'); ?></label>
                                        <select class="form-control chosen-select" name="marketer">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'marketer'); ?> --</option>
                                            <?php foreach($marketers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_marketer == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']." ".$row['last_name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'services_mod_view_filter_from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'services_mod_view_filter_to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'services_mod_view_filter_search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_gross_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_received'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_pending'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_mod_view_thead_memo'); ?></th>
                                    <th class="text-center" style="min-width: 120px; max-width:120px;"><?= print_lang($app_lang,'services_mod_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                    $i = 1; 
                                    $total_amount = array();
                                    $total_discount = array();
                                    $total_gross_total = array();
                                    $total_cash_paid = array();
                                    $total_pending_amount = array();
                                    foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                    $total = $row['total'];
                                    $discount = $row['discount'];
                                    $gross_total = $row['gross_total'];
                                    $cash_paid = $row['cash_paid'];
                                    $pending_amount = $row['pending_amount'];
                                    if(!empty($search_convert_currency))
                                    {
                                        $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                        $currency_show = $convert_currency_record['name'];
                                        $amount_currency_equalance = $row['currency_usd_equalance'];
                                        $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                        if($row['currency'] == $search_convert_currency)
                                        {
                                            $amount_currency_equalance = 1;
                                            $convert_currency_equalance = 1;
                                        }
                                        $total = amount_conversion($row['total'], $amount_currency_equalance, $convert_currency_equalance);
                                        $discount = amount_conversion($row['discount'], $amount_currency_equalance, $convert_currency_equalance);
                                        $gross_total = amount_conversion($row['gross_total'], $amount_currency_equalance, $convert_currency_equalance);
                                        $cash_paid = amount_conversion($row['cash_paid'], $amount_currency_equalance, $convert_currency_equalance);
                                        $pending_amount = amount_conversion($row['pending_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td>
                                            <?php 
                                                echo array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; 
                                            ?>
                                        </td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= round_decimels_digits((float)$total); $total_amount[] = $total;  ?></td>
                                        <td><?= round_decimels_digits((float)$discount); $total_discount[] = $discount;  ?></td>
                                        <td><?= round_decimels_digits((float)$gross_total); $total_gross_total[] = $gross_total;  ?></td>
                                        <td><?= round_decimels_digits((float)$cash_paid); $total_cash_paid[] = $cash_paid;  ?></td>
                                        <td><?= round_decimels_digits((float)$pending_amount); $total_pending_amount[] = $pending_amount;  ?></td>
                                        <td><?= $row['memo']; ?></td>
                                        <td>
                                            <?php if(check_user_access('invoice_services_sales_rights') === TRUE){ ?>
                                                <a href="<?= url('/services/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_services_sales_rights') === TRUE){ ?>
                                                <a href="<?= url('/services/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_services_sales_rights') === TRUE){ ?>
                                                <a href="<?= url('/services/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td></td>
                                        <td><strong><?= display_true_date(date("Y-m-d")); ?></strong></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td><strong><?= round_decimels_digits(array_sum($total_amount));  ?></strong></td>
                                        <td><strong><?= round_decimels_digits(array_sum($total_discount));  ?></strong></td>
                                        <td><strong><?= round_decimels_digits(array_sum($total_gross_total));  ?></strong></td>
                                        <td><strong><?= round_decimels_digits(array_sum($total_cash_paid));  ?></strong></td>
                                        <td><strong><?= round_decimels_digits(array_sum($total_pending_amount));  ?></strong></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>