<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'services_qut_mod_breadcrumb_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'services_qut_mod_breadcrumb_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_sale') === TRUE){ ?>
                <a href="<?= url('/services-quotation/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'services_qut_mod_add_new'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'services_qut_mod_listing_title'); ?></h2>

                    <form id="services-quotation-search-form" action="<?= url('/services-quotation'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'services_qut_mod_view_filter_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'services_qut_mod_view_filter_client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'services_qut_mod_view_filter_from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'services_qut_mod_view_filter_to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'services_qut_mod_view_filter_search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_gross_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'services_qut_mod_view_thead_memo'); ?></th>
                                    <th class="text-center" style="min-width: 120px; max-width:120px;"><?= print_lang($app_lang,'services_qut_mod_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td>
                                            <?php 
                                                echo array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; 
                                            ?>
                                        </td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits((float)$row['total']); ?></td>
                                        <td><?= round_decimels_digits((float)$row['discount']); ?></td>
                                        <td><?= round_decimels_digits((float)$row['gross_total']); ?></td>
                                        <td><?= $row['memo']; ?></td>
                                        <td>
                                            <?php if(check_user_access('add_sale') === TRUE){ ?>
                                                <a href="<?= url('/services-quotation/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                            <?php } ?>

                                            <?php if(check_user_access('add_sale') === TRUE){ ?>
                                                <a href="<?= url('/services/invoice').'/'.$row['service_id']; ?>" target="_blank" class="btn btn-xs btn-outline btn-info url-elem"><i class="fa fa-external-link"></i></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>