<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_items_sets_add_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/sets'); ?>"><?= print_lang($app_lang,'mod_items_sets_view_title'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_items_sets_add_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="sets-form" action="<?php echo url('/sets/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_items_sets_add_input_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control cv-required" name="name" placeholder="<?= print_lang($app_lang,'mod_items_sets_add_input_name'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="sets-appended-data-row">
                        <div class="row sets-add-to-list-row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_items_sets_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                                    <select class="form-control chosen-select set-add-to-list-item add-to-list-validate cv-required" name="item[]">
                                        <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                        <?php $icount = 1; foreach($items as $row){ ?>
                                            <?php
                                            $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                            $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                            foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                                $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouse) ? $warehouse[$warehouse_uid]['name'] : NULL;
                                            ?>
                                                <option value="<?= $row['uid']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-item-currency="<?= $row['currency']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-last-cost="<?= $row['stats']['last_cost']; ?>" data-last-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].' - '.$row['details'].' - '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    <input type="hidden" class="set-add-to-list-warehouse" name="warehouse[]">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_items_sets_add_input_batch'); ?> <strong class="text-danger">*</strong></label>
                                    <select class="form-control chosen-select set-add-to-list-batch add-to-list-validate cv-required" name="batch[]">
                                        <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'select_batch'); ?> --</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_items_sets_add_input_unit'); ?> <strong class="text-danger">*</strong></label>
                                    <select class="form-control chosen-select set-add-to-list-unit add-to-list-validate cv-required" name="unit[]">
                                        <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_items_sets_add_input_qty'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control set-add-to-list-qty add-to-list-validate cv-required" name="qty[]" placeholder="<?= print_lang($app_lang,'mod_items_sets_add_input_qty'); ?>">
                                </div>
                            </div>
                            <div class="col-md-1" style="margin-top: 20px;">
                                <button class="btn btn-outline btn-primary dim set-add-to-list-trigger" type="button"><i class="fa fa-plus"></i></button>
                            </div>
                        </div>

                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/sets'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'mod_items_sets_add_input_save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>