<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_items_sets_edit_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/sets'); ?>"><?= print_lang($app_lang,'mod_items_sets_view_title'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_items_sets_edit_update'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="sets-form" action="<?php echo url('/sets/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_items_sets_add_input_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control cv-required" name="name" value="<?= $editing_data['name']; ?>" placeholder="<?= print_lang($app_lang,'mod_items_sets_add_input_name'); ?>">
                            </div>
                        </div>
                    </div>
                    <?php
                    $sr = 1;
                        $items_details = json_decode($editing_data['items_details'],true);
                        foreach($items_details as $item_row){
                    ?>
                        <div class="sets-appended-data-row">
                            <div class="row sets-add-to-list-row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($sr == 1){?>
                                            <label><?= print_lang($app_lang,'mod_items_sets_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                                        <?php } ?>
                                        <select class="form-control chosen-select set-add-to-list-item <?php if($sr == 1){ echo 'add-to-list-validate'; }?> cv-required" name="item[]">
                                            <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                            <?php $icount = 1; foreach($items as $row){ ?>
                                                <?php
                                                $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                                $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                                foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                                    $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouse) ? $warehouse[$warehouse_uid]['name'] : NULL;
                                                ?>
                                                    <option <?php if($item_row['item'] == $row['uid'] AND $item_row['warehouse'] == $warehouse_uid){echo "selected='selected'";}?> value="<?= $row['uid']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-item-currency="<?= $row['currency']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-last-cost="<?= $row['stats']['last_cost']; ?>" data-last-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].' - '.$row['details'].' - '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                        <input type="hidden" class="set-add-to-list-warehouse" value="<?= $item_row['warehouse']; ?>" name="warehouse[]">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($sr == 1){?>
                                            <label><?= print_lang($app_lang,'mod_items_sets_add_input_batch'); ?> <strong class="text-danger">*</strong></label>
                                        <?php } ?>
                                        <select class="form-control chosen-select <?php if($sr == 1){ echo 'add-to-list-validate'; }?> set-add-to-list-batch cv-required" name="batch[]">
                                            <?php 
                                            $items_batch = get_item_warehouse_wise_batch($item_row['item'],$item_row['warehouse']);
                                            ?>
                                            <?php foreach($items_batch as $row){ ?>
                                                <option <?php if($item_row['batch'] == $row['batch']){ echo 'selected="selected"'; } ?> value="<?= $row['batch']; ?>"><?= $row['batch'].' (ava-'.$row['stock_ava'].')'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($sr == 1){?>
                                            <label><?= print_lang($app_lang,'mod_items_sets_add_input_unit'); ?> <strong class="text-danger">*</strong></label>
                                        <?php } ?>
                                        <select class="form-control chosen-select <?php if($sr == 1){ echo 'add-to-list-validate'; }?> set-add-to-list-unit cv-required" name="unit[]">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                            <?php
                                                $selected_item = fetch_table_where('items','uid',$item_row['item'],true);
                                            ?>
                                            <?php if(!empty($selected_item['purchase_unit'])){ ?>
                                                <option value="purchase" <?php if($item_row['unit'] == 'purchase'){ echo 'selected="selected"'; } ?>><?= array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL; ?></option>
                                            <?php } ?>
                                            <?php if(!empty($selected_item['sale_unit'])){ ?>
                                                <option value="sale" <?php if($item_row['unit'] == 'sale'){ echo 'selected="selected"'; } ?>><?= array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL; ?></option>
                                            <?php } ?>
                                            <?php if(!empty($selected_item['production_unit'])){ ?>
                                                <option value="production" <?php if($item_row['unit'] == 'production'){ echo 'selected="selected"'; } ?>><?= array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <?php if($sr == 1){?>
                                            <label><?= print_lang($app_lang,'mod_items_sets_add_input_qty'); ?> <strong class="text-danger">*</strong></label>
                                        <?php } ?>
                                        <input type="number" class="form-control set-add-to-list-qty <?php if($sr == 1){ echo 'add-to-list-validate'; }?> cv-required" value="<?= $item_row['qty']; ?>" name="qty[]" placeholder="<?= print_lang($app_lang,'mod_items_sets_add_input_qty'); ?>">
                                    </div>
                                </div>
                                <?php if($sr == 1){?>
                                    <div class="col-md-1" style="margin-top: 20px;">
                                        <button class="btn btn-outline btn-primary dim set-add-to-list-trigger" type="button"><i class="fa fa-plus"></i></button>
                                    </div>
                                <?php }else{ ?>
                                    <div class="col-md-1">
                                        <button class="btn btn-outline btn-danger dim set-del-to-list-trigger" type="button"><i class="fa fa-times"></i></button>
                                    </div>
                                <?php } ?>
                            </div>

                        </div>
                    <?php $sr++; } ?>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/sets'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'mod_items_sets_edit_update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>