<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_shareholder_credit_edit_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/shareholder-credit'); ?>"><?= print_lang($app_lang,'mod_shareholder_credit_sidebar_main_menu'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_shareholder_credit_edit_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="shareholder-credit-form" action="<?php echo url('/shareholder-credit/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <?php
                                    $event_date = display_true_date($editing_data['event_date']);
                                ?>
                                <label><?= print_lang($app_lang,'date'); ?> </label>
                                <?php $edate = display_true_date( date('y-m-d') ); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="event_date" value="<?= true_date_for_inputs($event_date); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="event_date" value="<?= true_date_for_inputs($event_date); ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_shareholder_credit_view_thead_account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-group chosen-select" name="credit_account">
                                    <option disabled="" selected="">- <?= print_lang($app_lang,'mod_shareholder_credit_view_thead_account'); ?> -</option>
                                    <?php foreach($accounts as $row){ ?>
                                    <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                        <option <?php if($editing_data['credit_account'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['display_name']; ?></option>
                                    <?php }} ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_shareholder_credit_view_thead_shareholder'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select shareholder-credit-select" name="shareholder">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_shareholder_credit_view_thead_shareholder'); ?> --</option>
                                    <?php foreach($shareholder as $row){ ?>
                                        <option data-percentage="<?= $row['percentage']; ?>" <?php if($editing_data['shareholder'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_shareholder_credit_view_thead_percentage'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control find-percentage" name="percentage" value="<?= $editing_data['percentage']; ?>" placeholder="<?= print_lang($app_lang,'mod_shareholder_credit_view_thead_percentage'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_shareholder_credit_view_thead_amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="amount" value="<?= $editing_data['amount']; ?>" placeholder="<?= print_lang($app_lang,'mod_shareholder_credit_view_thead_amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_shareholder_credit_view_details'); ?> </label>
                                <input type="text" class="form-control" name="details" value="<?= $editing_data['details']; ?>" placeholder="<?= print_lang($app_lang,'mod_shareholder_credit_view_details'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/shareholder-credit'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>
