<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'showroom'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?= url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'showroom'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'showroom_listing'); ?></h2>
                    
                    <form id="showroom-search-form" action="<?= url('/showroom'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'car_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'car_model'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'shasi_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'color'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'car_makes'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'image'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'delivery_charges'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'custom_expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'custom_charges'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'fixing_expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'real_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'images'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_cost = array();
                                $total_delivery_charges = array();
                                $total_custom_expenses = array();
                                $total_custom_charges = array();
                                $total_fixing_expenses = array();
                                $total_real_cost = array();

                                foreach($pageData as $row){

                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;

                                    // calculations
                                    $car_cost = (float)$row['cost'];
                                    $car_agent_commission = (float)$row['agent_commission_amount'];
                                    $car_other_expenses = (float)$row['other_expenses'];
                                    $car_cost = $car_cost + $car_agent_commission + $car_other_expenses;
                                    $car_transfer_expenses = (float)$row['transfer_expenses'];
                                    $car_load_delivery_expenses = (float)$row['load_delivery_expenses'];
                                    $car_custom_expenses = (float)$row['custom_expenses'];
                                    $car_custom_charges = (float)$row['custom_charges'];
                                    $car_fixing_expenses = (float)$row['fixing_expenses'];

                                    $car_delivery_charges = $car_transfer_expenses + $car_load_delivery_expenses + $car_custom_expenses;
                                    $car_real_cost = $car_cost + $car_delivery_charges + $car_custom_charges + $car_fixing_expenses;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['car_name']; ?></td>
                                        <td><?= $row['car_model']; ?></td>
                                        <td><?= $row['shasi_num']; ?></td>
                                        <td><?= $row['car_color']; ?></td>
                                        <td><?= $row['car_make']; ?></td>
                                        <td>---</td>
                                        <td><?= $row_currency; ?><?= amount_number_format($car_cost); $total_cost[] = $car_cost; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($car_delivery_charges); $total_delivery_charges[] = $car_delivery_charges; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($car_custom_expenses); $total_custom_expenses[] = $car_custom_expenses; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($car_custom_charges); $total_custom_charges[] = $car_custom_charges; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($car_fixing_expenses); $total_fixing_expenses[] = $car_fixing_expenses; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($car_real_cost); $total_real_cost[] = $car_real_cost; ?></td>
                                        <td>
                                            <a uidprint="<?= $row['uid']; ?>" data-car-id="<?= $row['uid']; ?>" data-images="<?= $row['images']; ?>" href="javascript:void(0);" class="btn btn-xs btn-outline btn-info showroom-car-images-preview-btn"><i class="fa fa-eye">&nbsp;&nbsp; </i><?= print_lang($app_lang,'preview'); ?></a>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('sale_shor_car_purchases') === TRUE){ ?>
                                                <?php if($row['sold'] == 'sold'){ ?>
                                                    <span class="btn btn-xs btn-outline btn-warning"><i class="fa fa-check"></i>&nbsp;&nbsp;<?= print_lang($app_lang,'sold'); ?></span>
                                                <?php }else{ ?>
                                                    <a href="<?= url('/showroom-sales/add').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-send"></i>&nbsp;&nbsp;<?= print_lang($app_lang,'sale'); ?></a>
                                                <?php } ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_cost) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_delivery_charges) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_custom_expenses) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_custom_charges) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_fixing_expenses) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_real_cost) ); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>





<div class="modal inmodal" id="showroom-car-images-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="showroom-car-images-form" action="<?= url('/showroom/upload-images'); ?>">
                <input type="hidden" name="car_uid">
                
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'car_images_modal_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'car_images_modal_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">

                <div class="row car-images-wrapper" style="margin-bottom: 20px;"></div>

                <div class="row">
                    <div class="col-md-6">
                        <strong>Add more images...</strong>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="file" class="form-control" name="images[]" id="car-images-uploader-input" multiple="">
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'save'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>