<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_stock_in'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/stock-in'); ?>"><?= print_lang($app_lang,'stock_in'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'add_new_stock_in'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="stock-in-items-temp-form">

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select stock_client" name="stock_client" id="stock-in-add-client-dropdown">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select stock_warehouse" name="stock_warehouse" id="stock-in-add-warehouse-dropdown">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" ><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'agent'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control stock_in_agent" name="stock_agent" placeholder="<?= print_lang($app_lang,'agent'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'receipt_#'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control pointer-none" name="stock_receipt" value="<?= $invoice_number; ?>" placeholder="<?= print_lang($app_lang,'receipt_#'); ?>" readonly="">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date stock_in_date" name="stock_in_date" placeholder="<?= print_lang($app_lang,'date'); ?>" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control stock_in_date" name="stock_in_date">
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_nme'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_item" placeholder="<?= print_lang($app_lang,'item_nme'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_unit" placeholder="<?= print_lang($app_lang,'unit'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mark'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_mark" placeholder="<?= print_lang($app_lang,'mark'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'remarks'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_remark" placeholder="<?= print_lang($app_lang,'remarks'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_stock_in'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="stock-in-form" action="<?php echo url('/stock-in/save'); ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center" style="width: 170px;"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mark'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remarks'); ?></th>
                                    <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-in-items-table-body">
                                
                            </tbody>
                        </table>    
                    </div>
                    
                    <div class="row stock-in-under-table-totals extra-mar-botm">
                        <div class="col-md-6 total-stock-in-unit-cel">
                            <strong><?= print_lang($app_lang,'total_item_qty'); ?>: </strong>
                            <span></span>
                            <input type="hidden" name="total_qty" >
                        </div>
                        <!-- <div class="col-md-6 total-stock-in-qty-cel">
                            <strong><?= print_lang($app_lang,'total_carton_qty'); ?>: </strong>
                            <span></span>
                            <input type="hidden" name="total_discount_amount">
                        </div> -->
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <input type="submit" style="width: 100%;" class="btn btn-primary btn-sm" value="<?= print_lang($app_lang,'save_print'); ?>">
                        </div>
                    </div>

                </div>

            </div>
        </form>

    </div>

</div>