<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'stock_in_edit'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/stock-in'); ?>"><?= print_lang($app_lang,'stock_in'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_in_edit'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="stock-in-items-temp-form">

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select stock_client" name="stock_client" id="stock-in-add-client-dropdown">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select stock_warehouse" name="stock_warehouse" id="stock-in-add-warehouse-dropdown">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['warehouse'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'agent'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control stock_in_agent" name="stock_agent" value="<?php echo $editing_data['agent'];?>" placeholder="<?= print_lang($app_lang,'agent'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'receipt_#'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control pointer-none" name="stock_receipt" value="<?php echo $editing_data['invoice'];?>" placeholder="<?= print_lang($app_lang,'receipt_#'); ?>" readonly="">
                            </div>
                        </div>
                        <?php
                            $stock_date = display_true_date($editing_data['stock_date']);
                        ?>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date stock_in_date" value="<?= true_date_for_inputs($stock_date); ?>" name="stock_in_date" placeholder="<?= print_lang($app_lang,'date'); ?>" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control stock_in_date" name="stock_in_date" value="<?= true_date_for_inputs($stock_date); ?>">
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_nme'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_item" placeholder="<?= print_lang($app_lang,'item_nme'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_unit" placeholder="<?= print_lang($app_lang,'unit'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mark'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_mark" placeholder="<?= print_lang($app_lang,'mark'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'remarks'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="stock_remark" placeholder="<?= print_lang($app_lang,'remarks'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_stock_in'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="stock-in-form" action="<?php echo url('/stock-in/update').'/'.$editing_data['uid']; ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center" style="width: 170px;"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mark'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remarks'); ?></th>
                                    <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-in-items-table-body">
                                <?php
                                $item_details = json_decode($editing_data['items_details'],true);
                                foreach($item_details as $row){?>
                                <tr class="text-center stock-in-item-row">
                                    <td class="stock-in-item-self">
                                        <span><?php echo $row['item']; ?></span>
                                        <input type="hidden" name="item[]" value="<?= $row['item']; ?>">
                                        <input type="hidden" name="item_id[]" value="<?= $row['item_id']; ?>">
                                        <input type="hidden" class="stock_client_edit" name="client[]" value="<?= $editing_data['client']; ?>">
                                        <input type="hidden" class="stock_warehouse_edit" name="warehouse[]" value="<?= $editing_data['warehouse']; ?>">
                                        <input type="hidden" class="stock_agent_edit" name="agent[]" value="<?= $editing_data['agent']; ?>">
                                        <input type="hidden" name="invoice[]" value="<?= $editing_data['invoice']; ?>">
                                        <input type="hidden" class="stock_edit_date" name="stock_date[]" value="<?= date("Y-m-d" ,strtotime($editing_data['stock_date'])); ?>">
                                    </td>

                                    <td>
                                        <span><?php echo $row['unit'];?></span>
                                        <input type="hidden" name="unit[]" value="<?php echo $row['unit'];?>">
                                    </td>
                                    <td class="stock-in-item-qty">
                                        <input type="text" name="qty[]" style="width: 100px; text-align: center;" value="<?php echo $row['qty']; ?>" class="stock-in-editable-iputs">
                                    </td>
                                    <td>
                                        <span><?php echo $row['mark'];?></span>
                                        <input type="hidden" name="mark[]" value="<?php echo $row['mark'];?>">
                                    </td>
                                    <td>
                                        <span><?php echo $row['remark'];?></span>
                                        <input type="hidden" name="remark[]" value="<?php echo $row['remark'];?>">
                                    </td>
                                    <td>
                                        <a class="btn btn-danger btn-sm stock-in-item-del-trigger stock-in-existing-row" data-uid="<?php echo $row['item_id']; ?>" href="javascript:void(0);"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>
                    
                    <div class="row stock-in-under-table-totals extra-mar-botm">
                        <div class="col-md-6 total-stock-in-unit-cel">
                            <strong><?= print_lang($app_lang,'total_item_qty'); ?>: </strong>
                            <span><?php echo $editing_data['total_qty']; ?></span>
                            <input type="hidden" name="total_qty" value="<?php echo $editing_data['total_qty']; ?>">
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <input type="submit" style="width: 100%;" class="btn btn-primary btn-sm" value="<?= print_lang($app_lang,'update'); ?>">
                        </div>
                    </div>

                </div>

            </div>
        </form>

    </div>

</div>