<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'stock_in'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_in'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_sale') === TRUE){ ?>
                <a href="<?= url('/stock-in/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_stock_in'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'stock_in_listing'); ?></h2>

                    <form id="stock-in-search-form" action="<?= url('/stock-in'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="client">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                <?php foreach($clients as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'agent'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipt_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_qty'); ?></th>
                                    <th class="text-center" style="min-width: 120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sr = 1;
                                foreach($pageData as $row)
                                {
                                    // echo "<pre>";print_r($row);
                                ?>
                                    <tr>
                                        <td class="text-center"><?= $sr++;?></td>
                                        <td class="text-center"><?php echo array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL;?></td>
                                        <td class="text-center"><?php echo $row['agent'];?></td>
                                        <td class="text-center"><?php echo array_key_exists($row['warehouse'], $warehouse) ? $warehouse[$row['warehouse']]['name'] : NULL;?></td>
                                        <td class="text-center"><?php echo $row['invoice'];?></td>
                                        <td class="text-center"><?php echo $row['total_qty'];?></td>
                                        <td class="text-center">
                                            <?php if(check_user_access('add_sale') === TRUE){ ?>
                                                <a href="<?= url('/stock-in/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_sale') === TRUE){ ?>
                                                <a href="<?= url('/stock-in/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_sale') === TRUE){ ?>
                                                <a href="<?= url('/stock-in/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i></a>
                                            <?php } ?>
                                        </td>

                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>