<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_stock_out'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/stock-out'); ?>"><?= print_lang($app_lang,'stock_out'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'add_new_stock_out'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="stock-out-receipt-search-form" action="<?php echo url('/stock-out/get-stock-in-data'); ?>">

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="stock_client" id="stock-out-client-dropdown">
                                    <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'receipt_#'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="stock_receipt" id="stock-out-receipt-dropdown">
                                    <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'receipt_#'); ?> --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button style="width: 100%; margin-top: 23px;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <form role="form" id="stock-out-form" action="<?php echo url('/stock-out/save'); ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'agent'); ?></th>
                                    <th class="text-center" style="width: 170px;"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_out_entry_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_out_receipt_#'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-out-invoice-info-table-body">
                                
                            </tbody>
                        </table>    
                    </div>
                </div>

            </div>

            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'qty_in'); ?></th>
                                    <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'qty_out'); ?></th>
                                    <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'qty_ava'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mark'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remarks'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-out-items-info-table-body">
                                
                            </tbody>
                        </table>    
                    </div>
                </div>

            </div>

            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center" style="width: 150px;"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mark'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remarks'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-out-items-qty-table-body">
                                
                            </tbody>
                        </table>    
                    </div>
                </div>

            </div>

            <div class="row extra-mar-botm">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-12">
                            <textarea class="form-control" rows="4" placeholder="Memo" name="memo"></textarea>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 bg-muted">
                    <div class="row" style="margin-top: 8px;">
                        <div class="col-md-5" style="margin-top: 8px;">
                            <strong><?= print_lang($app_lang,'currency'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <select class="form-group chosen-select" name="currency">
                                <option disabled="" selected="">- <?= print_lang($app_lang,'select_currency'); ?> -</option>
                                <?php foreach($currencies as $row){ ?>
                                    <option value="<?= $row['uid']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 5px;">
                        <div class="col-md-5" style="margin-top: 4px;">
                            <strong><?= print_lang($app_lang,'total_rent'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <input class="cals-input" style="height: 30px; border: 1px solid #ceced1; outline: none; width: 100%;" type="text" name="rent" value="">
                        </div>
                    </div>

                    <div class="row" style="margin-top: 5px;">
                        <div class="col-md-5" style="margin-top: 4px;">
                            <strong><?= print_lang($app_lang,'discount_%'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <input class="cals-input" style="height: 30px; border: 1px solid #ceced1; outline: none; width: 100%;" type="text" name="discount" value="">
                        </div>
                    </div>

                    <div class="row" style="margin-top: 10px;">
                        <div class="col-md-5" style="margin-top: 4px;">
                            <strong><?= print_lang($app_lang,'gross_stock_total'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <span id="stock-out-gross-total-span">0</span>
                            <input type="hidden" name="gross_total" id="stock-out-gross-total-input">
                        </div>
                    </div>

                    <div class="row" style="margin-top: 5px;">
                        <div class="col-md-5" style="margin-top: 6px;">
                            <strong><?= print_lang($app_lang,'cash_paid_stock'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-5" style="padding: 0;">
                                    <input class="cals-input" style="height: 30px; border: 1px solid #ceced1; outline: none; width: 100%; height: 35px;" type="text" name="paid" >
                                </div>
                                <div class="col-md-7" style="padding: 0;">
                                    <select class="form-group chosen-select" name="account">
                                        <option disabled="" selected="">- <?= print_lang($app_lang,'account'); ?> -</option>
                                        <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                            <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                        <?php }} ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">                
                <div class="col-md-12" style="margin-bottom: 10px;">
                    <strong style="font-size: 14px;"><?= print_lang($app_lang,'total_out_qty'); ?>:&nbsp;&nbsp;&nbsp;<span id="total-out-qty-span">00.00</span></strong>
                    <input type="hidden" name="total_out_qty" id="hidden-out-qty">
                </div>
            </div>

            <div class="row extra-mar-botm">
                <div class="col-md-12" style="padding: 0;">
                    <input type="submit" style="width: 100%;" class="btn btn-primary btn-sm" value="<?= print_lang($app_lang,'save_print'); ?>">
                </div>
            </div>
        </form>

    </div>

</div>