<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'stock_out_edit'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/stock-out'); ?>"><?= print_lang($app_lang,'stock_out'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'stock_out_edit'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>
<?php
    
    $items_array_db = array();
    $items_data_db = json_decode($editing_data['items_details'],true);
    foreach($items_data_db as $items_db)
    {
        $items_array_db[] = $items_db['item_id'];
    }

?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="stock-out-receipt-search-form" action="<?php echo url('/stock-out/get-stock-in-data'); ?>">

                    <div class="row pointer-none" style="margin-bottom: 5px;">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="stock_client" id="stock-out-client-dropdown">
                                    <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($stock_in_data['invoice_data']['client'] == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'receipt_#'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="stock_receipt" id="stock-out-receipt-dropdown">
                                    <option disabled="" selected="" value=""> <?= $stock_in_data['invoice_data']['invoice']; ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button style="width: 100%; margin-top: 23px;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


        <form role="form" id="stock-out-form" action="<?php echo url('/stock-out/update').'/'.$editing_data['uid']; ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'agent'); ?></th>
                                    <th class="text-center" style="width: 170px;"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_out_entry_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'stock_out_receipt_#'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-out-invoice-info-table-body">
                                <tr>
                                    <td class="text-center">
                                        <input type="hidden" name="client" value="<?= $stock_in_data['invoice_data']['client']; ?>">
                                        <input type="hidden" name="warehouse" value="<?= $stock_in_data['invoice_data']['warehouse']; ?>">
                                        <input type="hidden" name="agent" value="<?= $stock_in_data['invoice_data']['agent']; ?>">
                                        <input type="hidden" name="stock_in_id" value="<?= $stock_in_data['invoice_data']['uid']; ?>">
                                        <input type="hidden" name="stock_in_date" value="<?= $stock_in_data['invoice_data']['stock_date']; ?>">
                                        <input type="hidden" name="invoice" value="<?= $editing_data['invoice']; ?>">
                                        <?php echo array_key_exists($stock_in_data['invoice_data']['client'], $clients) ? $clients[$stock_in_data['invoice_data']['client']]['name'] : NULL;?>
                                    </td>
                                    <td class="text-center">
                                        <?= $stock_in_data['invoice_data']['agent']; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo array_key_exists($stock_in_data['invoice_data']['warehouse'], $warehouse) ? $warehouse[$stock_in_data['invoice_data']['warehouse']]['name'] : NULL;?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo display_true_date($editing_data['stock_date_out']); ?>
                                    </td>
                                    <td class="text-center">
                                        <?= $editing_data['invoice'];?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>
                </div>

            </div>

            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'qty_in'); ?></th>
                                    <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'qty_out'); ?></th>
                                    <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'qty_ava'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mark'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remarks'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-out-items-info-table-body">
                                <?php
                                    foreach($stock_in_data['items_data'] as $items){
                                        if($items['available'] <= 0)
                                        {
                                            $pointer_none = "pointer-none";
                                        }
                                        else
                                        {
                                            $pointer_none = '';
                                        }
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $items['item']; ?></td>
                                        <td class="text-center"><?= $items['unit']; ?></td>
                                        <td class="text-center"><?= $items['qty']; ?></td>
                                        <td class="text-center"><?= $items['stock_out']; ?></td>
                                        <td class="text-center"><?= $items['available']; ?></td>
                                        <td class="text-center"><?= $items['mark']; ?></td>
                                        <td class="text-center"><?= $items['remark']; ?></td>
                                        <td class="text-center <?php echo $pointer_none; ?>">
                                            <a href="javascript:void(0);" id="stock-out-btn-trigger-<?= $items['item_id']; ?>" class="btn btn-xs btn-outline btn-danger stock-out-btn-trigger <?php if(in_array($items['item_id'], $items_array_db)){echo 'pointer-none';}?>" data-uid="<?= $items['item_id']; ?>" data-name="<?= $items['item']; ?>" data-unit="<?= $items['unit']; ?>" data-qty="<?= $items['qty']; ?>" data-mark="<?= $items['mark']; ?>" data-remark="<?= $items['remark']; ?>" data-ava="<?= $items['available']; ?>"><i class="fa fa-trash"></i>&nbsp;<?= print_lang($app_lang,'out_stock_btn'); ?></a>
                                        </td>
                                    </tr>
                                    <?php } ?>
                            </tbody>
                        </table>    
                    </div>
                </div>

            </div>

            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center" style="width: 150px;"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mark'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remarks'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="stock-out-items-qty-table-body">
                                <?php 
                                    $stock_out_items = json_decode($editing_data['items_details'],true);
                                    foreach($stock_out_items as $stock_out_item){ ?>
                                    <tr class="text-center stock-out-data-row">
                                        <td class="text-center">
                                            <?= $stock_out_item['item']; ?>
                                            <input type="hidden" name="item_name[]" value="<?= $stock_out_item['item']; ?>">
                                            <input type="hidden" name="item_id[]" value="<?= $stock_out_item['item_id']; ?>">
                                            <input type="hidden" name="unit[]" value="<?= $stock_out_item['unit']; ?>">
                                            <input type="hidden" name="mark[]" value="<?= $stock_out_item['mark']; ?>">
                                            <input type="hidden" name="remark[]" value="<?= $stock_out_item['remark']; ?>">
                                        </td>
                                        <td class="text-center"><?= $stock_out_item['unit']; ?></td>
                                        <td class="text-center stock-out-qty-input">
                                            <input type="text" class="stock_out_item stock_out_item_edit" data-ava="<?= item_available_qty($stock_out_item['item_id']); ?>" data-old="<?= $stock_out_item['qty']; ?>" style="text-align: center; width: 75%; border: 1px solid #2b9c1b; outline: none;" name="stock_out_item[]" value="<?= $stock_out_item['qty']; ?>">
                                        </td>
                                        <td class="text-center"><?= $stock_out_item['mark']; ?></td>
                                        <td class="text-center"><?= $stock_out_item['remark']; ?></td>
                                        <td class="text-center">
                                            <a class="btn btn-danger btn-sm stock-out-item-del-trigger" data-parent="<?= $stock_out_item['item_id']; ?>" href="javascript:void(0);"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>
                </div>

            </div>

            <div class="row extra-mar-botm">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-12">
                            <textarea class="form-control" rows="4" placeholder="Memo" name="memo"><?= $editing_data['memo']; ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 bg-muted">
                    <div class="row" style="margin-top: 8px;">
                        <div class="col-md-5" style="margin-top: 8px;">
                            <strong><?= print_lang($app_lang,'currency'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <select class="form-group chosen-select" name="currency">
                                <option disabled="" selected="">- <?= print_lang($app_lang,'select_currency'); ?> -</option>
                                <?php foreach($currencies as $row){ ?>
                                    <option value="<?= $row['uid']; ?>" <?php if($editing_data['currency'] == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 5px;">
                        <div class="col-md-5" style="margin-top: 4px;">
                            <strong><?= print_lang($app_lang,'total_rent'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <input class="cals-input" style="height: 30px; border: 1px solid #ceced1; outline: none; width: 100%;" type="text" name="rent" value="<?= $editing_data['rent']; ?>">
                        </div>
                    </div>

                    <div class="row" style="margin-top: 5px;">
                        <div class="col-md-5" style="margin-top: 4px;">
                            <strong><?= print_lang($app_lang,'discount_%'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <input class="cals-input" style="height: 30px; border: 1px solid #ceced1; outline: none; width: 100%;" type="text" name="discount" value="<?= $editing_data['discount']; ?>">
                        </div>
                    </div>
                    <div class="row" style="margin-top: 10px;">
                        <div class="col-md-5" style="margin-top: 4px;">
                            <strong><?= print_lang($app_lang,'gross_stock_total'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <span id="stock-out-gross-total-span"><?= $editing_data['gross_total']; ?></span>
                            <input type="hidden" name="gross_total" id="stock-out-gross-total-input" value="<?= $editing_data['gross_total']; ?>">
                        </div>
                    </div>

                    <div class="row" style="margin-top: 5px;">
                        <div class="col-md-5" style="margin-top: 6px;">
                            <strong><?= print_lang($app_lang,'cash_paid_stock'); ?>: </strong>
                        </div>
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-5" style="padding: 0;">
                                    <input class="cals-input" style="height: 30px; border: 1px solid #ceced1; outline: none; width: 100%; height: 35px;" type="text" name="paid" value="<?= $editing_data['cash_paid']; ?>">
                                </div>
                                <div class="col-md-7" style="padding: 0;">
                                    <select class="form-group chosen-select" name="account">
                                        <option disabled="" selected="">- <?= print_lang($app_lang,'account'); ?> -</option>
                                        <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                            <option value="<?= $row['uid']; ?>" <?if($editing_data['account'] == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                        <?php }} ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">                
                <div class="col-md-12" style="margin-bottom: 10px;">
                    <strong style="font-size: 14px;"><?= print_lang($app_lang,'total_out_qty'); ?>:&nbsp;&nbsp;&nbsp;<span id="total-out-qty-span"><?= $editing_data['total_qty']; ?></span></strong>
                    <input type="hidden" name="total_out_qty" id="hidden-out-qty" value="<?= $editing_data['total_qty']; ?>">
                </div>
            </div>

            <div class="row extra-mar-botm">
                <div class="col-md-12" style="padding: 0;">
                    <input type="submit" style="width: 100%;" class="btn btn-primary btn-sm" value="<?= print_lang($app_lang,'update'); ?>">
                </div>
            </div>
        </form>

    </div>

</div>