<?php if(is_customer_user() === true){ ?>
<style type="text/css">
  .navbar-default.navbar-static-side{display: none !important;}
  #page-wrapper{width: 100%; margin: 0;}
  .footer.fixed{margin: 0;}
</style>
<?php } ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_suggestions_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_suggestions_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <a href="<?= url('/suggestions/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_suggestions_view_add_btn'); ?></a>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_suggestions_view_title'); ?></h2>

                    <form id="suggestions-search-form" action="<?= url('/suggestions'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4" style="padding: 2px;">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-4" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_suggestions_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_suggestions_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_suggestions_view_thead_details'); ?></th>
                                    <?php if(is_customer_user() === false){?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_suggestions_view_thead_customer'); ?></th>
                                    <?php } ?>
                                    <?php if(is_customer_user() === true){?>
                                        <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'mod_suggestions_view_thead_action'); ?></th>
                                    <?php } ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <?php if(is_customer_user() === false){?>
                                            <td><?= array_key_exists($row['customer'], $clients) ? $clients[$row['customer']]['name'] : NULL; ?></td>
                                        <?php } ?>
                                        <?php if(is_customer_user() === true){?>
                                            <td>
                                                <a href="<?= url('/suggestions/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                                <a href="<?= url('/suggestions/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>