<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_approvals_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_approvals_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">
                    
                    <form id="approval-search-form" action="<?= url('/system-approvals'); ?>">
                        <input type="hidden" name="type" value="<?= $search_type; ?>">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_approvals_view_filter_module'); ?></label>
                                    <select class="form-control chosen-select system-approvals-module-select" name="module">
                                        <option value="" selected="">-- <?= print_lang($app_lang,'mod_approvals_view_filter_module'); ?> --</option>
                                        <option <?php if($search_module == 'expenses'){echo "selected='selected'";}?> value="expenses"><?= print_lang($app_lang,'mod_approvals_view_filter_module_expenses'); ?></option>
                                        <option <?php if($search_module == 'stock_in'){echo "selected='selected'";}?> value="stock_in"><?= print_lang($app_lang,'mod_approvals_view_filter_module_stock_in'); ?></option>
                                        <option <?php if($search_module == 'stock_out'){echo "selected='selected'";}?> value="stock_out"><?= print_lang($app_lang,'mod_approvals_view_filter_module_stock_out'); ?></option>
                                        <option <?php if($search_module == 'journal'){echo "selected='selected'";}?> value="journal"><?= print_lang($app_lang,'mod_approvals_view_filter_module_journal'); ?></option>
                                        <option <?php if($search_module == 'sales'){echo "selected='selected'";}?> value="sales"><?= print_lang($app_lang,'mod_approvals_view_filter_module_sales'); ?></option>
                                        <option <?php if($search_module == 'purchases'){echo "selected='selected'";}?> value="purchases"><?= print_lang($app_lang,'mod_approvals_view_filter_module_purchases'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-2 text-right" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-primary custom-font-btn-search" style="width: 100%;" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            </div>

                            <div class="col-md-6 text-right" style="margin-top: 23px;">
                                <button type="button" class="btn btn-info btn-outline system-approval-button" data-action="approved" data-approval-action="<?php if($search_type == 'main_approval'){echo 'main_approval';}else{echo 'sub_approval';}?>"><i class="fa fa-check"> </i> <?= print_lang($app_lang,'mod_approvals_button_approve'); ?></button>
                                <button type="button" class="btn btn-danger btn-outline system-approval-button" data-action="reject" data-approval-action="<?php if($search_type == 'main_approval'){echo 'main_approval';}else{echo 'sub_approval';}?>"><i class="fa fa-times"> </i> <?= print_lang($app_lang,'mod_approvals_button_rejected'); ?></button>
                            </div>

                        </div>
                    </form>







                    <?php if($search_module == 'expenses'){?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width:80px;"><input type="checkbox" id="system-approvals-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'sr_#'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'type'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'amount'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $total_amount = array(); $i = 1; foreach($pageData as $row){
                                        $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                        $amount = $row['amount'];
                                        if(!empty($search_convert_currency))
                                        {
                                            $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                            $currency_show = $convert_currency_record['name'];
                                            $amount_currency_equalance = $row['currency_usd_equalance'];
                                            $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                            if($row['currency'] == $search_convert_currency)
                                            {
                                                $amount_currency_equalance = 1;
                                                $convert_currency_equalance = 1;
                                            }
                                            $amount = amount_conversion($row['amount'], $amount_currency_equalance, $convert_currency_equalance);
                                        }
                                    ?>
                                        <tr class="text-center">
                                            <td><input type="checkbox" style="margin: 5px;" class="system-approvals-checkbox" name="system_approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                            <td><?= display_true_date($row['exp_date']); ?></td>
                                            <td><?= array_key_exists($row['type'], $expenses_types) ? $expenses_types[$row['type']]['name'] : NULL; ?></td>
                                            <td>
                                                <?php if(empty($row['stock_uid'])){?>
                                                    <?= array_key_exists($row['account'], $accounts) ? $accounts[$row['account']]['name'] : NULL; ?>
                                                <?php }else{?>
                                                    <?= print_lang($app_lang,'mod_item_stock_out_expense_account_name_title'); ?>
                                                <?php } ?>
                                            </td>
                                            <td><?= round_decimels_digits_3($amount); $total_amount[] = $amount; ?></td>
                                            <td><?= $currency_show; ?></td>
                                            <td><?= $row['narration']; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>    
                        </div>

                    <?php } ?>


                    <?php if($search_module == 'stock_in'){?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width:80px;"><input type="checkbox" id="system-approvals-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'mod_item_stock_in_view_thead_sr'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_date'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_item'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_account'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_currency'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_bill'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_unit'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_quantity'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_cost'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_total'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_details'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($pageData as $row){
                                    ?>
                                        <tr class="text-center">
                                            <td><input type="checkbox" style="margin: 5px;" class="system-approvals-checkbox" name="system_approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                            <td><?= display_true_date($row['event_date']); ?></td>
                                            <td><?= $row['item_name']; ?></td>
                                            <td><?= $row['account_name']; ?></td>
                                            <td><?= $row['currency_name']; ?></td>
                                            <td><?= $row['bill_number']; ?></td>
                                            <td><?= $row['unit']; ?></td>
                                            <td><?= amount_number_format($row['quantity']); $quantity_total[] = $row['quantity']; ?></td>
                                            <td><?= amount_number_format($row['cost']); $cost_total[] = $row['cost']; ?></td>
                                            <td><?= amount_number_format($row['total']); $grand_total[] = $row['total']; ?></td>
                                            <td><?= $row['details']; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>    
                        </div>

                    <?php } ?>


                    <?php if($search_module == 'stock_out'){?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width:80px;"><input type="checkbox" id="system-approvals-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'mod_item_stock_out_view_thead_sr'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_out_view_thead_date'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_out_view_thead_item'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_out_view_thead_unit'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_out_view_thead_quantity'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_out_view_details'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($pageData as $row){
                                    ?>
                                        <tr class="text-center">
                                            <td><input type="checkbox" style="margin: 5px;" class="system-approvals-checkbox" name="system_approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                            <td><?= display_true_date($row['event_date']); ?></td>
                                            <td><?= $row['item_name']; ?></td>
                                            <td><?= $row['unit']; ?></td>
                                            <td><?= amount_number_format($row['out_quantity']); $quantity_total[] = $row['out_quantity']; ?></td>
                                            <td><?= $row['details']; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>    
                        </div>

                    <?php } ?>


                    <?php if($search_module == 'journal'){?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width:80px;"><input type="checkbox" id="system-approvals-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'sr_#'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'jv_num_thead'); ?></th>
                                        <th class="text-center" style="width: 70px; max-width: 70px;"><?= print_lang($app_lang,'date'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'dr_account'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'dr_amount'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'dr_narration'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'cr_account'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'cr_amount'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'cr_narration'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($pageData as $row){
                                    ?>
                                        <tr class="text-center">
                                            <td><input type="checkbox" style="margin: 5px;" class="system-approvals-checkbox" name="system_approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                            <td><?= print_lang($app_lang,'jv_num_td').''.$row['serial_id']; ?></td>
                                            <td><?= display_true_date($row['journal_date']); ?></td>
                                            <td><?= array_key_exists($row['receiving_account'], $accounts) ? $accounts[$row['receiving_account']]['name'] : NULL; ?></td>
                                            <td><?= array_key_exists($row['receiving_currency'], $currencies) ? $currencies[$row['receiving_currency']]['symbol'] : NULL; ?><?= amount_number_format($row['receiving_amount']); $total_receiving_amount[] = $row['receiving_amount']; ?></td>
                                            <td><?= $row['receiving_narration']; ?></td>
                                            <td><?= array_key_exists($row['payment_account'], $accounts) ? $accounts[$row['payment_account']]['name'] : NULL; ?></td>
                                            <td><?= array_key_exists($row['payment_currency'], $currencies) ? $currencies[$row['payment_currency']]['symbol'] : NULL; ?><?= amount_number_format($row['payment_amount']); $total_payment_amount[] = $row['payment_amount']; ?></td>
                                            <td><?= $row['payment_narration']; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>    
                        </div>

                    <?php } ?>

                    <?php if($search_module == 'purchases'){?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width:80px;"><input type="checkbox" id="system-approvals-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'sr_#'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'ref_#'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'invoice_total'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'paid'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'pending'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'transport_expenses'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'supplier'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'by'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($pageData as $row){
                                        $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                        $sub_total_amount = $row['sub_total_amount'];
                                        $paid_amount = $row['paid_amount'];
                                        $pending_amount = $row['pending_amount'];
                                        $discount_amount = $row['discount_amount'];
                                        $transport_expense = $row['transport_expense'];
                                        
                                    ?>
                                        <tr class="text-center">
                                            <td><input type="checkbox" style="margin: 5px;" class="system-approvals-checkbox" name="system_approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                            <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                            <td><?= print_lang($app_lang,'ledgers_module_wise_sr_prefix_purchases').''.$row['serial_id']; ?></td>
                                            <td><?= $row['invoice']; ?></td>
                                            <td><?= $currency_show; ?></td>
                                            <td><?= round_decimels_digits($sub_total_amount); $sub_total_amount_total[] = (float)$sub_total_amount; ?></td>
                                            <td><?= round_decimels_digits($paid_amount); $paid_amount_total[] = (float)$paid_amount; ?></td>
                                            <td><?= round_decimels_digits($pending_amount); $pending_amount_total[] = (float)$pending_amount; ?></td>
                                            <td><?= round_decimels_digits($discount_amount); $discount_amount_total[] = (float)$discount_amount; ?></td>
                                            <td><?= round_decimels_digits($transport_expense); $transport_expense_total[] = (float)$transport_expense; ?></td>
                                            <td>
                                                <?= array_key_exists($row['supplier'], $accounts) ? $accounts[$row['supplier']]['name'] : NULL; ?>
                                                <?= array_key_exists($row['supplier'], $accounts) ? $accounts[$row['supplier']]['name'] : NULL; ?>
                                            </td>
                                            <td><?= $row['user_name']; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>    
                        </div>

                    <?php } ?>


                    <?php if($search_module == 'sales'){?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width:80px;"><input type="checkbox" id="system-approvals-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'sr_#'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'invoice_#'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'sales_total_amount'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'invoice_total'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'received'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'remaining'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'transport_expenses'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'memo'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'by'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($pageData as $row){
                                        $row_sub_total = $row['sub_total'];
                                        $row_invoice_total = $row['total_sales_amount'];
                                        $row_cash_received = $row['cash_received'];
                                        $row_remaining_amount = $row['remaining_amount'];
                                        $row_trans_expense = $row['trans_expense'];
                                        $row_total_profit_amount = $row['total_profit_amount'];
                                        $row_total_discount_amount = $row['total_discount_amount'];

                                        $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                        
                                    ?>
                                        <tr class="text-center">
                                            <td><input type="checkbox" style="margin: 5px;" class="system-approvals-checkbox" name="system_approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                            <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                            <td><?= $row['invoice']; ?></td>
                                            <td>
                                                <?php 
                                                if(strpos($row['client'],"CASHSALE") === FALSE){
                                                    echo array_key_exists($row['client'], $accounts) ? $accounts[$row['client']]['name'] : NULL; 
                                                }
                                                else
                                                {
                                                    echo $row['cash_client_name'];
                                                }
                                                ?>
                                                <?= array_key_exists($row['client'], $accounts) ? $accounts[$row['client']]['name'] : NULL; ?>
                                            </td>
                                            <td><?= $currency_show; ?></td>
                                            <td><?= round_decimels_digits($row_invoice_total); ?></td>
                                            <td><?= round_decimels_digits($row_total_discount_amount); ?></td>
                                            <td><?= round_decimels_digits($row_sub_total); ?></td>
                                            <td><?= round_decimels_digits($row_cash_received); ?></td>
                                            <td><?= round_decimels_digits($row_remaining_amount); ?></td>
                                            <td><?= round_decimels_digits($row_trans_expense); ?></td>
                                            <td><?= round_decimels_digits($row_total_profit_amount); ?></td>
                                            
                                            <td><?= $row['memo']; ?></td>
                                            <td><?= $row['user_name']; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>    
                        </div>

                    <?php } ?>








                    

                </div>
            </div>
        </div>
    </div>
</div>