<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_items_token_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_items_token_view_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <a href="<?php echo url('/tokens/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_items_token_view_add_btn'); ?></a>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_items_token_view_title_listing'); ?></h2>

                    <form id="tokens-search-form" action="<?= url('/tokens'); ?>">
                        <div class="row">

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_items_token_add_input_client'); ?> <strong class="text-danger">*</strong></label>
                                    <select class="form-control chosen-select" name="client">
                                        <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_items_token_add_input_client'); ?> --</option>
                                        <?php foreach($clients as $row){ ?>
                                            <option <?php if($search_client == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>" data-address="<?= $row['address']; ?>" ><?= $row['name'].' ( Client)'; ?></option>
                                        <?php } ?>
                                        <?php foreach($suppliers as $row){ ?>
                                            <option <?php if($search_client == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>" data-address="<?= $row['address']; ?>"><?= $row['name'].' ( Supplier)'; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_items_token_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                                    <select class="form-control chosen-select" name="item">
                                        <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_items_token_add_input_item'); ?> --</option>
                                        <?php foreach($items as $row){ ?>
                                            <option <?php if($search_item == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>" data-token-rate="<?= $row['token_rate']; ?>"><?= $row['name'].' - '.$row['item_id']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 text-right" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            </div>
                        </div>
                    </form>

                    <div class="row">
                        <div class="col-md-4">
                            <h4><?= print_lang($app_lang,'mod_items_token_view_total_sold_tokens'); ?></h4>
                            <h4><?= $sold_qty; ?>/<?= amount_number_format($sold_qty * $token_rate); ?></h4>
                        </div>

                        <div class="col-md-4">
                            <h4><?= print_lang($app_lang,'mod_items_token_view_total_purchased_tokens'); ?></h4>
                            <h4><?= $purchased_qty; ?>/<?= amount_number_format($purchased_qty * $token_rate); ?></h4>
                        </div>

                        <div class="col-md-4">
                            <h4><?= print_lang($app_lang,'mod_items_token_view_total_pending_tokens'); ?></h4>
                            <h4><?= $available_qty; ?>/<?= amount_number_format($available_qty * $token_rate); ?></h4>
                        </div>
                    </div>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_sold_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_sold_value'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_purchased_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_purchased_value'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_items_token_view_thead_balance'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(date('Y-m-d',strtotime($row['token_date']))); ?></td>
                                        <td><?= $row['client_name']; ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= $row['sold_qty']; ?></td>
                                        <td><?= $row['currency_symbol'].' '.$row['sold_amount']; ?></td>
                                        <td><?= $row['purchase_qty']; ?></td>
                                        <td><?= $row['currency_symbol'].' '.$row['purchase_amount']; ?></td>
                                        <td><?= $row['balance']; ?></td>
                                        <td>
                                            <a href="<?= url('/tokens/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <a href="<?= url('/tokens/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>