<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_transfer'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/transfer'); ?>"><?= print_lang($app_lang,'transfer'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_transfer'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="transfer-form" action="<?php echo url('/transfer/update').'/'.$editing_data['uid']; ?>">
                    <input type="hidden" name="sending_warehouse" value="<?= $editing_data['sending_warehouse']; ?>">
                    <div class="row extra-mar-botm">
                        <div class="col-md-12" style="padding-bottom: 6px;">
                            <?php 
                            $item_data = fetch_table_where('items','uid',$editing_data['item'],true);
                            $items_batch = get_item_warehouse_wise_batch($editing_data['item'],$editing_data['sending_warehouse']);
                            ?>
                            <h2><?= print_lang($app_lang,'transferring_item'); ?>&nbsp;&nbsp;<strong><?= isset($item_data['name']) ? $item_data['name'] : null; ?></strong></h2>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'batch'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="batch">
                                    <?php foreach($items_batch as $row){ ?>
                                        <option <?php if($editing_data['batch'] == $row['batch']){ echo 'selected="selected"'; } ?> value="<?= $row['batch']; ?>"><?= $row['batch'].' ('.$row['stock_ava'].')'; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'receiving_warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="receiving_warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <?php if($row['uid'] == $editing_data['sending_warehouse']){ continue; } ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['receiving_warehouse'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="unit">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                    <?php if(isset($item_data['production_unit'])){ ?>
                                        <option value="purchase" <?php if($editing_data['unit'] == 'purchase'){ echo 'selected="selected"'; } ?>><?= array_key_exists($item_data['purchase_unit'],$units) ? $units[$item_data['purchase_unit']]['name'] : NULL; ?></option>
                                        <?php if($item_data['purchase_unit'] != $item_data['sale_unit']){?>
                                            <option value="sale" <?php if($editing_data['unit'] == 'sale'){ echo 'selected="selected"'; } ?>><?= array_key_exists($item_data['sale_unit'],$units) ? $units[$item_data['sale_unit']]['name'] : NULL; ?></option>
                                        <?php } ?>
                                        <?php if($item_data['production_unit'] != $item_data['purchase_unit'] && $item_data['production_unit'] != $item_data['sale_unit']){?>
                                            <option value="production" <?php if($editing_data['unit'] == 'production'){ echo 'selected="selected"'; } ?>><?= array_key_exists($item_data['production_unit'],$units) ? $units[$item_data['production_unit']]['name'] : NULL; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        
                    </div>

                    <div class="row extra-mar-botm">

                        <?php $item_settings = get_item_settings(); ?>
                        <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'bundle'); ?></label>
                                    <input type="number" class="form-control" name="bundle" value="<?= $editing_data['bundle']; ?>" placeholder="<?= print_lang($app_lang,'bundle'); ?>">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'toop'); ?></label>
                                    <input type="number" class="form-control" name="toop" value="<?= $editing_data['toop']; ?>" placeholder="<?= print_lang($app_lang,'toop'); ?>">
                                </div>
                            </div>
                        <?php } ?>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'narration'); ?> <strong class="text-danger">*</strong></label>
                                <textarea class="form-control" name="narration" rows="3" placeholder="<?= print_lang($app_lang,'narration'); ?>"><?= $editing_data['narration']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/transfer'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>