<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'transfer'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'transfer'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'transfer_listing'); ?></h2>

                    <form id="transfer-search-form" action="<?= url('/transfer'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="item">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                                <?php foreach($items as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="warehouse">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                                <?php foreach($warehouse as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_warehouse == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_country_thead'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_company_thead'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_details_thead'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'from'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'to'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'bundle'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'toop'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $total_qty = array();
                                $total_bundle = array();
                                $total_toop = array();
                                 $i = 1; 
                                 foreach($pageData as $row){ ?>
                                    <?php
                                        $unit_name = NULL;
                                        $item_name = NULL;
                                        $item_country = null;
                                        $item_company = null;
                                        $item_details = null;
                                        if(array_key_exists($row['item'], $items))
                                        {
                                            $selected_item = $items[$row['item']];
                                            $item_name = $selected_item['name'];
                                            $item_country = $selected_item['country'];
                                            $item_company = $selected_item['company'];
                                            $item_details = $selected_item['details'];
                                            if($row['unit'] == 'purchase')
                                            {
                                                $unit_name = array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL;
                                            }
                                            if($row['unit'] == 'sale')
                                            {
                                                $unit_name = array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL;
                                            }
                                            if($row['unit'] == 'production')
                                            {
                                                $unit_name = array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL;
                                            }
                                        }
                                    ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= date('Y/m/d',strtotime(display_true_date(explode(' ',$row['created_at'])[0]))); ?></td>
                                        <td><?= $item_name; ?></td>
                                        <td><?= $item_country; ?></td>
                                        <td><?= $item_company; ?></td>
                                        <td><?= $item_details; ?></td>
                                        <td><?= array_key_exists($row['sending_warehouse'], $warehouse) ? $warehouse[$row['sending_warehouse']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['receiving_warehouse'], $warehouse) ? $warehouse[$row['receiving_warehouse']]['name'] : NULL; ?></td>
                                        <td><?= $row['qty']; $total_qty[] = $row['qty']; ?></td>
                                        <td><?= $unit_name; ?></td>
                                        <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                            <td><?= $row['bundle']; $total_bundle[] = $row['bundle']; ?></td>
                                            <td><?= $row['toop']; $total_toop[] = $row['toop']; ?></td>
                                        <?php } ?>
                                        <td><?= $row['narration']; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_warehouse_transfer') === TRUE){ ?>
                                                <a href="<?= url('/transfer/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_warehouse_transfer') === TRUE){ ?>
                                                <a href="<?= url('/transfer/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($total_qty)); ?></td>
                                    <td></td>
                                    <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                        <td><?= round_decimels_digits(array_sum($total_bundle)); ?></td>
                                        <td><?= round_decimels_digits(array_sum($total_toop)); ?></td>
                                    <?php } ?>
                                    <td></td>
                                    <td></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>