<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_trans_out_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_trans_out_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_transfer_out_ph') === TRUE){ ?>
                <a href="<?= url('/transfer-out/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_trans_out_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_trans_out_view_title'); ?></h2>

                    <form id="transfer-out-search-form" action="<?= url('/transfer-out'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'convert_currency'); ?></label>
                                        <select class="form-control chosen-select" name="convert_currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'convert_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_convert_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'client'); ?></label>
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_trans_out_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_trans_out_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_trans_out_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_trans_out_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_trans_out_view_thead_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_trans_out_view_thead_client'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $grand_total_amount_total = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                    $grand_total = $row['grand_total'];
                                    if(!empty($search_convert_currency))
                                    {
                                        $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                        $currency_show = $convert_currency_record['name'];
                                        $amount_currency_equalance = $row['currency_usd_equalance'];
                                        $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                        if($row['currency'] == $search_convert_currency)
                                        {
                                            $amount_currency_equalance = 1;
                                            $convert_currency_equalance = 1;
                                        }
                                        
                                        $grand_total = amount_conversion($row['grand_total'], $amount_currency_equalance, $convert_currency_equalance);
                                        
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= round_decimels_digits($grand_total); $grand_total_amount_total[] = (float)$grand_total; ?></td>
                                        <td><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>

                                        <td>
                                            <?php if(check_user_access('invoice_transfer_out_ph') === TRUE){ ?>
                                                <a href="<?= url('/transfer-out/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i><?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_transfer_out_ph') === TRUE){ ?>
                                                <a href="<?= url('/transfer-out/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_transfer_out_ph') === TRUE){ ?>
                                                <a href="<?= url('/transfer-out/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($grand_total_amount_total)); ?></strong></td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>