<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'new_transit'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/transit'); ?>"><?= print_lang($app_lang,'transit'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_transit'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="transit-temp-form">

                    <div class="row transit-static-row" style="margin-bottom: 5px;">
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_base_currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" data-name="<?= $row['name']; ?>" data-symbol="<?= $row['symbol']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="temp_transit_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="temp_transit_date">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'transit_serial_num'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="temp_transit_serial_num" value="<?= $transit_serial; ?>" placeholder="<?= print_lang($app_lang,'transit_serial_num'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'builty_num'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="temp_builty_num" placeholder="<?= print_lang($app_lang,'builty_num'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'transit_company'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="temp_transit_company" placeholder="<?= print_lang($app_lang,'transit_company'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_account">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'account'); ?> --</option>
                                            <?php foreach($accounts as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" data-name="<?= $row['name']; ?>" data-symbol="<?= $row['symbol']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="number" class="form-control" name="temp_amount" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_narration'); ?></label>
                                <textarea style="height: 35px;" class="form-control" name="temp_expense_narration" rows="1" placeholder="<?= print_lang($app_lang,'expense_narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_to_transit'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="transit-form" action="<?= url('/transit/save'); ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'expense_narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'rate'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'by_base_currency'); ?></th>
                                    <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="transit-table-body"></tbody>
                        </table>    
                    </div>
                </div>
            </div>
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-9">
                    <p style="line-height: 36px;"><?= print_lang($app_lang,'total_expenses_by_base_currency'); ?>: <span>0.00</span><input type="hidden" name="total_amount_by_base_currency" value=""></p>
                </div>
                <div class="col-md-3">
                    <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                </div>
            </div>
        </form>

    </div>
</div>