<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'transit'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'transit'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_transit') === TRUE){ ?>
                <a href="<?php echo url('/transit/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'new_transit'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'transit_listing'); ?></h2>
                    
                    <form id="transit-search-form" action="<?= url('/transit'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <input type="text" class="form-control" name="company" value="<?= $search_company; ?>" placeholder="<?= print_lang($app_lang,'company'); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="javascript:void(0);" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'builty_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'company'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'serial_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_expense'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expenses_from_purchases'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'remaining'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['transit_date']); ?></td>
                                        <td><?= $row['builty_num']; ?></td>
                                        <td><?= $row['company']; ?></td>
                                        <td><?= $row['serial_num']; ?></td>
                                        <td><?= amount_number_format($row['total_exp']); ?></td>
                                        <td><?= amount_number_format($row['from_purchases']); ?></td>
                                        <td><?= amount_number_format($row['pending']); ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_transit') === TRUE){ ?>
                                                <a href="<?= url('/transit/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_transit') === TRUE){ ?>
                                                <a href="<?= url('/transit/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>