<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_turnover_add_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/turnover'); ?>"><?= print_lang($app_lang,'mod_turnover_sidebar_main_menu'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_turnover_add_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->

        <div class="row">
            <div class="col-sm-12 b-r">
                <form id="turnover-add-search-form" action="<?php echo url('/turnover/add'); ?>">

                    <div class="row extra-mar-botm">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_turnover_add_input_currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option <?php if($search_currency == $row['uid']){echo "selected='selected'"; }?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_turnover_add_input_from'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'mod_turnover_add_input_from'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_turnover_add_input_to'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'mod_turnover_add_input_to'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-3 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'mod_turnover_add_input_search_button'); ?></button>
                        </div>
                        
                    </div>

                </form>
            </div>
        </div>





        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="turnover-form" action="<?php echo url('/turnover/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th colspan="3" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 18px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 18px !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title'); ?></th>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%;"></td>
                                            <th colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 16px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 16px !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_date_range'); ?></th>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_begining_date'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <input type="hidden" name="from_date" value="<?= date('Y/m/d',strtotime($search_from)); ?>">
                                                <?php
                                                    if(!empty($search_from))
                                                    {
                                                        echo date('Y/m/d',strtotime($search_from));
                                                    }
                                                ?>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_end_date'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <input type="hidden" name="to_date" value="<?= date('Y/m/d',strtotime($search_to)); ?>">
                                                <?php
                                                    if(!empty($search_to))
                                                    {
                                                        echo date('Y/m/d',strtotime($search_to));
                                                    }
                                                ?>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_currency'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    if(!empty($requested_currency_data))
                                                    {
                                                        echo isset($requested_currency_data['symbol']) ? $requested_currency_data['symbol'] : null;
                                                    }
                                                ?>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%;"></td>
                                            <th colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 16px;; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 16px; !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_revenue'); ?></th>
                                            <input type="hidden" name="currency" value="<?= $requested_currency_data['uid']; ?>">
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_sales_income'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                $total_revenue = [];
                                                $total_expenses = [];
                                                    $sales = isset($pageData['sales_all_in_main_currency']) ? $pageData['sales_all_in_main_currency'] : 0;
                                                    $lots = isset($pageData['lots_sales_all_in_main_currency']) ? $pageData['lots_sales_all_in_main_currency'] : 0;
                                                    $cars = isset($pageData['cars_sales_all_in_main_currency']) ? $pageData['cars_sales_all_in_main_currency'] : 0;
                                                    $profits = isset($pageData['earnings_all_in_main_currency']) ? $pageData['earnings_all_in_main_currency'] : 0;
                                                    $sales_income = $sales + $lots + $cars + $profits;
                                                    $total_revenue[] = $sales_income;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($sales_income);
                                                ?>
                                                <input type="hidden" name="sales_income" value="<?= $sales_income; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_services_income'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $services_income = isset($pageData['services_all_in_main_currency']) ? $pageData['services_all_in_main_currency'] : 0;
                                                    $total_revenue[] = $services_income;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($services_income);
                                                ?>
                                                <input type="hidden" name="services_income" value="<?= $services_income; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_other_income'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $other_income = isset($pageData['other_income_all_in_main_currency']) ? $pageData['other_income_all_in_main_currency'] : 0;
                                                    $total_revenue[] = $other_income;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($other_income);
                                                ?>
                                                <input type="hidden" name="other_income" value="<?= $other_income; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px; background: #efefef;"><?= print_lang($app_lang,'financial_income_statement_title_net_income'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; background: #efefef; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    echo $requested_currency_data['symbol'].' '.amount_number_format(array_sum($total_revenue));
                                                ?>
                                                <input type="hidden" name="total_revenue" value="<?= array_sum($total_revenue); ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%;"></td>
                                            <th colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 16px;; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 16px; !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_operating_expenses'); ?></th>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_cost_of_goods'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $costs_of_goods_sold = isset($pageData['costs_of_goods_sold']) ? $pageData['costs_of_goods_sold'] : 0;
                                                    $total_expenses[] = $costs_of_goods_sold;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($costs_of_goods_sold);
                                                ?>
                                                <input type="hidden" name="costs_of_goods_sold" value="<?= $costs_of_goods_sold; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_salaries'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $salaries = isset($pageData['salaries_all_in_main_currency']) ? $pageData['salaries_all_in_main_currency'] : 0;
                                                    $total_expenses[] = $salaries;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($salaries);
                                                ?>
                                                <input type="hidden" name="salaries" value="<?= $salaries; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_expenses'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $expenses = isset($pageData['expenses_all_in_main_currency']) ? $pageData['expenses_all_in_main_currency'] : 0;
                                                    $total_expenses[] = $expenses;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($expenses);
                                                ?>
                                                <input type="hidden" name="expenses" value="<?= $expenses; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_assets'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $assets = isset($pageData['assets_all_in_main_currency']) ? $pageData['assets_all_in_main_currency'] : 0;
                                                    $total_expenses[] = $assets;

                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($assets);
                                                ?>
                                                <input type="hidden" name="assets" value="<?= $assets; ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="width: 10%; padding: 3px;"></td>
                                            <td style="width: 60%; padding: 3px; color: #000; font-size: 15px; background: #efefef;"><?= print_lang($app_lang,'financial_income_statement_title_total_expenses'); ?></td>
                                            <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; background: #efefef; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    echo $requested_currency_data['symbol'].' '.amount_number_format(array_sum($total_expenses));
                                                ?>
                                                <input type="hidden" name="total_expenses" value="<?= array_sum($total_expenses); ?>">
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 18px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 18px !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_net_profit'); ?></td>
                                            <td style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 18px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 18px !important; vertical-align: middle; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                                <?php
                                                    $net_income = array_sum($total_revenue) - array_sum($total_expenses);
                                                    echo $requested_currency_data['symbol'].' '.amount_number_format($net_income);
                                                ?>
                                                <input type="hidden" name="net_income" value="<?= $net_income; ?>">
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <?php foreach($shareholders as $row){
                        $shareholder_amount = ((float)$net_income * (float)$row['percentage']) / 100;
                    ?>
                        <div class="row extra-mar-botm <?= $row['uid']; ?>">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input type="text" readonly class="form-control" value="<?= $row['name'].' '.$row['last_name']; ?>">
                                    <input type="hidden" readonly class="form-control" name="shareholder[]" value="<?= $row['uid']; ?>">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <input type="number" data-shareholder-id="<?= $row['uid']; ?>" readonly value="<?= $row['percentage']?>" name="percentage[]" data-net-profit="<?= $net_income; ?>" class="form-control shareholder-percentage" placeholder="10%">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <input type="number" readonly class="form-control shareholder-<?= $row['uid']; ?>" name="amount[]" value="<?= $shareholder_amount; ?>" placeholder="1000">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/turnover'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>
