<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_user'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/users'); ?>"><?= print_lang($app_lang,'users'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_user'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="user-form" action="<?php echo url('/users/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="name" placeholder="<?= print_lang($app_lang,'name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'email'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="email" placeholder="<?= print_lang($app_lang,'email'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'phone'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="phone" placeholder="<?= print_lang($app_lang,'phone'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'role'); ?> <strong class="text-danger">*</strong></label>
                                <select class="chosen-select form-control" name="role">
                                    <option selected="" value="USER"><?= print_lang($app_lang,'user'); ?></option>
                                    <option value="ADMIN"><?= print_lang($app_lang,'admin'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'username'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="username" placeholder="<?= print_lang($app_lang,'usrname'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'password'); ?> <strong class="text-danger">*</strong></label>
                                <input type="password" class="form-control" name="password" placeholder="<?= print_lang($app_lang,'password'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group branch-select-area">
                                <label><?= print_lang($app_lang,'branch'); ?> <strong class="text-danger">*</strong></label>
                                <select class="chosen-select form-control" name="branch">
                                    <option selected="" disabled="">-- <?= print_lang($app_lang,'select_branch'); ?> --</option>
                                    <?php foreach($branches as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['branch_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'address'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="address" placeholder="<?= print_lang($app_lang,'address'); ?>">
                            </div>
                        </div>
                    </div>

                    <!-- right html markups -->
                    <div id="rights-markups-area">

                        <div class="row extra-mar-botm">
                            <div class="col-md-6">
                                <label>User Rights</label>
                            </div>
                            <div class="col-md-6 text-right">
                                <div class="checkbox checkbox-success checkbox-inline">
                                    <input type="checkbox" id="check-all-rights">
                                    <label for="check-all-rights"><?= print_lang($app_lang,'check_all_rights'); ?></label>
                                </div>
                            </div>
                        </div>

                        <div class="row rights-row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'approval_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_1" class="all-module-checker">
                                                            <label for="check_all_right_elem_1"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-342112441" value="sub_approval">
                                                            <label for="user-right-1"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sub_approval_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-34211244341" value="main_approval">
                                                            <label for="user-right-2"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'main_approval_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_stock_in_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_item_stock_in_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_item_stock_in_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_item_stock_in_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_item_stock_in_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_stock_out_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_item_stock_out_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_item_stock_out_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_item_stock_out_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_item_stock_out_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_item_stock_balance_report">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_item_stock_balance_report'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'journal_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_1" class="all-module-checker">
                                                            <label for="check_all_right_elem_1"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1" value="view_journal">
                                                            <label for="user-right-1"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-2" value="add_journal">
                                                            <label for="user-right-2"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-3" value="edit_journal">
                                                            <label for="user-right-3"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-4" value="delete_journal">
                                                            <label for="user-right-4"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sales_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_2" class="all-module-checker">
                                                            <label for="check_all_right_elem_2"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-5" value="view_sale">
                                                            <label for="user-right-5"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-6" value="add_sale">
                                                            <label for="user-right-6"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_print_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-7" value="edit_sale">
                                                            <label for="user-right-7"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-8" value="delete_sale">
                                                            <label for="user-right-8"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_3" class="all-module-checker">
                                                            <label for="check_all_right_elem_3"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-9" value="view_purchase">
                                                            <label for="user-right-9"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-10" value="add_purchase">
                                                            <label for="user-right-10"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_print_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11" value="edit_purchase">
                                                            <label for="user-right-11"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-12" value="delete_purchase">
                                                            <label for="user-right-12"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'production_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_4" class="all-module-checker">
                                                            <label for="check_all_right_elem_4"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-13" value="view_production">
                                                            <label for="user-right-13"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-14" value="add_production">
                                                            <label for="user-right-14"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_print_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-15" value="edit_production">
                                                            <label for="user-right-15"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-16" value="delete_production">
                                                            <label for="user-right-16"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'items_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_5" class="all-module-checker">
                                                            <label for="check_all_right_elem_5"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-17" value="view_item">
                                                            <label for="user-right-17"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-18" value="add_item">
                                                            <label for="user-right-18"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-19" value="edit_item">
                                                            <label for="user-right-19"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-20" value="delete_item">
                                                            <label for="user-right-20"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-21" value="view_item_image">
                                                            <label for="user-right-21"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'view_image_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'warehouse_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_6" class="all-module-checker">
                                                            <label for="check_all_right_elem_6"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-22" value="view_warehouse">
                                                            <label for="user-right-22"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-23" value="add_warehouse">
                                                            <label for="user-right-23"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-24" value="edit_warehouse">
                                                            <label for="user-right-24"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-25" value="delete_warehouse">
                                                            <label for="user-right-25"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-26" value="warehouse_details">
                                                            <label for="user-right-26"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'warehouse_details_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'warehouse_transfer_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_7" class="all-module-checker">
                                                            <label for="check_all_right_elem_7"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-27" value="view_warehouse_transfer">
                                                            <label for="user-right-27"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-28" value="add_warehouse_transfer">
                                                            <label for="user-right-28"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-29" value="edit_warehouse_transfer">
                                                            <label for="user-right-29"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-30" value="delete_warehouse_transfer">
                                                            <label for="user-right-30"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'damage_stock_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_8" class="all-module-checker">
                                                            <label for="check_all_right_elem_8"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-31" value="view_damage_stock">
                                                            <label for="user-right-31"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-32" value="add_damage_stock">
                                                            <label for="user-right-32"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-33" value="edit_damage_stock">
                                                            <label for="user-right-33"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-34" value="delete_damage_stock">
                                                            <label for="user-right-34"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'expense_types_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_9" class="all-module-checker">
                                                            <label for="check_all_right_elem_9"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-35" value="view_expense_type">
                                                            <label for="user-right-35"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-36" value="add_expense_type">
                                                            <label for="user-right-36"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-37" value="edit_expense_type">
                                                            <label for="user-right-37"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-38" value="delete_expense_type">
                                                            <label for="user-right-38"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'expense_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_10" class="all-module-checker">
                                                            <label for="check_all_right_elem_10"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-39" value="view_expense">
                                                            <label for="user-right-39"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-40" value="add_expense">
                                                            <label for="user-right-40"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-41" value="edit_expense">
                                                            <label for="user-right-41"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-42" value="delete_expense">
                                                            <label for="user-right-42"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_11" class="all-module-checker">
                                                            <label for="check_all_right_elem_11"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-43" value="expense_report">
                                                            <label for="user-right-43"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'expense_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-23423423" value="stock_general_ledger">
                                                            <label for="user-right-23423423"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'stock_general_ledger'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-23423423443243" value="audit_report">
                                                            <label for="user-right-23423423443243"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'audit_report'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-44" value="raw_warehouse_report">
                                                            <label for="user-right-44"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'raw_warehouse_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-45" value="sales_warehouse_report">
                                                            <label for="user-right-45"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_warehouse_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-46" value="items_ledger_report">
                                                            <label for="user-right-46"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'items_ledger_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_12" class="all-module-checker">
                                                            <label for="check_all_right_elem_12"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-47" value="damage_stock_report">
                                                            <label for="user-right-47"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'damage_stock_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-48" value="sales_report">
                                                            <label for="user-right-48"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sales_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-49" value="sales_item_report">
                                                            <label for="user-right-49"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sales_item_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-50" value="purchase_report">
                                                            <label for="user-right-50"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'purchase_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_13" class="all-module-checker">
                                                            <label for="check_all_right_elem_13"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-51" value="purchase_item_report">
                                                            <label for="user-right-51"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'purchase_item_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-52" value="production_report">
                                                            <label for="user-right-52"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'production_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-53" value="client_item_report">
                                                            <label for="user-right-53"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'client_item_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-54" value="purchase_expense_report">
                                                            <label for="user-right-54"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'purchase_expenses_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-541" value="balance_summary_report">
                                                            <label for="user-right-541"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'balance_summary_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-542" value="inventory_report">
                                                            <label for="user-right-542"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'inventory_report_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-542767" value="sale_stock_report">
                                                            <label for="user-right-542767"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_stock_report_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-542767456" value="item_stock_report">
                                                            <label for="user-right-542767456"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'items_stock_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_14" class="all-module-checker">
                                                            <label for="check_all_right_elem_14"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-55" value="sale_expense_report">
                                                            <label for="user-right-55"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_expenses_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-56" value="production_expense_report">
                                                            <label for="user-right-56"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'production_expenses_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-57" value="warehouse_transfer_report">
                                                            <label for="user-right-57"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'warehouse_transfer_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-58" value="sale_discount_report">
                                                            <label for="user-right-58"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_discount_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-58" value="sale_discount_report_2">
                                                            <label for="user-right-58"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_discount_report_rights_2'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-59" value="purchase_discount_report">
                                                            <label for="user-right-59"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'purchase_discount_report_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-594234" value="transfer_in_discount_1">
                                                            <label for="user-right-594234"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'trans_in_dis_1_report_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-59234234" value="transfer_in_discount_2">
                                                            <label for="user-right-59234234"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'trans_in_dis_2_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'financial_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_15" class="all-module-checker">
                                                            <label for="check_all_right_elem_15"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-63240" value="chart_of_accounts">
                                                            <label for="user-right-63240"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'financial_balance_chart_of_accounts'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-60" value="balance_sheet">
                                                            <label for="user-right-60"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'financial_balance_sheet_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-61" value="trial_balance">
                                                            <label for="user-right-61"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_trial_balance_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-61" value="cash_flow">
                                                            <label for="user-right-61"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_cash_flow_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-62" value="income_statement">
                                                            <label for="user-right-62"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_income_statement_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-63" value="profit_loss">
                                                            <label for="user-right-63"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_profit_loss_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-64" value="client_balance_summary">
                                                            <label for="user-right-64"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_balance_summary_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-245235" value="marketers_balance_summary">
                                                            <label for="user-right-245235"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_marketers_balance_summary'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-342552" value="salesman_receovery">
                                                            <label for="user-right-342552"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_salesman_receovery'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-325525" value="income_expenses">
                                                            <label for="user-right-325525"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_income_expenses'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-325525" value="day_closing">
                                                            <label for="user-right-325525"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_day_closing'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'accounts_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_16" class="all-module-checker">
                                                            <label for="check_all_right_elem_16"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-65" value="view_account">
                                                            <label for="user-right-65"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-66" value="add_account">
                                                            <label for="user-right-66"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-67" value="edit_account">
                                                            <label for="user-right-67"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-68" value="delete_account">
                                                            <label for="user-right-68"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'invoice_counters_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_17" class="all-module-checker">
                                                            <label for="check_all_right_elem_17"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-69" value="view_invoice_counter">
                                                            <label for="user-right-69"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-70" value="edit_invoice_counter">
                                                            <label for="user-right-70"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'currency_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_18" class="all-module-checker">
                                                            <label for="check_all_right_elem_18"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-71" value="view_currency">
                                                            <label for="user-right-71"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-72" value="add_currency">
                                                            <label for="user-right-72"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-73" value="edit_currency">
                                                            <label for="user-right-73"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-74" value="delete_currency">
                                                            <label for="user-right-74"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-75" value="view_currency_rates">
                                                            <label for="user-right-75"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'view_currency_rates'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-75" value="edit_currency_rates">
                                                            <label for="user-right-75"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_currency_rates'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'units_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_19" class="all-module-checker">
                                                            <label for="check_all_right_elem_19"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-76" value="view_units">
                                                            <label for="user-right-76"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-77" value="add_units">
                                                            <label for="user-right-77"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-78" value="edit_units">
                                                            <label for="user-right-78"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-79" value="delete_units">
                                                            <label for="user-right-79"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'batch_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_20" class="all-module-checker">
                                                            <label for="check_all_right_elem_20"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-80" value="view_batch">
                                                            <label for="user-right-80"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-81" value="add_batch">
                                                            <label for="user-right-81"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-82" value="edit_batch">
                                                            <label for="user-right-82"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-83" value="delete_batch">
                                                            <label for="user-right-83"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'product_categories_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_21" class="all-module-checker">
                                                            <label for="check_all_right_elem_21"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-84" value="view_product_categories">
                                                            <label for="user-right-84"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-85" value="add_product_categories">
                                                            <label for="user-right-85"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-86" value="edit_product_categories">
                                                            <label for="user-right-86"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-87" value="delete_product_categories">
                                                            <label for="user-right-87"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'branches_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_22" class="all-module-checker">
                                                            <label for="check_all_right_elem_22"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-88" value="view_branch">
                                                            <label for="user-right-88"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-89" value="add_branch">
                                                            <label for="user-right-89"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-90" value="edit_branch">
                                                            <label for="user-right-90"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-91" value="delete_branch">
                                                            <label for="user-right-91"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-911" value="item_settings">
                                                            <label for="user-right-911"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'item_settings'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'language_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_23" class="all-module-checker">
                                                            <label for="check_all_right_elem_23"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-92" value="view_language">
                                                            <label for="user-right-92"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-93" value="add_language">
                                                            <label for="user-right-93"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-94" value="edit_language">
                                                            <label for="user-right-94"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-95" value="delete_language">
                                                            <label for="user-right-95"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-95" value="edit_language_phrase">
                                                            <label for="user-right-96"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_language_phrase'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'users_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_24" class="all-module-checker">
                                                            <label for="check_all_right_elem_24"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-97" value="view_user">
                                                            <label for="user-right-97"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-98" value="add_user">
                                                            <label for="user-right-98"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-99" value="edit_user">
                                                            <label for="user-right-99"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-100" value="delete_user">
                                                            <label for="user-right-100"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'all_accounts_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_25" class="all-module-checker">
                                                            <label for="check_all_right_elem_25"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-101" value="all_accounts_report">
                                                            <label for="user-right-101"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'all_accounts_reports_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'backup_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_26" class="all-module-checker">
                                                            <label for="check_all_right_elem_26"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-102" value="backup_right">
                                                            <label for="user-right-102"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'backup_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'calander_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_27" class="all-module-checker">
                                                            <label for="check_all_right_elem_27"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-103" value="calander_right">
                                                            <label for="user-right-103"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'calander_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'assets_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_26" class="all-module-checker">
                                                            <label for="check_all_right_elem_26"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-104" value="view_assets">
                                                            <label for="user-right-104"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-105" value="add_assets">
                                                            <label for="user-right-105"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-106" value="edit_assets">
                                                            <label for="user-right-106"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-107" value="delete_assets">
                                                            <label for="user-right-107"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_employees_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_27" class="all-module-checker">
                                                            <label for="check_all_right_elem_27"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-108" value="view_employee">
                                                            <label for="user-right-108"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-109" value="add_employee">
                                                            <label for="user-right-109"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-110" value="edit_employee">
                                                            <label for="user-right-110"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-111" value="delete_employee">
                                                            <label for="user-right-111"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_division_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_27" class="all-module-checker">
                                                            <label for="check_all_right_elem_27"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-108" value="view_division">
                                                            <label for="user-right-108"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-109" value="add_division">
                                                            <label for="user-right-109"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-110" value="edit_division">
                                                            <label for="user-right-110"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-111" value="delete_division">
                                                            <label for="user-right-111"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_increment_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_28" class="all-module-checker">
                                                            <label for="check_all_right_elem_28"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-112" value="view_increment">
                                                            <label for="user-right-112"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-113" value="add_increment">
                                                            <label for="user-right-113"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-114" value="delete_increment">
                                                            <label for="user-right-114"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_advance_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_29" class="all-module-checker">
                                                            <label for="check_all_right_elem_29"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-115" value="view_advance">
                                                            <label for="user-right-115"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-116" value="add_advance">
                                                            <label for="user-right-116"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-117" value="delete_advance">
                                                            <label for="user-right-117"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_payslips_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_30" class="all-module-checker">
                                                            <label for="check_all_right_elem_30"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-118" value="view_payslips">
                                                            <label for="user-right-118"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-119" value="add_payslips">
                                                            <label for="user-right-119"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-120" value="edit_payslips">
                                                            <label for="user-right-120"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-121" value="delete_payslips">
                                                            <label for="user-right-121"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-125" value="confirm_payslips">
                                                            <label for="user-right-125"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'confirm_payslips'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-122" value="paid_salaries">
                                                            <label for="user-right-122"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_paid_salaries'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_31" class="all-module-checker">
                                                            <label for="check_all_right_elem_31"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-123" value="hrm_reports_yearly">
                                                            <label for="user-right-123"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_reports_yearly'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-124" value="hrm_reports_monthly">
                                                            <label for="user-right-124"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_reports_monthly'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-12401" value="hrm_reports_attendence">
                                                            <label for="user-right-12401"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_reports_attendence'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-12402" value="hrm_attendence_rights">
                                                            <label for="user-right-12402"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_attendence_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- rights html markups -->

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'transit_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_2999" class="all-module-checker">
                                                            <label for="check_all_right_elem_2999"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1155" value="view_transit">
                                                            <label for="user-right-1155"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1166" value="add_transit">
                                                            <label for="user-right-1166"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11166" value="edit_transit">
                                                            <label for="user-right-11166"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177" value="delete_transit">
                                                            <label for="user-right-1177"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'quotation_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_29999" class="all-module-checker">
                                                            <label for="check_all_right_elem_29999"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11555" value="view_quotation">
                                                            <label for="user-right-11555"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-115555" value="view_converted_quotation">
                                                            <label for="user-right-115555"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'converted_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11666" value="add_quotation">
                                                            <label for="user-right-11666"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-111666" value="edit_quotation">
                                                            <label for="user-right-111666"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777" value="delete_quotation">
                                                            <label for="user-right-11777"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'lot_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_299999" class="all-module-checker">
                                                            <label for="check_all_right_elem_299999"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-115455" value="view_lot_purchase">
                                                            <label for="user-right-115455"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1155555" value="add_lot_purchase">
                                                            <label for="user-right-1155555"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1166667" value="edit_lot_purchase">
                                                            <label for="user-right-1166667"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11166668" value="delete_lot_purchase">
                                                            <label for="user-right-11166668"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11166668124" value="view_avail_lot">
                                                            <label for="user-right-11166668124"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_avail_lot_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177787" value="view_lot_sold">
                                                            <label for="user-right-1177787"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_lot_sold_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177798" value="add_lot_sold">
                                                            <label for="user-right-1177798"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_lot_sold_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177768" value="delete_lot_sold">
                                                            <label for="user-right-1177768"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_lot_sold_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777298" value="view_lot_moved">
                                                            <label for="user-right-11777298"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_lot_moved_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777198" value="add_lot_moved">
                                                            <label for="user-right-11777198"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_lot_moved_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777297" value="delete_lot_moved">
                                                            <label for="user-right-11777297"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_lot_moved_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-117772925" value="view_lot_difference_report">
                                                            <label for="user-right-117772925"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_difference_report_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777292511" value="view_iran_to_afghanistan_difference_report">
                                                            <label for="user-right-11777292511"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_iran_to_afghanistan_difference_report_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777292522" value="view_iran_to_border_difference_report">
                                                            <label for="user-right-11777292522"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_iran_to_border_difference_report_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-117772925222345" value="view_fuel_lose_report">
                                                            <label for="user-right-117772925222345"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_fuel_lose_report_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'dashboard_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_sales">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_sales'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_sales_return">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_sales_return'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_purchases'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_expenses'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_supplier_paid">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_supplier_paid'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_client_received">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_client_received'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_cash_in">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_cash_in'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_cash_out">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_cash_out'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_extra_income">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_extra_income'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_bank_in">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_bank_in'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_bank_out">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_bank_out'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'dashboard_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_sales">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_sales'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_purchases'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_current_stock">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_current_stock'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_receivable">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_receivable'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_payable">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_payable'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_cash">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_cash'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_bank">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_bank'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_expenses'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_damage_stock">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_damage_stock'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_fixed_assets">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_fixed_assets'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_equity">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_equity'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'dashboard_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dashboard_cash">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dashboard_cash_marquee'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="system_profit">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'system_profit'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_construction_stats">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_construction_stats'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_business_performance_stats">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_business_performance_stats'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_metu_performance_stats">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_metu_performance_stats'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_expenses_graph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_expenses_graph'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_profit_and_loss_graph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_profit_and_loss_graph'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_bank_accounts_notifications">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_bank_accounts_notifications'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_activity_alerts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_activity_alerts'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_items_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_items">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_items">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_items">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_items">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_warehouses_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_warehouses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_warehouses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_warehouses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_warehouses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="details_project_warehouses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'details'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_purchases_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_project_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_contracts_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_contracts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_contracts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_contracts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_contracts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_assigning_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_assigning">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_assigning">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_assigning">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_assigning">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_projects_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_projects">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_projects">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_projects">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_inprocess_projects_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_inprocess_projects">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_inprocess_projects_process_details">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'process_details'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_inprocess_projects_complete">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'complete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_completed_projects_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_completed_projects">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_completed_projects_process_details">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'process_details'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_completed_projects_incomplete">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'incomplete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_projects_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects_reports">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_projects_reports">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_projects_reports">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_projects_reports">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects_reports_details">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'details'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_projects_payments_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects_payments">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_projects_payments">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_projects_payments">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_projects_payments">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_payment_deductions_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_payment_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_payment_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_payment_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_payment_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_expenses_deductions_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="approve_project_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'approve'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_approved_expenses_deductions_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_approved_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_approved_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_approved_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_approved_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="disapprove_project_approved_expenses_deductions">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'disapprove'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_assign_report_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_assign_report">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_module_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_services_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_services_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_services_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_services_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_sales_module_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_services_sales_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_services_sales_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_services_sales_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_services_sales_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_services_sales_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_quotation_module_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_services_quotation_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_services_quotation_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_services_quotation_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_services_quotation_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_services_quotation_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="converted_services_quotation_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'converted_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="services_sales_reports_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'services_sales_reports_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="services_items_reports_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'services_items_reports_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->



                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_module_car_p_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="showroom_list_view">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_module_car_p_list_view'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td colspan="2"><strong><?= print_lang($app_lang,'showroom_car_purchase_rights'); ?></strong></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_add_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_add'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_edit_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_edit'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_delete_shor_car_purchases">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_delete'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_buy_car_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_add'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_edit_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_edit'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_delete_shor_buy_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_delete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_people_show_buy_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_add_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_add'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_edit_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_edit'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_delete_shor_people_cars">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_delete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->



                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_load_delivery_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_load_delivery">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_load_delivery">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_load_delivery">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_load_delivery">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_load_delivery">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_custom_exp_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_custom_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_custom_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_custom_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_custom_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_custom_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_custom_char_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_custom_charges">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_custom_charges">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_custom_charges">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_custom_charges">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_custom_charges">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_fix_expense_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_fixing_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_fixing_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_fixing_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_fixing_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_fixing_expenses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_sales_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="car_purchase_sold_view">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_car_pur_sale_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="buy_cars_sold_view">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_buy_car_sale_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="people_cars_sold_view">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_people_car_sale_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'marketers_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_marketers">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_marketers">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_marketers">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_marketers">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="report_marketers">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'report'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'extra_income_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_extra_income">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_extra_income">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_extra_income">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_extra_income">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'extra_income_type_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_extra_income_type">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_extra_income_type">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_extra_income_type">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_extra_income_type">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'synchronization_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_synchronization">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sales_man_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_sales_man">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_sales_man">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_sales_man">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_sales_man">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sales_report_sales_man">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_sale_right'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_report_sales_man">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_report_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'approvals_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approval_receipts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approval_receipts'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approved_receipts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approved_receipts'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="make_receipts_approved">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'make_receipts_approved'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approval_activities">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approval_activities'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approved_activities">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approved_activities'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="make_activities_approved">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'make_activities_approved'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'transfer_ph_in_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_transfer_in_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_transfer_in_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_transfer_in_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_transfer_in_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_transfer_in_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'transfer_ph_out_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_transfer_out_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_transfer_out_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_transfer_out_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_transfer_out_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_transfer_out_ph">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sales_return_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_sales_return">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_sales_return">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_sales_return">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_sales_return">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_sales_return">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_services_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_services_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="marketers_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'marketers_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="batch_stock_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'batch_stock_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_return_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_return_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="near_expiry_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'near_expiry_report_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="expired_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'expired_report_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="shortage_report_rights">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'shortage_report_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="bundle_toop">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'bundle_toop_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="item_token">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'item_token_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="all_bonuses">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'all_bonuses_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'account_types_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <?php 
                                                foreach($root_accounts as $row){
                                                    $value = $row['uid'];
                                                ?>

                                                    <tr><?php $check_input_id = generate_uid(); ?>
                                                        <td style="width:50px;" class="no-borders">
                                                            <div class="checkbox checkbox-success checkbox-inline">
                                                                <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="<?= $value; ?>">
                                                                <label for="<?= $check_input_id; ?>"></label>
                                                            </div>
                                                        </td>
                                                        <td  class="no-borders"><?= ucfirst($row['name']); ?></td>
                                                    </tr>
                                                <?php } ?>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="all_accounts_statement">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'all_accounts_statement'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'debit_credit_note_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_debit_credit_note">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_debit_credit_note">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_debit_credit_note">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_debit_credit_note">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_debit_credit_note">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'orders_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_pending_orders">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_view_pending_order'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_processed_order">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_view_processed_order'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="orders_view_invoice">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_view_invoice'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="process_order">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_process_order'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_order">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_delete_order'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'capitals_categories_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_share_capital_categories_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_share_capital_categories_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_share_capital_categories_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_share_capital_categories_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <!--  -->



                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'capitals_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_share_capital_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_share_capital_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_share_capital_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_share_capital_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'metu_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_metu_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_metu_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_metu_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_metu_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="metu_report_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'metu_report_right'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'metu_sales_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_metu_sales_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_metu_sales_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_metu_sales_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_metu_sales_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'metu_purchases_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_metu_purchases_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_metu_purchases_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_metu_purchases_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_metu_purchases_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="email_alerts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'email_alerts'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="message_alerts">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'message_alerts'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sets_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_sets_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_sets_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_sets_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_sets_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'shareholder_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shareholder_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shareholder_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shareholder_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shareholder_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'shareholder_credit_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shareholder_credit_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shareholder_credit_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shareholder_credit_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shareholder_credit_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'turnover_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_turnover_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_turnover_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_turnover_right">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <!--  -->

                    </div>
                    <!-- rights html markups -->

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/users'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>