<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_user'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/users'); ?>"><?= print_lang($app_lang,'users'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_user'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="user-edit-form" action="<?php echo url('/users/update').'/'.$user['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="name" value="<?= $user['name']; ?>" placeholder="<?= print_lang($app_lang,'name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'email'); ?></label>
                                <input type="text" class="form-control" name="email" value="<?= $user['email']; ?>" placeholder="<?= print_lang($app_lang,'email'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'phone'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="phone" value="<?= $user['phone']; ?>" placeholder="<?= print_lang($app_lang,'phone'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group <?php if($user['role'] == 'SUPERADMIN'){ echo 'pointer-none'; } ?>">
                                <label><?= print_lang($app_lang,'role'); ?> <strong class="text-danger">*</strong></label>
                                <select class="chosen-select form-control" name="role">
                                    <option value="USER" <?php if($user['role'] == 'USER'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'user'); ?></option>
                                    <option value="ADMIN" <?php if($user['role'] == 'ADMIN' OR $user['role'] == 'SUPERADMIN'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'admin'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'username'); ?></label>
                                <input type="text" class="form-control" name="username" value="<?= $user['username']; ?>" placeholder="<?= print_lang($app_lang,'username'); ?>" autocomplete="autocomplete_off_hack_xfr4!k">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'password'); ?></label>
                                <input type="password" class="form-control" name="password" placeholder="<?= print_lang($app_lang,'password'); ?>" autocomplete="new-password">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group branch-select-area <?php if($user['role'] == 'SUPERADMIN' OR $user['role'] == 'ADMIN'){ echo 'pointer-none'; } ?>">
                                <label><?= print_lang($app_lang,'branch'); ?> <strong class="text-danger">*</strong></label>
                                <select class="chosen-select form-control" name="branch">
                                    <option selected="" disabled="">-- <?= print_lang($app_lang,'select_branch'); ?> --</option>
                                    <?php foreach($branches as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($user['branch'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['branch_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'address'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="address" value="<?= $user['address']; ?>" placeholder="<?= print_lang($app_lang,'address'); ?>">
                            </div>
                        </div>
                    </div>

                    <?php if(empty($user['rights'])){ $rights_array = array(); }else{ $rights_array = json_decode($user['rights']); } ?>

                    <!-- right html markups -->
                    <div id="rights-markups-area">

                        <div class="row extra-mar-botm">
                            <div class="col-md-6">
                                <label>User Rights</label>
                            </div>
                            <div class="col-md-6 text-right">
                                <div class="checkbox checkbox-success checkbox-inline">
                                    <input type="checkbox" name="rights[]" id="check-all-rights">
                                    <label for="check-all-rights"><?= print_lang($app_lang,'check_all_rights'); ?></label>
                                </div>
                            </div>
                        </div>

                        <div class="row rights-row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'approval_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_1" class="all-module-checker">
                                                            <label for="check_all_right_elem_1"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-342112441" value="sub_approval" <?php if(in_array('sub_approval', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sub_approval_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-34211244341" value="main_approval" <?php if(in_array('main_approval', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-2"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'main_approval_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_stock_in_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_item_stock_in_right" <?php if(in_array('view_item_stock_in_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_item_stock_in_right" <?php if(in_array('add_item_stock_in_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_item_stock_in_right" <?php if(in_array('edit_item_stock_in_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_item_stock_in_right" <?php if(in_array('delete_item_stock_in_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_stock_out_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_item_stock_out_right" <?php if(in_array('view_item_stock_out_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_item_stock_out_right" <?php if(in_array('add_item_stock_out_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_item_stock_out_right" <?php if(in_array('edit_item_stock_out_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_item_stock_out_right" <?php if(in_array('delete_item_stock_out_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_item_stock_balance_report" <?php if(in_array('view_item_stock_balance_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_item_stock_balance_report'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'journal_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_1" class="all-module-checker">
                                                            <label for="check_all_right_elem_1"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1" value="view_journal" <?php if(in_array('view_journal', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-2" value="add_journal" <?php if(in_array('add_journal', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-2"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-3" value="edit_journal" <?php if(in_array('edit_journal', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-3"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-4" value="delete_journal" <?php if(in_array('delete_journal', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-4"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sales_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_2" class="all-module-checker">
                                                            <label for="check_all_right_elem_2"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-5" value="view_sale" <?php if(in_array('view_sale', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-5"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-6" value="add_sale" <?php if(in_array('add_sale', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-6"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_print_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-7" value="edit_sale" <?php if(in_array('edit_sale', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-7"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-8" value="delete_sale" <?php if(in_array('delete_sale', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-8"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_3" class="all-module-checker">
                                                            <label for="check_all_right_elem_3"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-9" value="view_purchase" <?php if(in_array('view_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-9"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-10" value="add_purchase" <?php if(in_array('add_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-10"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_print_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11" value="edit_purchase" <?php if(in_array('edit_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-12" value="delete_purchase" <?php if(in_array('delete_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-12"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'production_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_4" class="all-module-checker">
                                                            <label for="check_all_right_elem_4"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-13" value="view_production" <?php if(in_array('view_production', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-13"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-14" value="add_production" <?php if(in_array('add_production', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-14"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_print_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-15" value="edit_production" <?php if(in_array('edit_production', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-15"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-16" value="delete_production" <?php if(in_array('delete_production', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-16"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'items_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_5" class="all-module-checker">
                                                            <label for="check_all_right_elem_5"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-17" value="view_item" <?php if(in_array('view_item', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-17"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-18" value="add_item" <?php if(in_array('add_item', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-18"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-19" value="edit_item" <?php if(in_array('edit_item', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-19"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-20" value="delete_item" <?php if(in_array('delete_item', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-20"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-21" value="view_item_image" <?php if(in_array('view_item_image', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-21"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'view_image_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'warehouse_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_6" class="all-module-checker">
                                                            <label for="check_all_right_elem_6"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-22" value="view_warehouse" <?php if(in_array('view_warehouse', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-22"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-23" value="add_warehouse" <?php if(in_array('add_warehouse', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-23"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-24" value="edit_warehouse" <?php if(in_array('edit_warehouse', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-24"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-25" value="delete_warehouse" <?php if(in_array('delete_warehouse', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-25"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-26" value="warehouse_details" <?php if(in_array('warehouse_details', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-26"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'warehouse_details_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'warehouse_transfer_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_7" class="all-module-checker">
                                                            <label for="check_all_right_elem_7"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-27" value="view_warehouse_transfer" <?php if(in_array('view_warehouse_transfer', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-27"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-28" value="add_warehouse_transfer" <?php if(in_array('add_warehouse_transfer', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-28"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-29" value="edit_warehouse_transfer" <?php if(in_array('edit_warehouse_transfer', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-29"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-30" value="delete_warehouse_transfer" <?php if(in_array('delete_warehouse_transfer', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-30"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'damage_stock_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_8" class="all-module-checker">
                                                            <label for="check_all_right_elem_8"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-31" value="view_damage_stock" <?php if(in_array('view_damage_stock', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-31"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-32" value="add_damage_stock" <?php if(in_array('add_damage_stock', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-32"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-33" value="edit_damage_stock" <?php if(in_array('edit_damage_stock', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-33"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-34" value="delete_damage_stock" <?php if(in_array('delete_damage_stock', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-34"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'expense_types_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_9" class="all-module-checker">
                                                            <label for="check_all_right_elem_9"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-35" value="view_expense_type" <?php if(in_array('view_expense_type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-35"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-36" value="add_expense_type" <?php if(in_array('add_expense_type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-36"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-37" value="edit_expense_type" <?php if(in_array('edit_expense_type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-37"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-38" value="delete_expense_type" <?php if(in_array('delete_expense_type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-38"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'expense_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_10" class="all-module-checker">
                                                            <label for="check_all_right_elem_10"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-39" value="view_expense" <?php if(in_array('view_expense', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-39"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-40" value="add_expense" <?php if(in_array('add_expense', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-40"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-41" value="edit_expense" <?php if(in_array('edit_expense', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-41"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-42" value="delete_expense" <?php if(in_array('delete_expense', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-42"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_11" class="all-module-checker">
                                                            <label for="check_all_right_elem_11"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-43" value="expense_report" <?php if(in_array('expense_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-43"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'expense_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-23423423" value="stock_general_ledger" <?php if(in_array('stock_general_ledger', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-23423423"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'stock_general_ledger'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-23423423443243" value="audit_report" <?php if(in_array('audit_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-23423423443243"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'audit_report'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-44" value="raw_warehouse_report" <?php if(in_array('raw_warehouse_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-44"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'raw_warehouse_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-45" value="sales_warehouse_report" <?php if(in_array('sales_warehouse_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-45"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_warehouse_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-46" value="items_ledger_report" <?php if(in_array('items_ledger_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-46"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'items_ledger_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_12" class="all-module-checker">
                                                            <label for="check_all_right_elem_12"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-47" value="damage_stock_report" <?php if(in_array('damage_stock_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-47"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'damage_stock_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-48" value="sales_report" <?php if(in_array('sales_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-48"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sales_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-49" value="sales_item_report" <?php if(in_array('sales_item_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-49"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sales_item_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-50" value="purchase_report" <?php if(in_array('purchase_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-50"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'purchase_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_13" class="all-module-checker">
                                                            <label for="check_all_right_elem_13"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-51" value="purchase_item_report" <?php if(in_array('purchase_item_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-51"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'purchase_item_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-52" value="production_report" <?php if(in_array('production_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-52"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'production_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-53" value="client_item_report" <?php if(in_array('client_item_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-53"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'client_item_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-54" value="purchase_expense_report" <?php if(in_array('purchase_expense_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-54"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'purchase_expenses_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-541" value="balance_summary_report" <?php if(in_array('balance_summary_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-541"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'balance_summary_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-542" value="inventory_report" <?php if(in_array('inventory_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-542"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'inventory_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-542767" value="sale_stock_report" <?php if(in_array('sale_stock_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-542767"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_stock_report_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-542767456" value="item_stock_report" <?php if(in_array('item_stock_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-542767456"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'items_stock_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_14" class="all-module-checker">
                                                            <label for="check_all_right_elem_14"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-55" value="sale_expense_report" <?php if(in_array('sale_expense_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-55"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_expenses_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-56" value="production_expense_report" <?php if(in_array('production_expense_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-56"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'production_expenses_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-57" value="warehouse_transfer_report" <?php if(in_array('warehouse_transfer_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-57"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'warehouse_transfer_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-58" value="sale_discount_report" <?php if(in_array('sale_discount_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-58"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_discount_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-58" value="sale_discount_report_2" <?php if(in_array('sale_discount_report_2', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-58"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'sale_discount_report_rights_2'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-59" value="purchase_discount_report" <?php if(in_array('purchase_discount_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-59"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'purchase_discount_report_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-594234" value="transfer_in_discount_1" <?php if(in_array('transfer_in_discount_1', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-594234"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'trans_in_dis_1_report_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-59234234" value="transfer_in_discount_2" <?php if(in_array('transfer_in_discount_2', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-59234234"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'trans_in_dis_2_report_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'financial_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_15" class="all-module-checker">
                                                            <label for="check_all_right_elem_15"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-63240" value="chart_of_accounts" <?php if(in_array('chart_of_accounts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-63240"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'financial_balance_chart_of_accounts'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-60" value="balance_sheet" <?php if(in_array('balance_sheet', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-60"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'financial_balance_sheet_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-61" value="trial_balance" <?php if(in_array('trial_balance', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-61"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_trial_balance_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-61" value="cash_flow" <?php if(in_array('cash_flow', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-61"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_cash_flow_rights'); ?></td>
                                                </tr>
                                                
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-62" value="income_statement" <?php if(in_array('income_statement', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-62"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_income_statement_rights'); ?></td>
                                                </tr>
                                                
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-63" value="profit_loss" <?php if(in_array('profit_loss', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-63"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_profit_loss_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-64" value="client_balance_summary" <?php if(in_array('balance_summary', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-64"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_balance_summary_rights'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-245235" value="marketers_balance_summary" <?php if(in_array('marketers_balance_summary', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-245235"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_marketers_balance_summary'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-342552" value="salesman_receovery" <?php if(in_array('salesman_receovery', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-342552"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_salesman_receovery'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-325525" value="income_expenses" <?php if(in_array('income_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-325525"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_income_expenses'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-325525" value="day_closing" <?php if(in_array('day_closing', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-325525"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'financial_day_closing'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'accounts_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_16" class="all-module-checker">
                                                            <label for="check_all_right_elem_16"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-65" value="view_account" <?php if(in_array('view_account', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-65"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-66" value="add_account" <?php if(in_array('add_account', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-66"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-67" value="edit_account" <?php if(in_array('edit_account', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-67"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-68" value="delete_account" <?php if(in_array('delete_account', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-68"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'invoice_counters_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_17" class="all-module-checker">
                                                            <label for="check_all_right_elem_17"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-69" value="view_invoice_counter" <?php if(in_array('view_invoice_counter', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-69"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-70" value="edit_invoice_counter" <?php if(in_array('edit_invoice_counter', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-70"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'currency_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_18" class="all-module-checker">
                                                            <label for="check_all_right_elem_18"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-71" value="view_currency" <?php if(in_array('view_currency', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-71"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-72" value="add_currency" <?php if(in_array('add_currency', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-72"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-73" value="edit_currency" <?php if(in_array('edit_currency', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-73"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-74" value="delete_currency" <?php if(in_array('delete_currency', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-74"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-75" value="view_currency_rates" <?php if(in_array('view_currency_rates', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-75"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'view_currency_rates'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-75" value="edit_currency_rates" <?php if(in_array('edit_currency_rates', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-75"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_currency_rates'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'units_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_19" class="all-module-checker">
                                                            <label for="check_all_right_elem_19"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-76" value="view_units" <?php if(in_array('view_units', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-76"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-77" value="add_units" <?php if(in_array('add_units', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-77"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-78" value="edit_units" <?php if(in_array('edit_units', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-78"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-79" value="delete_units" <?php if(in_array('delete_units', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-79"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'batch_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_20" class="all-module-checker">
                                                            <label for="check_all_right_elem_20"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-80" value="view_batch" <?php if(in_array('view_batch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-80"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-81" value="add_batch" <?php if(in_array('add_batch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-81"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-82" value="edit_batch" <?php if(in_array('edit_batch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-82"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-83" value="delete_batch" <?php if(in_array('delete_batch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-83"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'product_categories_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_21" class="all-module-checker">
                                                            <label for="check_all_right_elem_21"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-84" value="view_product_categories" <?php if(in_array('view_product_categories', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-84"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-85" value="add_product_categories" <?php if(in_array('add_product_categories', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-85"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-86" value="edit_product_categories" <?php if(in_array('edit_product_categories', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-86"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-87" value="delete_product_categories" <?php if(in_array('delete_product_categories', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-87"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'branches_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_22" class="all-module-checker">
                                                            <label for="check_all_right_elem_22"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-88" value="view_branch" <?php if(in_array('view_branch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-88"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-89" value="add_branch" <?php if(in_array('add_branch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-89"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-90" value="edit_branch" <?php if(in_array('edit_branch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-90"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-91" value="delete_branch" <?php if(in_array('delete_branch', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-91"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-911" value="item_settings" <?php if(in_array('item_settings', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-911"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'item_settings'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'language_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_23" class="all-module-checker">
                                                            <label for="check_all_right_elem_23"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-92" value="view_language" <?php if(in_array('view_language', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-92"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-93" value="add_language" <?php if(in_array('add_language', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-93"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-94" value="edit_language" <?php if(in_array('edit_language', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-94"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-95" value="delete_language" <?php if(in_array('delete_language', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-95"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-95" value="edit_language_phrase" <?php if(in_array('edit_language_phrase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-96"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_language_phrase'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'users_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_24" class="all-module-checker">
                                                            <label for="check_all_right_elem_24"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-97" value="view_user" <?php if(in_array('view_user', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-97"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-98" value="add_user" <?php if(in_array('add_user', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-98"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-99" value="edit_user" <?php if(in_array('edit_user', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-99"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-100" value="delete_user" <?php if(in_array('delete_user', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-100"></label>
                                                        </div>
                                                    </td>
                                                    <td><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'all_accounts_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_25" class="all-module-checker">
                                                            <label for="check_all_right_elem_25"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-101" value="all_accounts_report" <?php if(in_array('all_accounts_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-101"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'all_accounts_reports_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'backup_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_26" class="all-module-checker">
                                                            <label for="check_all_right_elem_26"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-102" value="backup_right" <?php if(in_array('backup_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-102"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'backup_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'calander_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_27" class="all-module-checker">
                                                            <label for="check_all_right_elem_27"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-103" value="calander_right" <?php if(in_array('calander_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-103"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'calander_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'assets_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_26" class="all-module-checker">
                                                            <label for="check_all_right_elem_26"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-104" value="view_assets" <?php if(in_array('view_assets', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-104"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-105" value="add_assets" <?php if(in_array('add_assets', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-105"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-106" value="edit_assets" <?php if(in_array('edit_assets', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-106"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-107" value="delete_assets" <?php if(in_array('delete_assets', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-107"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_employees_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_27" class="all-module-checker">
                                                            <label for="check_all_right_elem_27"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-108" value="view_employee" <?php if(in_array('view_employee', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-108"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-109" value="add_employee" <?php if(in_array('add_employee', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-109"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-110" value="edit_employee" <?php if(in_array('edit_employee', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-110"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-111" value="delete_employee" <?php if(in_array('delete_employee', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-111"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_division_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_27" class="all-module-checker">
                                                            <label for="check_all_right_elem_27"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-108" value="view_division" <?php if(in_array('view_division', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-108"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-109" value="add_division" <?php if(in_array('add_division', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-109"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-110" value="edit_division" <?php if(in_array('edit_division', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-110"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-111" value="delete_division" <?php if(in_array('delete_division', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-111"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_increment_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_28" class="all-module-checker">
                                                            <label for="check_all_right_elem_28"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-112" value="view_increment" <?php if(in_array('view_increment', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-112"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-113" value="add_increment" <?php if(in_array('add_increment', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-113"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-114" value="delete_increment" <?php if(in_array('delete_increment', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-114"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_advance_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_29" class="all-module-checker">
                                                            <label for="check_all_right_elem_29"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-115" value="view_advance" <?php if(in_array('view_advance', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-115"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-116" value="add_advance" <?php if(in_array('add_advance', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-116"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-117" value="delete_advance" <?php if(in_array('delete_advance', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-117"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_payslips_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_30" class="all-module-checker">
                                                            <label for="check_all_right_elem_30"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-118" value="view_payslips" <?php if(in_array('view_payslips', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-118"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-119" value="add_payslips" <?php if(in_array('add_payslips', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-119"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-120" value="edit_payslips" <?php if(in_array('edit_payslips', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-120"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-121" value="delete_payslips" <?php if(in_array('delete_payslips', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-121"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-125" value="confirm_payslips" <?php if(in_array('confirm_payslips', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-125"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'confirm_payslips'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-122" value="paid_salaries" <?php if(in_array('paid_salaries', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-122"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_paid_salaries'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'hrm_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_31" class="all-module-checker">
                                                            <label for="check_all_right_elem_31"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-123" value="hrm_reports_yearly" <?php if(in_array('hrm_reports_yearly', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-123"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_reports_yearly'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-124" value="hrm_reports_monthly" <?php if(in_array('hrm_reports_monthly', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-124"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_reports_monthly'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-12401" value="hrm_reports_attendence" <?php if(in_array('hrm_reports_attendence', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-12401"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_reports_attendence'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-12402" value="hrm_attendence_rights" <?php if(in_array('hrm_attendence_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-12402"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'hrm_attendence_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- rights html markups -->

                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'transit_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_2999" class="all-module-checker">
                                                            <label for="check_all_right_elem_2999"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1155" value="view_transit" <?php if(in_array('view_transit', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1155"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1166" value="add_transit" <?php if(in_array('add_transit', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1166"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11166" value="edit_transit" <?php if(in_array('edit_transit', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11166"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177" value="delete_transit" <?php if(in_array('delete_transit', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1177"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'quotation_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_29999" class="all-module-checker">
                                                            <label for="check_all_right_elem_29999"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11555" value="view_quotation" <?php if(in_array('view_quotation', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11555"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-115555" value="view_converted_quotation" <?php if(in_array('view_converted_quotation', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-115555"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'converted_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11666" value="add_quotation" <?php if(in_array('add_quotation', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11666"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-111666" value="edit_quotation" <?php if(in_array('edit_quotation', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-111666"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777" value="delete_quotation" <?php if(in_array('delete_quotation', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11777"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'lot_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;">
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="check_all_right_elem_299999" class="all-module-checker">
                                                            <label for="check_all_right_elem_299999"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-115455" value="view_lot_purchase" <?php if(in_array('view_lot_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-115455"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1155555" value="add_lot_purchase" <?php if(in_array('add_lot_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1155555"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1166667" value="edit_lot_purchase" <?php if(in_array('edit_lot_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1166667"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11166668" value="delete_lot_purchase" <?php if(in_array('delete_lot_purchase', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11166668"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_lot_purchase_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11166668124" value="view_avail_lot" <?php if(in_array('view_avail_lot', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11166668124"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_avail_lot_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177787" value="view_lot_sold" <?php if(in_array('view_lot_sold', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1177787"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_lot_sold_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177798" value="add_lot_sold" <?php if(in_array('add_lot_sold', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1177798"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_lot_sold_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-1177768" value="delete_lot_sold" <?php if(in_array('delete_lot_sold', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-1177768"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_lot_sold_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777298" value="view_lot_moved" <?php if(in_array('view_lot_moved', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11777298"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_lot_moved_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777198" value="add_lot_moved" <?php if(in_array('add_lot_moved', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11777198"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_lot_moved_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777297" value="delete_lot_moved" <?php if(in_array('delete_lot_moved', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11777297"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_lot_moved_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-117772925" value="view_lot_difference_report" <?php if(in_array('view_lot_difference_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-117772925"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_difference_report_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777292511" value="view_iran_to_afghanistan_difference_report" <?php if(in_array('view_iran_to_afghanistan_difference_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11777292511"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_iran_to_afghanistan_difference_report_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-11777292522" value="view_iran_to_border_difference_report" <?php if(in_array('view_iran_to_border_difference_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-11777292522"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_iran_to_border_difference_report_right'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="user-right-117772925222345" value="view_fuel_lose_report" <?php if(in_array('view_fuel_lose_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="user-right-117772925222345"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'lot_fuel_lose_report_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>











                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'dashboard_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_sales" <?php if(in_array('today_overview_sales', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_sales'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_sales_return" <?php if(in_array('today_overview_sales_return', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_sales_return'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_purchases" <?php if(in_array('today_overview_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_purchases'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_expenses" <?php if(in_array('today_overview_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_expenses'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_supplier_paid" <?php if(in_array('today_overview_supplier_paid', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_supplier_paid'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_client_received" <?php if(in_array('today_overview_client_received', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_client_received'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_cash_in" <?php if(in_array('today_overview_cash_in', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_cash_in'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_cash_out" <?php if(in_array('today_overview_cash_out', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_cash_out'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_extra_income" <?php if(in_array('today_overview_extra_income', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_extra_income'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_bank_in" <?php if(in_array('today_overview_bank_in', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_bank_in'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="today_overview_bank_out" <?php if(in_array('today_overview_bank_out', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'today_overview_bank_out'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'dashboard_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_sales" <?php if(in_array('business_overview_sales', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_sales'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_purchases" <?php if(in_array('business_overview_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_purchases'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_current_stock" <?php if(in_array('business_overview_current_stock', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_current_stock'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_receivable" <?php if(in_array('business_overview_receivable', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_receivable'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_payable" <?php if(in_array('business_overview_payable', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_payable'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_cash" <?php if(in_array('business_overview_cash', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_cash'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_bank" <?php if(in_array('business_overview_bank', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_bank'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_expenses" <?php if(in_array('business_overview_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_expenses'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_damage_stock" <?php if(in_array('business_overview_damage_stock', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_damage_stock'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_fixed_assets" <?php if(in_array('business_overview_fixed_assets', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_fixed_assets'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="business_overview_equity" <?php if(in_array('business_overview_equity', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'business_overview_equity'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'dashboard_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dashboard_cash" <?php if(in_array('dashboard_cash', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dashboard_cash_marquee'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="system_profit" <?php if(in_array('system_profit', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'system_profit'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_construction_stats" <?php if(in_array('dash_construction_stats', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_construction_stats'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_business_performance_stats" <?php if(in_array('dash_business_performance_stats', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_business_performance_stats'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_metu_performance_stats" <?php if(in_array('dash_metu_performance_stats', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_metu_performance_stats'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_expenses_graph" <?php if(in_array('dash_expenses_graph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_expenses_graph'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_profit_and_loss_graph" <?php if(in_array('dash_profit_and_loss_graph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_profit_and_loss_graph'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_bank_accounts_notifications" <?php if(in_array('dash_bank_accounts_notifications', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_bank_accounts_notifications'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="dash_activity_alerts" <?php if(in_array('dash_activity_alerts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'dash_activity_alerts'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_items_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_items" <?php if(in_array('view_project_items', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_items" <?php if(in_array('add_project_items', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_items" <?php if(in_array('edit_project_items', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_items" <?php if(in_array('delete_project_items', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_warehouses_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_warehouses" <?php if(in_array('view_project_warehouses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_warehouses" <?php if(in_array('add_project_warehouses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_warehouses" <?php if(in_array('edit_project_warehouses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_warehouses" <?php if(in_array('delete_project_warehouses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="details_project_warehouses" <?php if(in_array('details_project_warehouses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'details'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_purchases_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_purchases" <?php if(in_array('view_project_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_purchases" <?php if(in_array('add_project_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_purchases" <?php if(in_array('edit_project_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_purchases" <?php if(in_array('delete_project_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_project_purchases" <?php if(in_array('invoice_project_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_contracts_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_contracts" <?php if(in_array('view_project_contracts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_contracts" <?php if(in_array('add_project_contracts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_contracts" <?php if(in_array('edit_project_contracts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_contracts" <?php if(in_array('delete_project_contracts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_assigning_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_assigning" <?php if(in_array('view_project_assigning', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_assigning" <?php if(in_array('add_project_assigning', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_assigning" <?php if(in_array('edit_project_assigning', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_assigning" <?php if(in_array('delete_project_assigning', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_projects_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects" <?php if(in_array('view_project_projects', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_projects" <?php if(in_array('add_project_projects', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_projects" <?php if(in_array('edit_project_projects', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_projects" <?php if(in_array('delete_project_projects', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_inprocess_projects_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_inprocess_projects" <?php if(in_array('view_project_inprocess_projects', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_inprocess_projects_process_details" <?php if(in_array('project_inprocess_projects_process_details', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'process_details'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_inprocess_projects_complete" <?php if(in_array('project_inprocess_projects_complete', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'complete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_completed_projects_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_completed_projects" <?php if(in_array('view_project_completed_projects', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_completed_projects_process_details" <?php if(in_array('project_completed_projects_process_details', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'process_details'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="project_completed_projects_incomplete" <?php if(in_array('project_completed_projects_incomplete', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'incomplete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_projects_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects_reports" <?php if(in_array('view_project_projects_reports', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_projects_reports" <?php if(in_array('add_project_projects_reports', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_projects_reports" <?php if(in_array('edit_project_projects_reports', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_projects_reports" <?php if(in_array('delete_project_projects_reports', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects_reports_details" <?php if(in_array('delete_project_projects_reports', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'details'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_projects_payments_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_projects_payments" <?php if(in_array('view_project_projects_payments', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_projects_payments" <?php if(in_array('add_project_projects_payments', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_projects_payments" <?php if(in_array('edit_project_projects_payments', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_projects_payments" <?php if(in_array('delete_project_projects_payments', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_payment_deductions_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_payment_deductions" <?php if(in_array('view_project_payment_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_payment_deductions" <?php if(in_array('add_project_payment_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_payment_deductions" <?php if(in_array('edit_project_payment_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_payment_deductions" <?php if(in_array('delete_project_payment_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_expenses_deductions_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_expenses_deductions" <?php if(in_array('view_project_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_expenses_deductions" <?php if(in_array('add_project_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_expenses_deductions" <?php if(in_array('edit_project_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_expenses_deductions" <?php if(in_array('delete_project_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="approve_project_expenses_deductions" <?php if(in_array('delete_project_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'approve'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_approved_expenses_deductions_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_approved_expenses_deductions" <?php if(in_array('view_project_approved_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_project_approved_expenses_deductions" <?php if(in_array('add_project_approved_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_project_approved_expenses_deductions" <?php if(in_array('edit_project_approved_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_project_approved_expenses_deductions" <?php if(in_array('delete_project_approved_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="disapprove_project_approved_expenses_deductions" <?php if(in_array('delete_project_approved_expenses_deductions', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'disapprove'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'project_assign_report_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_project_assign_report" <?php if(in_array('view_project_assign_report', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_module_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_services_right" <?php if(in_array('view_services_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_services_right" <?php if(in_array('add_services_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_services_right" <?php if(in_array('edit_services_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_services_right" <?php if(in_array('delete_services_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_sales_module_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_services_sales_rights" <?php if(in_array('view_services_sales_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_services_sales_rights" <?php if(in_array('add_services_sales_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_services_sales_rights" <?php if(in_array('edit_services_sales_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_services_sales_rights" <?php if(in_array('delete_services_sales_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_services_sales_rights" <?php if(in_array('invoice_services_sales_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_quotation_module_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_services_quotation_rights" <?php if(in_array('view_services_quotation_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_services_quotation_rights" <?php if(in_array('add_services_quotation_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_services_quotation_rights" <?php if(in_array('edit_services_quotation_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_services_quotation_rights" <?php if(in_array('delete_services_quotation_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_services_quotation_rights" <?php if(in_array('invoice_services_quotation_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="converted_services_quotation_rights" <?php if(in_array('converted_services_quotation_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'converted_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'services_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="services_sales_reports_rights" <?php if(in_array('services_sales_reports_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'services_sales_reports_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="services_items_reports_rights" <?php if(in_array('services_items_reports_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'services_items_reports_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!--  -->




                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_module_car_p_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="showroom_list_view" <?php if(in_array('showroom_list_view', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_module_car_p_list_view'); ?></td>
                                                </tr>

                                                <tr>
                                                    <td colspan="2"><strong><?= print_lang($app_lang,'showroom_car_purchase_rights'); ?></strong></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_car_purchases" <?php if(in_array('view_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_car_purchases" <?php if(in_array('add_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_car_purchases" <?php if(in_array('edit_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_car_purchases" <?php if(in_array('delete_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_car_purchases" <?php if(in_array('invoice_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_add_shor_car_purchases" <?php if(in_array('sale_add_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_add'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_edit_shor_car_purchases" <?php if(in_array('sale_edit_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_edit'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_delete_shor_car_purchases" <?php if(in_array('sale_delete_shor_car_purchases', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_delete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_buy_car_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_buy_cars" <?php if(in_array('view_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_buy_cars" <?php if(in_array('add_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_buy_cars" <?php if(in_array('edit_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_buy_cars" <?php if(in_array('delete_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_buy_cars" <?php if(in_array('invoice_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_shor_buy_cars" <?php if(in_array('sale_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_add'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_edit_shor_buy_cars" <?php if(in_array('sale_edit_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_edit'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_delete_shor_buy_cars" <?php if(in_array('sale_delete_shor_buy_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_delete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_people_show_buy_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_people_cars" <?php if(in_array('view_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_people_cars" <?php if(in_array('add_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_people_cars" <?php if(in_array('edit_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_people_cars" <?php if(in_array('delete_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_people_cars" <?php if(in_array('invoice_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_add_shor_people_cars" <?php if(in_array('sale_add_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_add'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_edit_shor_people_cars" <?php if(in_array('sale_edit_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_edit'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_delete_shor_people_cars" <?php if(in_array('sale_delete_shor_people_cars', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_delete'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->



                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_load_delivery_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_load_delivery" <?php if(in_array('view_shor_load_delivery', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_load_delivery" <?php if(in_array('add_shor_load_delivery', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_load_delivery" <?php if(in_array('edit_shor_load_delivery', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_load_delivery" <?php if(in_array('delete_shor_load_delivery', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_load_delivery" <?php if(in_array('invoice_shor_load_delivery', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_custom_exp_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_custom_expenses" <?php if(in_array('view_shor_custom_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_custom_expenses" <?php if(in_array('add_shor_custom_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_custom_expenses" <?php if(in_array('edit_shor_custom_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_custom_expenses" <?php if(in_array('delete_shor_custom_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_custom_expenses" <?php if(in_array('invoice_shor_custom_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_custom_char_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_custom_charges" <?php if(in_array('view_shor_custom_charges', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_custom_charges" <?php if(in_array('add_shor_custom_charges', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_custom_charges" <?php if(in_array('edit_shor_custom_charges', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_custom_charges" <?php if(in_array('delete_shor_custom_charges', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_custom_charges" <?php if(in_array('invoice_shor_custom_charges', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_fix_expense_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shor_fixing_expenses" <?php if(in_array('view_shor_fixing_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shor_fixing_expenses" <?php if(in_array('add_shor_fixing_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shor_fixing_expenses" <?php if(in_array('edit_shor_fixing_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shor_fixing_expenses" <?php if(in_array('delete_shor_fixing_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_shor_fixing_expenses" <?php if(in_array('invoice_shor_fixing_expenses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'showroom_sales_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="car_purchase_sold_view" <?php if(in_array('car_purchase_sold_view', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_car_pur_sale_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="buy_cars_sold_view" <?php if(in_array('buy_cars_sold_view', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_buy_car_sale_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="people_cars_sold_view" <?php if(in_array('people_cars_sold_view', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'showroom_people_car_sale_rights'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'marketers_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_marketers" <?php if(in_array('view_marketers', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_marketers" <?php if(in_array('add_marketers', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_marketers" <?php if(in_array('edit_marketers', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_marketers" <?php if(in_array('delete_marketers', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="report_marketers" <?php if(in_array('report_marketers', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'report'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->

                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'extra_income_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_extra_income" <?php if(in_array('view_extra_income', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_extra_income" <?php if(in_array('add_extra_income', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_extra_income" <?php if(in_array('edit_extra_income', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_extra_income" <?php if(in_array('delete_extra_income', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'extra_income_type_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_extra_income-type" <?php if(in_array('view_extra_income-type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_extra_income-type" <?php if(in_array('add_extra_income-type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_extra_income-type" <?php if(in_array('edit_extra_income-type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_extra_income-type" <?php if(in_array('delete_extra_income-type', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'synchronization_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_synchronization" <?php if(in_array('view_synchronization', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sales_man_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_sales_man" <?php if(in_array('view_sales_man', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_sales_man" <?php if(in_array('add_sales_man', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_sales_man" <?php if(in_array('edit_sales_man', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_sales_man" <?php if(in_array('delete_sales_man', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sales_report_sales_man" <?php if(in_array('sales_report_sales_man', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_sale_right'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_report_sales_man" <?php if(in_array('view_report_sales_man', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_report_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->



                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'approvals_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approval_receipts" <?php if(in_array('view_approval_receipts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approval_receipts'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approved_receipts" <?php if(in_array('view_approved_receipts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approved_receipts'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="make_receipts_approved" <?php if(in_array('make_receipts_approved', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'make_receipts_approved'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approval_activities" <?php if(in_array('view_approval_activities', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approval_activities'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_approved_activities" <?php if(in_array('view_approved_activities', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_approved_activities'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="make_activities_approved" <?php if(in_array('make_activities_approved', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'make_activities_approved'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'transfer_ph_in_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_transfer_in_ph" <?php if(in_array('view_transfer_in_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_transfer_in_ph" <?php if(in_array('add_transfer_in_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_transfer_in_ph" <?php if(in_array('edit_transfer_in_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_transfer_in_ph" <?php if(in_array('delete_transfer_in_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_transfer_in_ph" <?php if(in_array('invoice_transfer_in_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'transfer_ph_out_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_transfer_out_ph" <?php if(in_array('view_transfer_out_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_transfer_out_ph" <?php if(in_array('add_transfer_out_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_transfer_out_ph" <?php if(in_array('edit_transfer_out_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_transfer_out_ph" <?php if(in_array('delete_transfer_out_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_transfer_out_ph" <?php if(in_array('invoice_transfer_out_ph', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sales_return_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_sales_return" <?php if(in_array('view_sales_return', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_sales_return" <?php if(in_array('add_sales_return', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_sales_return" <?php if(in_array('edit_sales_return', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_sales_return" <?php if(in_array('delete_sales_return', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_sales_return" <?php if(in_array('invoice_sales_return', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_services_report_rights" <?php if(in_array('sale_services_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_services_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="marketers_report_rights" <?php if(in_array('marketers_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'marketers_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="batch_stock_report_rights" <?php if(in_array('batch_stock_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'batch_stock_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="sale_return_report_rights" <?php if(in_array('sale_return_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'sale_return_report_rights'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="near_expiry_report_rights" <?php if(in_array('near_expiry_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'near_expiry_report_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="expired_report_rights" <?php if(in_array('expired_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'expired_report_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="shortage_report_rights" <?php if(in_array('shortage_report_rights', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'shortage_report_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="bundle_toop" <?php if(in_array('bundle_toop', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'bundle_toop_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="item_token" <?php if(in_array('item_token', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'item_token_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="all_bonuses" <?php if(in_array('all_bonuses', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'all_bonuses_rights'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'account_types_reports_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <?php 
                                                foreach($root_accounts as $row){
                                                    $value = $row['uid'];
                                                ?>

                                                    <tr><?php $check_input_id = generate_uid(); ?>
                                                        <td style="width:50px;" class="no-borders">
                                                            <div class="checkbox checkbox-success checkbox-inline">
                                                                <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="<?= $value; ?>" <?php if(in_array($value, $rights_array)){ echo 'checked="checked"'; } ?>>
                                                                <label for="<?= $check_input_id; ?>"></label>
                                                            </div>
                                                        </td>
                                                        <td  class="no-borders"><?= ucfirst($row['name']); ?></td>
                                                    </tr>
                                                <?php } ?>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="all_accounts_statement" <?php if(in_array('all_accounts_statement', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'all_accounts_statement'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'debit_credit_note_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_debit_credit_note" <?php if(in_array('view_debit_credit_note', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_debit_credit_note" <?php if(in_array('add_debit_credit_note', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_debit_credit_note" <?php if(in_array('edit_debit_credit_note', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_debit_credit_note" <?php if(in_array('delete_debit_credit_note', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="invoice_debit_credit_note" <?php if(in_array('invoice_debit_credit_note', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'invoice'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'orders_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_pending_orders" <?php if(in_array('view_pending_orders', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_view_pending_order'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_processed_order" <?php if(in_array('view_processed_order', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_view_processed_order'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="orders_view_invoice" <?php if(in_array('orders_view_invoice', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_view_invoice'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="process_order" <?php if(in_array('process_order', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_process_order'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_order" <?php if(in_array('delete_order', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'orders_delete_order'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'capitals_categories_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_share_capital_categories_right" <?php if(in_array('view_share_capital_categories_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_share_capital_categories_right" <?php if(in_array('add_share_capital_categories_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_share_capital_categories_right" <?php if(in_array('edit_share_capital_categories_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_share_capital_categories_right" <?php if(in_array('delete_share_capital_categories_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  -->



                        <!--  -->
                        <div class="row rights-row">


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'capitals_right'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_share_capital_right" <?php if(in_array('view_share_capital_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_share_capital_right" <?php if(in_array('add_share_capital_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_share_capital_right" <?php if(in_array('edit_share_capital_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_share_capital_right" <?php if(in_array('delete_share_capital_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'metu_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_metu_right" <?php if(in_array('view_metu_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_metu_right" <?php if(in_array('add_metu_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_metu_right" <?php if(in_array('edit_metu_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_metu_right" <?php if(in_array('delete_metu_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="metu_report_right" <?php if(in_array('metu_report_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'metu_report_right'); ?></td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'metu_sales_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_metu_sales_right" <?php if(in_array('view_metu_sales_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_metu_sales_right" <?php if(in_array('add_metu_sales_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_metu_sales_right" <?php if(in_array('edit_metu_sales_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_metu_sales_right" <?php if(in_array('delete_metu_sales_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <!--  -->


                        <!--  -->
                        <div class="row rights-row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'metu_purchases_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_metu_purchases_right" <?php if(in_array('view_metu_purchases_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_metu_purchases_right" <?php if(in_array('add_metu_purchases_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_metu_purchases_right" <?php if(in_array('edit_metu_purchases_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_metu_purchases_right" <?php if(in_array('delete_metu_purchases_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'general_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="email_alerts" <?php if(in_array('email_alerts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'email_alerts'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="message_alerts" <?php if(in_array('message_alerts', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'message_alerts'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'sets_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_sets_right" <?php if(in_array('view_sets_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_sets_right" <?php if(in_array('add_sets_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_sets_right" <?php if(in_array('edit_sets_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_sets_right" <?php if(in_array('delete_sets_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'shareholder_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shareholder_right" <?php if(in_array('view_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shareholder_right" <?php if(in_array('add_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shareholder_right" <?php if(in_array('edit_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shareholder_right" <?php if(in_array('delete_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'shareholder_credit_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_shareholder_credit_right" <?php if(in_array('view_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_shareholder_credit_right" <?php if(in_array('add_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="edit_shareholder_credit_right" <?php if(in_array('edit_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'edit_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_shareholder_credit_right" <?php if(in_array('delete_shareholder_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'turnover_rights'); ?></label>
                                    <div class="ibox">
                                        <div class="ibox-content">
                                            <table class="table table-stripped small">
                                                <tbody>
                                                <tr style="border-bottom: 1px solid lightgray;"><?php $check_input_id = generate_uid(); ?>
                                                    <td class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" id="<?= $check_input_id; ?>" class="all-module-checker">
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td class="no-borders"><?= print_lang($app_lang,'check_all_rights'); ?></td>
                                                </tr>

                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="view_turnover_right" <?php if(in_array('view_turnover_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'view_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="add_turnover_right" <?php if(in_array('add_turnover_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'add_right'); ?></td>
                                                </tr>
                                                <tr><?php $check_input_id = generate_uid(); ?>
                                                    <td style="width:50px;" class="no-borders">
                                                        <div class="checkbox checkbox-success checkbox-inline">
                                                            <input type="checkbox" name="rights[]" id="<?= $check_input_id; ?>" value="delete_turnover_right" <?php if(in_array('delete_turnover_right', $rights_array)){ echo 'checked="checked"'; } ?>>
                                                            <label for="<?= $check_input_id; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td  class="no-borders"><?= print_lang($app_lang,'delete_right'); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <!--  -->







                    </div>
                    <!-- rights html markups -->

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/users'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>