<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'users'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'users'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_user') === TRUE){ ?>
                <a href="<?php echo url('/users/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_user'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'users_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'email'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'phone'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'address'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <?php
                                        if($row['is_project'] == 'yes'){ continue; }
                                        $action_buttons = true;
                                        if($row['role'] == 'SUPERADMIN')
                                        {
                                            if($row['uid'] != Session::get('user_id')){ $action_buttons = false; }
                                        }
                                    ?>
                                    <tr class="text-center">
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo $row['name']; ?></td>
                                        <td><?php echo $row['email']; ?></td>
                                        <td><?php echo $row['phone']; ?></td>
                                        <td><?php echo $row['address']; ?></td>
                                        <td>
                                            <?php if($action_buttons === true){ ?>
                                                <?php if(check_user_access('edit_user') === TRUE){ ?>
                                                    <a href="<?= url('/users/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i>&nbsp; <?= print_lang($app_lang,'edit'); ?></a>
                                                <?php } ?>
                                                <?php if(($row['role'] == 'USER') AND $row['uid'] != Session::get('user_id')){ ?>
                                                    <?php if(check_user_access('delete_user') === TRUE){ ?>
                                                        <a href="<?= url('/users/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                                    <?php } ?>
                                                <?php } ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>