<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// default route
Route::get('/', 'Authentication@index');

Route::get('/recover/items', 'Recovery@items');
Route::get('/recover/ledgers', 'Recovery@ledgers');
Route::get('/recover/items-relation', 'Recovery@items_b_to_b_relation');

Route::get('/db-backup', 'Authentication@database_backup');


// session control routes
Route::get('/login', 'Authentication@index');
Route::post('/do_login', 'Authentication@login');
Route::get('/logout', 'Authentication@logout');

// dashboard route
Route::get('/dashboard', 'Admin@dashboard');
Route::get('/dashboard-old', 'Admin@dashboard_old');
Route::get('/update-database', 'Admin@update_database');

Route::get('/dashboard-v2', 'Admin@dashboard_v2');

Route::post('/notification/seen', 'Admin@save_seen_notification');

Route::get('/select-branch', 'Branch_setup@select_branch');
Route::get('/activate-branch/{id}', 'Branch_setup@activate_branch');
Route::get('/branches-setup/add', 'Branch_setup@add');
Route::post('/branches-setup/save', 'Branch_setup@save');


// branches routes
Route::get('/branches', 'Branches@view');
Route::get('/branches/add', 'Branches@add');
Route::post('/branches/save', 'Branches@save');
Route::get('/branches/edit/{id}', 'Branches@edit');
Route::post('/branches/update/{id}', 'Branches@update');
Route::get('/branches/delete/{id}', 'Branches@delete');

// accounts routes
Route::get('/accounts', 'Accounts@view');
Route::get('/accounts/add', 'Accounts@add');
Route::post('/accounts/save', 'Accounts@save');
Route::get('/accounts/edit/{id}', 'Accounts@edit');
Route::post('/accounts/update/{id}', 'Accounts@update');
Route::get('/accounts/delete/{id}', 'Accounts@delete');

// currency routes
Route::get('/currency', 'Currency@view');
Route::get('/currency/add', 'Currency@add');
Route::post('/currency/save', 'Currency@save');
Route::get('/currency/edit/{id}', 'Currency@edit');
Route::post('/currency/update/{id}', 'Currency@update');
Route::get('/currency/delete/{id}', 'Currency@delete');

Route::get('/currency-rates', 'Currency@currency_rates');
Route::post('/currency-rates/update', 'Currency@update_currency_rates');
Route::get('/invoices-counters', 'Currency@invoices_counters');
Route::post('/invoices-counters/update', 'Currency@update_invoices_counters');

// units routes
Route::get('/units', 'Units@view');
Route::get('/units/add', 'Units@add');
Route::post('/units/save', 'Units@save');
Route::get('/units/edit/{id}', 'Units@edit');
Route::post('/units/update/{id}', 'Units@update');
Route::get('/units/delete/{id}', 'Units@delete');

Route::get('/tokens', 'Tokens@view');
Route::get('/tokens/add', 'Tokens@add');
Route::post('/tokens/save', 'Tokens@save');
Route::get('/tokens/edit/{id}', 'Tokens@edit');
Route::post('/tokens/update/{id}', 'Tokens@update');
Route::get('/tokens/delete/{id}', 'Tokens@delete');
Route::post('/tokens/get-client-sold-data', 'Tokens@get_client_sold_data');

// batch routes
Route::get('/batch', 'Batch@view');
Route::get('/batch/add', 'Batch@add');
Route::post('/batch/save', 'Batch@save');
Route::get('/batch/edit/{id}', 'Batch@edit');
Route::post('/batch/update/{id}', 'Batch@update');
Route::get('/batch/delete/{id}', 'Batch@delete');

// assets routes

Route::get('/assets-categories', 'Vcategories@view');
Route::get('/assets-categories/add', 'Vcategories@add');
Route::post('/assets-categories/save', 'Vcategories@save');
Route::get('/assets-categories/edit/{id}', 'Vcategories@edit');
Route::post('/assets-categories/update/{id}', 'Vcategories@update');
Route::get('/assets-categories/delete/{id}', 'Vcategories@delete');

Route::get('/virtues', 'Assets@view');
Route::get('/virtues/add', 'Assets@add');
Route::post('/virtues/save', 'Assets@save');
Route::get('/virtues/edit/{id}', 'Assets@edit');
Route::post('/virtues/update/{id}', 'Assets@update');
Route::get('/virtues/delete/{id}', 'Assets@delete');

// employees routes
Route::get('/employees', 'Employees@view');
Route::get('/employees/add', 'Employees@add');
Route::post('/employees/save', 'Employees@save');
Route::get('/employees/edit/{id}', 'Employees@edit');
Route::post('/employees/update/{id}', 'Employees@update');
Route::get('/employees/delete/{id}', 'Employees@delete');
Route::get('/employees/delete-document/{id}', 'Employees@delete_document');

// employees increment routes
Route::get('/increments', 'Increments@view');
Route::get('/increments/add', 'Increments@add');
Route::post('/increments/save', 'Increments@save');
Route::get('/increments/edit/{id}', 'Increments@edit');
Route::post('/increments/update/{id}', 'Increments@update');
Route::get('/increments/delete/{id}', 'Increments@delete');

// employees advances routes
Route::get('/advances', 'Advances@view');
Route::get('/advances/add', 'Advances@add');
Route::post('/advances/save', 'Advances@save');
Route::get('/advances/edit/{id}', 'Advances@edit');
Route::post('/advances/update/{id}', 'Advances@update');
Route::get('/advances/delete/{id}', 'Advances@delete');

// employees pay-slips routes
Route::get('/payslips', 'Payslips@view');
Route::get('/payslips/add', 'Payslips@add');
Route::post('/payslips/save', 'Payslips@save');
Route::get('/payslips/edit/{id}', 'Payslips@edit');
Route::post('/payslips/update/{id}', 'Payslips@update');
Route::get('/payslips/delete/{id}', 'Payslips@delete');
Route::get('/payslips/confirm/{id}', 'Payslips@confirm');
Route::post('/payslips/get-holidays-deductions', 'Payslips@get_holidays_deductions');

Route::get('/payslips/paid-salaries', 'Payslips@paid_salaries');

Route::get('/salary-report-yearly', 'Reports@salary_report_yearly');
Route::get('/salary-report-monthly', 'Reports@salary_report_monthly');

// language-setup routes
Route::get('/language', 'Language_setup@view');
Route::get('/language/add', 'Language_setup@add');
Route::post('/language/save', 'Language_setup@save');
Route::get('/language/edit/{id}', 'Language_setup@edit');
Route::post('/language/update/{id}', 'Language_setup@update');
Route::get('/language/delete/{id}', 'Language_setup@delete');
Route::get('/language/edit-phrase/{id}', 'Language_setup@edit_phrase');
Route::post('/language/update-phrase/{id}', 'Language_setup@update_phrase');

// product-category routes
Route::get('/product-category', 'Product_category@view');
Route::get('/product-category/add', 'Product_category@add');
Route::post('/product-category/save', 'Product_category@save');
Route::get('/product-category/edit/{id}', 'Product_category@edit');
Route::post('/product-category/update/{id}', 'Product_category@update');
Route::get('/product-category/delete/{id}', 'Product_category@delete');

// journal routes
Route::get('/journal', 'Journal@view');
Route::get('/journal/print', 'Journal@print');
Route::get('/journal/add', 'Journal@add');
Route::post('/journal/save', 'Journal@save');
Route::get('/journal/edit/{id}', 'Journal@edit');
Route::post('/journal/update/{id}', 'Journal@update');
Route::get('/journal/delete/{id}', 'Journal@delete');
Route::get('/journal/invoice/{id}', 'Journal@invoice');

// debit credit note routes
Route::get('/debit-credit-note', 'Debit_credit_note@view');
Route::get('/debit-credit-note/print', 'Debit_credit_note@print');
Route::get('/debit-credit-note/add', 'Debit_credit_note@add');
Route::post('/debit-credit-note/save', 'Debit_credit_note@save');
Route::get('/debit-credit-note/edit/{id}', 'Debit_credit_note@edit');
Route::post('/debit-credit-note/update/{id}', 'Debit_credit_note@update');
Route::get('/debit-credit-note/delete/{id}', 'Debit_credit_note@delete');
Route::get('/debit-credit-note/invoice/{id}', 'Debit_credit_note@invoice');
Route::post('/debit-credit-note/update-status', 'Debit_credit_note@update_status');

// debit credit voucher routes
Route::get('/debit-credit-voucher', 'Debit_credit_voucher@view');
Route::get('/debit-credit-voucher/print', 'Debit_credit_voucher@print');
Route::get('/debit-credit-voucher/add', 'Debit_credit_voucher@add');
Route::post('/debit-credit-voucher/save', 'Debit_credit_voucher@save');
Route::get('/debit-credit-voucher/edit/{id}', 'Debit_credit_voucher@edit');
Route::post('/debit-credit-voucher/update/{id}', 'Debit_credit_voucher@update');
Route::get('/debit-credit-voucher/delete/{id}', 'Debit_credit_voucher@delete');
Route::get('/debit-credit-voucher/invoice/{id}', 'Debit_credit_voucher@invoice');

// journal routes
Route::get('/calander', 'Calander@edit');
Route::post('/calander/update', 'Calander@update');

// warehouse routes
Route::get('/warehouse', 'Warehouse@view');
Route::get('/warehouse/add', 'Warehouse@add');
Route::post('/warehouse/save', 'Warehouse@save');
Route::get('/warehouse/edit/{id}', 'Warehouse@edit');
Route::post('/warehouse/update/{id}', 'Warehouse@update');
Route::get('/warehouse/delete/{id}', 'Warehouse@delete');
Route::get('/warehouse/details/{id}', 'Warehouse@details');
Route::get('/warehouse/details-print/{id}', 'Warehouse@details_print');

// transfer routes
Route::get('/transfer', 'Transfer@view');
Route::get('/transfer/add', 'Transfer@add');
Route::post('/transfer/save', 'Transfer@save');
Route::get('/transfer/edit/{id}', 'Transfer@edit');
Route::post('/transfer/update/{id}', 'Transfer@update');
Route::get('/transfer/delete/{id}', 'Transfer@delete');

// items routes
Route::get('/items', 'Items@view');
Route::get('/items-all', 'Items@view_all');
Route::get('/items-print', 'Items@view_print');
Route::get('/items/add', 'Items@add');
Route::post('/items/save', 'Items@save');
Route::get('/items/edit/{id}', 'Items@edit');
Route::post('/items/update/{id}', 'Items@update');
Route::get('/items/delete/{id}', 'Items@delete');
Route::post('/items/save-columns', 'Items@save_columns');

Route::get('/items-settings', 'Items@settings');
Route::post('/items-settings/save', 'Items@save_settings');
Route::post('/items-settings/update-system-modules', 'Items@update_system_modules');

Route::get('/sets', 'Sets@view');
Route::get('/sets/add', 'Sets@add');
Route::post('/sets/save', 'Sets@save');
Route::get('/sets/edit/{id}', 'Sets@edit');
Route::post('/sets/update/{id}', 'Sets@update');
Route::get('/sets/delete/{id}', 'Sets@delete');
Route::post('/sets/get-items-appended-data', 'Sets@get_items_appended_data');

// purchases routes
Route::get('/purchases', 'Purchases@view');
Route::get('/purchases/add', 'Purchases@add');
Route::post('/purchases/save', 'Purchases@save');
Route::get('/purchases/edit/{id}', 'Purchases@edit');
Route::post('/purchases/update/{id}', 'Purchases@update');
Route::get('/purchases/delete/{id}', 'Purchases@delete');
Route::get('/purchases/update-status/{id}', 'Purchases@update_status');
Route::get('/purchases/invoice/{id}', 'Purchases@invoice');
Route::post('/purchases/save-cbm-weight', 'Purchases@save_cbm_weight');

// purchases routes
Route::get('/cn-purchases', 'CNPurchases@view');
Route::get('/cn-purchases/add', 'CNPurchases@add');
Route::post('/cn-purchases/save', 'CNPurchases@save');
Route::get('/cn-purchases/edit/{id}', 'CNPurchases@edit');
Route::post('/cn-purchases/update/{id}', 'CNPurchases@update');
Route::get('/cn-purchases/delete/{id}', 'CNPurchases@delete');

// process routes
Route::get('/process', 'Process@view');
Route::get('/process/add', 'Process@add');
Route::post('/process/save', 'Process@save');
Route::get('/process/edit/{id}', 'Process@edit');
Route::post('/process/update/{id}', 'Process@update');
Route::get('/process/delete/{id}', 'Process@delete');

// production routes
// Route::get('/production', 'Production@view');
// Route::get('/production/add', 'Production@add');
// Route::post('/production/save', 'Production@save');
// Route::get('/production/edit/{id}', 'Production@edit');
// Route::post('/production/update/{id}', 'Production@update');
// Route::get('/production/delete/{id}', 'Production@delete');
// Route::post('/production/item-details', 'Production@item_details');
// Route::get('/production/invoice/{id}', 'Production@invoice');

// Route::post('/production/get-produced-item-ava-qty', 'Production@get_produced_item_ava_qty');


// production routes
Route::get('/production', 'Production@view');
Route::get('/production/add', 'Production@add');
Route::post('/production/save', 'Production@save');
Route::get('/production/edit/{id}', 'Production@edit');
Route::post('/production/update/{id}', 'Production@update');
Route::get('/production/delete/{id}', 'Production@delete');
Route::post('/production/item-details', 'Production@item_details');
Route::get('/production/invoice/{id}', 'Production@invoice');
Route::post('/production/get-relational-items', 'Production@get_relational_items');

Route::post('/production/get-produced-item-ava-qty', 'Production@get_produced_item_ava_qty');

Route::get('/production-relation', 'Production_relation@view');
Route::get('/production-relation/add', 'Production_relation@add');
Route::post('/production-relation/save', 'Production_relation@save');
Route::get('/production-relation/edit/{id}', 'Production_relation@edit');
Route::post('/production-relation/update/{id}', 'Production_relation@update');
Route::get('/production-relation/delete/{id}', 'Production_relation@delete');
Route::post('/production-relation/produced-items-data', 'Production_relation@produced_items_data');
Route::post('/production-relation/raw-items-data', 'Production_relation@raw_items_data');


Route::get('/production-raw', 'Production_raw@view');
Route::get('/production-raw/add', 'Production_raw@add');
Route::post('/production-raw/save', 'Production_raw@save');
Route::get('/production-raw/edit/{id}', 'Production_raw@edit');
Route::post('/production-raw/update/{id}', 'Production_raw@update');
Route::get('/production-raw/delete/{id}', 'Production_raw@delete');
Route::post('/production-raw/item-details', 'Production_raw@item_details');
Route::get('/production-raw/invoice/{id}', 'Production_raw@invoice');
Route::post('/production-raw/get-relational-items', 'Production_raw@get_relational_items');

Route::post('/production-raw/get-produced-item-ava-qty', 'Production_raw@get_produced_item_ava_qty');

Route::get('/production-raw-relation', 'Production_raw_relation@view');
Route::get('/production-raw-relation/add', 'Production_raw_relation@add');
Route::post('/production-raw-relation/save', 'Production_raw_relation@save');
Route::get('/production-raw-relation/edit/{id}', 'Production_raw_relation@edit');
Route::post('/production-raw-relation/update/{id}', 'Production_raw_relation@update');
Route::get('/production-raw-relation/delete/{id}', 'Production_raw_relation@delete');
Route::post('/production-raw-relation/produced-items-data', 'Production_raw_relation@produced_items_data');
Route::post('/production-raw-relation/raw-items-data', 'Production_raw_relation@raw_items_data');


Route::get('/new-production-formula', 'Production_formula@view');
Route::get('/new-production-formula/add', 'Production_formula@add');
Route::post('/new-production-formula/save', 'Production_formula@save');
Route::get('/new-production-formula/edit/{id}', 'Production_formula@edit');
Route::post('/new-production-formula/update/{id}', 'Production_formula@update');
Route::get('/new-production-formula/delete/{id}', 'Production_formula@delete');
Route::post('/new-production-formula/get-items-data', 'Production_formula@get_items_data');

Route::get('/new-production', 'Production_new@view');
Route::get('/new-production/add', 'Production_new@add');
Route::post('/new-production/save', 'Production_new@save');
Route::get('/new-production/edit/{id}', 'Production_new@edit');
Route::post('/new-production/update/{id}', 'Production_new@update');
Route::get('/new-production/delete/{id}', 'Production_new@delete');
Route::post('/new-production/get-items-data', 'Production_new@get_items_data');

// extra income routes
Route::get('/extra-income', 'Extra_income@view');
Route::get('/extra-income/add', 'Extra_income@add');
Route::post('/extra-income/save', 'Extra_income@save');
Route::get('/extra-income/edit/{id}', 'Extra_income@edit');
Route::post('/extra-income/update/{id}', 'Extra_income@update');
Route::get('/extra-income/delete/{id}', 'Extra_income@delete');
Route::post('/extra-income/item-details', 'Extra_income@item_details');
Route::get('/extra-income/invoice/{id}', 'Extra_income@invoice');

// extra income type routes
Route::get('/extra-income-type', 'Extra_income_type@view');
Route::get('/extra-income-type/add', 'Extra_income_type@add');
Route::post('/extra-income-type/save', 'Extra_income_type@save');
Route::get('/extra-income-type/edit/{id}', 'Extra_income_type@edit');
Route::post('/extra-income-type/update/{id}', 'Extra_income_type@update');
Route::get('/extra-income-type/delete/{id}', 'Extra_income_type@delete');

// sales routes
Route::get('/sales', 'Sales@view');
Route::get('/sales-all', 'Sales@view_all');
Route::get('/sales/add', 'Sales@add');
Route::post('/sales/save', 'Sales@save');
Route::get('/sales/edit/{id}', 'Sales@edit');
Route::post('/sales/update/{id}', 'Sales@update');
Route::get('/sales/delete/{id}', 'Sales@delete');
Route::post('/sales/item-details', 'Sales@item_details');
Route::get('/sales/invoice/{id}', 'Sales@invoice');
Route::get('/sales/deliver-note/{id}', 'Sales@delivery_note');
Route::post('/sales/get-items-batch', 'Sales@get_items_batch');
Route::post('/sales/get-items-batch-json', 'Sales@get_items_batch_json');
Route::post('/sales/get-sets-appended-data', 'Sales@get_sets_appended_data');

Route::get('/pending-sales', 'Pending_sales@view');
Route::get('/pending-sales/add/{id}', 'Pending_sales@add');
Route::post('/pending-sales/update/{id}', 'Pending_sales@update');

// quotation routes
Route::get('/quotations', 'Quotation@view');
Route::get('/quotations/converted', 'Quotation@converted');
Route::get('/quotations/add', 'Quotation@add');
Route::post('/quotations/save', 'Quotation@save');
Route::get('/quotations/edit/{id}', 'Quotation@edit');
Route::post('/quotations/update/{id}', 'Quotation@update');
Route::get('/quotations/delete/{id}', 'Quotation@delete');
Route::post('/quotations/item-details', 'Quotation@item_details');
Route::get('/quotations/invoice/{id}', 'Quotation@invoice');
Route::get('/quotations/deliver-note/{id}', 'Quotation@delivery_note');

// damage routes
Route::get('/damage-stock', 'Damage@view');
Route::get('/damage-stock/add', 'Damage@add');
Route::post('/damage-stock/save', 'Damage@save');
Route::get('/damage-stock/edit/{id}', 'Damage@edit');
Route::post('/damage-stock/update/{id}', 'Damage@update');
Route::get('/damage-stock/delete/{id}', 'Damage@delete');

// Item_Stock_IN routes
Route::get('/item-stock', 'Item_stock@view');
Route::get('/item-stock/add', 'Item_stock@add');
Route::post('/item-stock/save', 'Item_stock@save');
Route::get('/item-stock/edit/{id}', 'Item_stock@edit');
Route::post('/item-stock/update/{id}', 'Item_stock@update');
Route::get('/item-stock/delete/{id}', 'Item_stock@delete');

Route::get('/item-stock-in', 'Item_stock_in@view');
Route::get('/item-stock-in/add', 'Item_stock_in@add');
Route::post('/item-stock-in/save', 'Item_stock_in@save');
Route::get('/item-stock-in/edit/{id}', 'Item_stock_in@edit');
Route::post('/item-stock-in/update/{id}', 'Item_stock_in@update');
Route::get('/item-stock-in/delete/{id}', 'Item_stock_in@delete');

// Division
Route::get('/division', 'Division@view');
Route::get('/division/add', 'Division@add');
Route::post('/division/save', 'Division@save');
Route::get('/division/edit/{id}', 'Division@edit');
Route::post('/division/update/{id}', 'Division@update');
Route::get('/division/delete/{id}', 'Division@delete');

// Item_Stock_OUT routes
Route::get('/item-stock-out', 'Item_stock_out@view');
Route::get('/item-stock-out/add', 'Item_stock_out@add');
Route::post('/item-stock-out/save', 'Item_stock_out@save');
Route::get('/item-stock-out/edit/{id}', 'Item_stock_out@edit');
Route::post('/item-stock-out/update/{id}', 'Item_stock_out@update');
Route::get('/item-stock-out/delete/{id}', 'Item_stock_out@delete');
Route::get('/item-stock-balance-report', 'Item_stock_out@item_stock_balance_report');


// expenses-types routes
Route::get('/expenses-types', 'Expenses_types@view');
Route::get('/expenses-types/add', 'Expenses_types@add');
Route::post('/expenses-types/save', 'Expenses_types@save');
Route::get('/expenses-types/edit/{id}', 'Expenses_types@edit');
Route::post('/expenses-types/update/{id}', 'Expenses_types@update');
Route::get('/expenses-types/delete/{id}', 'Expenses_types@delete');

// expenses routes
Route::get('/expenses', 'Expenses@view');
Route::get('/expenses/add', 'Expenses@add');
Route::post('/expenses/save', 'Expenses@save');
Route::get('/expenses/edit/{id}', 'Expenses@edit');
Route::post('/expenses/update/{id}', 'Expenses@update');
Route::get('/expenses/delete/{id}', 'Expenses@delete');

// shareholder routes
Route::get('/shareholder', 'Shareholder@view');
Route::get('/shareholder/add', 'Shareholder@add');
Route::post('/shareholder/save', 'Shareholder@save');
Route::get('/shareholder/edit/{id}', 'Shareholder@edit');
Route::post('/shareholder/update/{id}', 'Shareholder@update');
Route::get('/shareholder/delete/{id}', 'Shareholder@delete');

// turnover routes
Route::get('/turnover', 'Turnover@view');
Route::get('/turnover/add', 'Turnover@add');
Route::post('/turnover/save', 'Turnover@save');
Route::get('/turnover/edit/{id}', 'Turnover@edit');
Route::post('/turnover/update/{id}', 'Turnover@update');
Route::get('/turnover/delete/{id}', 'Turnover@delete');

// Shareholder_credit routes
Route::get('/shareholder-credit', 'Shareholder_credit@view');
Route::get('/shareholder-credit/add', 'Shareholder_credit@add');
Route::post('/shareholder-credit/save', 'Shareholder_credit@save');
Route::get('/shareholder-credit/edit/{id}', 'Shareholder_credit@edit');
Route::post('/shareholder-credit/update/{id}', 'Shareholder_credit@update');
Route::get('/shareholder-credit/delete/{id}', 'Shareholder_credit@delete');


// transit routes
Route::get('/transit', 'Transit@view');
Route::get('/transit/add', 'Transit@add');
Route::post('/transit/save', 'Transit@save');
Route::get('/transit/edit/{id}', 'Transit@edit');
Route::post('/transit/update/{id}', 'Transit@update');
Route::get('/transit/delete/{id}', 'Transit@delete');


// Reports routes
Route::get('/reports', 'Reports@reports_menu');
Route::get('/financial-accounts-ledger', 'Reports@financial_menu');
Route::get('/financial-accounts-ledger-view', 'Reports@financial_view');
Route::get('/reports/expenses', 'Reports@expenses');
Route::get('/reports/stock-general-ledger', 'Reports@stock_general_ledger');
Route::get('/reports/items-by-warehouse', 'Reports@items_by_warehouse');
Route::get('/reports/items-token', 'Reports@items_token');
Route::get('/reports/audit', 'Reports@audit');

Route::get('/reports/accounts', 'Reports@all_accounts');
Route::get('/reports/accounts_print', 'Reports@all_accounts_print');
Route::get('/reports/accounts-new-old', 'Reports@all_accounts_old');
Route::get('/reports/accounts_print-old', 'Reports@all_accounts_print_old');
Route::post('/reports/accounts-cross-check', 'Reports@save_accounts_cross_check');

Route::get('/reports/balance-summary', 'Reports@balance_summary');
Route::get('/reports/balance-summary-old', 'Reports@balance_summary_old');

Route::get('/reports/inventory', 'Reports@inventory');
Route::get('/reports/sale-stock', 'Reports@sale_stock_report');
Route::get('/reports/sale-stock1', 'Reports@sale_stock_report_old');
Route::get('/reports/item-stock', 'Reports@item_stock_report');
Route::get('/reports/raw-warehouses', 'Reports@raw_warehouses');
Route::get('/reports/sales-warehouses', 'Reports@sales_warehouses');
Route::get('/reports/damage-items', 'Reports@damage_items');

Route::get('/reports/items-ledger', 'Reports@items_ledger');

Route::get('/reports/sales', 'Reports@sales');
Route::get('/reports/sales-and-return', 'Reports@sales_and_return');
Route::get('/reports/all-bonuses', 'Reports@all_bonuses');
Route::get('/reports/sales-items', 'Reports@sales_items');
Route::get('/reports/purchases', 'Reports@purchases');
Route::get('/reports/purchases-items', 'Reports@purchases_items');
Route::get('/reports/production', 'Reports@production');
Route::get('/reports/client-items', 'Reports@client_items');
Route::get('/reports/purchase-expenses', 'Reports@purchase_expenses');
Route::get('/reports/sale-expenses', 'Reports@sale_expenses');
Route::get('/reports/production-expenses', 'Reports@production_expenses');
Route::get('/reports/warehouse-transfer', 'Reports@warehouse_transfer');
Route::get('/reports/sale-discount', 'Reports@sale_discount');
Route::get('/reports/sale-discount-2', 'Reports@sale_discount_2');
Route::get('/reports/purchase-discount', 'Reports@purchase_discount');
Route::get('/reports/transfer-in-discount-1', 'Reports@transfer_in_discount_1');
Route::get('/reports/transfer-in-discount-2', 'Reports@transfer_in_discount_2');
Route::get('/reports/transfer-out-discount-1', 'Reports@transfer_out_discount_1');
Route::get('/reports/transfer-out-discount-2', 'Reports@transfer_out_discount_2');
Route::get('/reports/sales-service', 'Reports@sale_service');
Route::get('/reports/services', 'Reports@services');
Route::get('/reports/services-items', 'Reports@services_items');
Route::get('/reports/marketers', 'Reports@marketers');
Route::get('/reports/batch-wise-stock', 'Reports@batch_wise_stock');
Route::get('/reports/sales-return', 'Reports@sales_return');

Route::get('/reports/near-expiry-stock', 'Reports@near_expiry_stock');
Route::get('/reports/expired-stock', 'Reports@expired_stock');
Route::get('/reports/shortage-stock', 'Reports@shortage_stock');
Route::get('/reports/bundle-toop', 'Reports@bundle_toop');
Route::get('/reports/shareholder-ledger', 'Reports@shareholder_ledger');


// financials
Route::get('/chart-of-accounts', 'Financial@chart_of_accounts');
Route::get('/balance-sheet', 'Financial@balance_sheet');
Route::get('/balance-sheet-print', 'Financial@balance_sheet_print');
Route::get('/micro-balance-sheet', 'Financial@micro_balance_sheet');
Route::get('/trial-balance', 'Financial@trial_balance');
Route::get('/cash-flow', 'Financial@cash_flow');
Route::get('/income-statement', 'Financial@income_statement');
Route::get('/profit-and-loss', 'Financial@profit_and_loss');
Route::get('/client-balance-summary', 'Financial@client_balance_summary');
Route::get('/client-balance-summary-print', 'Financial@client_balance_summary_print');
Route::get('/marketers-income-statement', 'Financial@marketers_income_statement');
Route::post('/get-balance-summary-filter-by', 'Financial@get_filter_by');
Route::post('/get-balance-summary-accounts', 'Financial@get_accounts');
Route::get('/incomes-vs-expenses', 'Financial@incomes_vs_expenses');
Route::get('/day-closing', 'Financial@day_closing');
Route::get('/day-closing-print', 'Financial@day_closing_print');
Route::get('/sales-man-receovery', 'Financial@sales_man_receovery');

// users routes
Route::get('/users', 'Users@view');
Route::get('/users/add', 'Users@add');
Route::post('/users/save', 'Users@save');
Route::get('/users/edit/{id}', 'Users@edit');
Route::post('/users/update/{id}', 'Users@update');
Route::get('/users/delete/{id}', 'Users@delete');

// lot-purchase routes
Route::get('/lot-purchase', 'Lot@view');
Route::get('/lot-purchase/add', 'Lot@add');
Route::post('/lot-purchase/save', 'Lot@save');
Route::get('/lot-purchase/edit/{id}', 'Lot@edit');
Route::post('/lot-purchase/update/{id}', 'Lot@update');
Route::get('/lot-purchase/delete/{id}', 'Lot@delete');
Route::get('/lot-purchase/invoice/{id}', 'Lot@invoice');

Route::get('/lot-purchase/avail', 'Lot@avail');
Route::post('/lot-purchase/avail/for-sale', 'Lot@sale_data');
Route::post('/lot-purchase/avail/save', 'Lot@save_sold');

Route::post('/lot-purchase/avail/for-invoice-sale', 'Lot@invoice_sale_data');
Route::post('/lot-purchase/avail-invoice/save', 'Lot@save_sold_invoice');

Route::post('/lot-purchase/avail/for-move', 'Lot@sale_data');

Route::get('/lot-purchase/sold', 'Lot@sales');

Route::get('/lot-purchase/sold/edit/{id}', 'Lot@edit_sale');
Route::post('/lot-purchase/sold/update/{id}', 'Lot@update_sale');

Route::get('/lot-purchase/sold/invoice/{id}', 'Lot@sale_invoice');
Route::get('/lot-purchase/sold/delete/{id}', 'Lot@delete_sale');

Route::get('/lot-purchase/moved', 'Lot@moved');
Route::post('/lot-purchase/moved/save', 'Lot@save_moved');
Route::get('/lot-purchase/moved/delete/{id}', 'Lot@delete_moved');

Route::get('/lot-purchase/difference', 'Lot@sales_difference_report');
Route::get('/lot-purchase/sold-difference', 'Lot@sales_difference_report');

Route::get('/lot-purchase/moved-difference', 'Lot@moved_difference_report');
Route::post('/lot-purchase-moved/hide-items', 'Lot@hide_lot_moved_items');
Route::post('/lot-purchase-moved/show-items', 'Lot@show_lot_moved_items');

Route::get('/lot-purchase/difference-report', 'Lot@purchase_difference_report');
Route::post('/lot-purchase/hide-items', 'Lot@hide_lot_items');
Route::post('/lot-purchase/show-items', 'Lot@show_lot_items');

Route::get('/lot-purchase/fuel-difference-report', 'Lot@purchase_difference_report_fuel');
Route::get('/lot-purchase/fuel-pending-report', 'Lot@purchase_fuel_pending_report');

Route::get('/lot-purchase/fuel-lose-report', 'Lot@purchase_fuel_lose_report');



// branch transfer on routes
Route::get('/branch-transfer-in', 'Branch_transfer_in@view');
Route::get('/branch-transfer-in/add', 'Branch_transfer_in@add');
Route::post('/branch-transfer-in/save', 'Branch_transfer_in@save');
Route::get('/branch-transfer-in/edit/{id}', 'Branch_transfer_in@edit');
Route::post('/branch-transfer-in/update/{id}', 'Branch_transfer_in@update');
Route::get('/branch-transfer-in/delete/{id}', 'Branch_transfer_in@delete');

// branch transfer on routes
Route::get('/branch-transfer-out', 'Branch_transfer_out@view');
Route::get('/branch-transfer-out/add', 'Branch_transfer_out@add');
Route::post('/branch-transfer-out/save', 'Branch_transfer_out@save');
Route::get('/branch-transfer-out/edit/{id}', 'Branch_transfer_out@edit');
Route::post('/branch-transfer-out/update/{id}', 'Branch_transfer_out@update');
Route::get('/branch-transfer-out/delete/{id}', 'Branch_transfer_out@delete');

// branch transfer in routes
Route::get('/branch-transfer-in', 'Branch_transfer_in@view');
Route::get('/branch-transfer-in/add', 'Branch_transfer_in@add');
Route::post('/branch-transfer-in/save', 'Branch_transfer_in@save');
Route::get('/branch-transfer-in/edit/{id}', 'Branch_transfer_in@edit');
Route::post('/branch-transfer-in/update/{id}', 'Branch_transfer_in@update');
Route::get('/branch-transfer-in/delete/{id}', 'Branch_transfer_in@delete');




// ---------------------------------------------------------------------------
// construction routes
// ---------------------------------------------------------------------------

// projects routes
Route::get('/projects', 'Project@view');
Route::get('/projects/add', 'Project@add');
Route::post('/projects/save', 'Project@save');
Route::get('/projects/edit/{id}', 'Project@edit');
Route::post('/projects/update/{id}', 'Project@update');
Route::get('/projects/delete/{id}', 'Project@delete');
Route::get('/projects/complete/{id}', 'Project@complete');
Route::get('/projects/completed', 'Project@view_completed');
Route::get('/projects/back-to-process/{id}', 'Project@back_to_process');
Route::get('/projects/in-process', 'Project@view_in_process');
Route::get('/projects/process-details/{id}', 'Project@process_details');
Route::get('/projects/project-assign-report', 'Project@project_assign_report');

// projects-reports routes
Route::get('/projects-reports', 'Project_report@view');
Route::get('/projects-reports/add', 'Project_report@add');
Route::post('/projects-reports/save', 'Project_report@save');
Route::get('/projects-reports/edit/{id}', 'Project_report@edit');
Route::post('/projects-reports/update/{id}', 'Project_report@update');
Route::get('/projects-reports/delete/{id}', 'Project_report@delete');
Route::get('/projects-reports/view/{id}', 'Project_report@view_single');

// payment deductions routes
Route::get('/payment-deductions', 'Payment_deductions@view');
Route::get('/payment-deductions/add', 'Payment_deductions@add');
Route::post('/payment-deductions/save', 'Payment_deductions@save');
Route::get('/payment-deductions/edit/{id}', 'Payment_deductions@edit');
Route::post('/payment-deductions/update/{id}', 'Payment_deductions@update');
Route::get('/payment-deductions/delete/{id}', 'Payment_deductions@delete');

// payment deductions routes
Route::get('/project-payments', 'Project_payments@view');
Route::get('/project-payments/add', 'Project_payments@add');
Route::post('/project-payments/save', 'Project_payments@save');
Route::get('/project-payments/edit/{id}', 'Project_payments@edit');
Route::post('/project-payments/update/{id}', 'Project_payments@update');
Route::get('/project-payments/delete/{id}', 'Project_payments@delete');

// expenses deductions routes
Route::get('/expenses-deductions', 'Expenses_deductions@view');
Route::get('/expenses-deductions/add', 'Expenses_deductions@add');
Route::post('/expenses-deductions/save', 'Expenses_deductions@save');
Route::get('/expenses-deductions/edit/{id}', 'Expenses_deductions@edit');
Route::post('/expenses-deductions/update/{id}', 'Expenses_deductions@update');
Route::get('/expenses-deductions/delete/{id}', 'Expenses_deductions@delete');
Route::post('/expenses-deductions/delete-all', 'Expenses_deductions@delete_all');
Route::get('/expenses-deductions/item-stats/{id}', 'Expenses_deductions@item_stats');
Route::get('/expenses-deductions/approved', 'Expenses_deductions@approved_view');
Route::get('/expenses-deductions/approve/{id}', 'Expenses_deductions@approve');
Route::post('/expenses-deductions/approve-all', 'Expenses_deductions@approved_all');
Route::get('/expenses-deductions/disapprove/{id}', 'Expenses_deductions@disapprove');
Route::post('/expenses-deductions/disapprove-all', 'Expenses_deductions@disapprove_all');

// expenses deductions routes | user based
Route::get('/project-expenses-deductions', 'Project_expenses_deductions@view');
Route::get('/project-expenses-deductions/add', 'Project_expenses_deductions@add');
Route::post('/project-expenses-deductions/save', 'Project_expenses_deductions@save');
Route::get('/project-expenses-deductions/edit/{id}', 'Project_expenses_deductions@edit');
Route::post('/project-expenses-deductions/update/{id}', 'Project_expenses_deductions@update');
Route::get('/project-expenses-deductions/delete/{id}', 'Project_expenses_deductions@delete');
Route::post('/project-expenses-deductions/delete-all', 'Project_expenses_deductions@delete_all');
Route::get('/project-expenses-deductions/approved', 'Project_expenses_deductions@approved_view');

// loans routes | user based
Route::get('/project-loans', 'Project_loans@view');
Route::post('/project-loans/update/{id}', 'Project_loans@update');
Route::get('/project-received-money', 'Project_loans@received_money');

// leaves routes
Route::get('/leaves', 'Leaves@view');
Route::get('/leaves/add', 'Leaves@add');
Route::post('/leaves/save', 'Leaves@save');
Route::get('/leaves/edit/{id}', 'Leaves@edit');
Route::post('/leaves/update/{id}', 'Leaves@update');
Route::get('/leaves/delete/{id}', 'Leaves@delete');
Route::post('/leaves/return-time', 'Leaves@save_return');

// attendence routes
Route::get('/attendence', 'Attendence@view');
Route::post('/attendence/save', 'Attendence@save');
Route::post('/attendence/delete', 'Attendence@delete');
Route::get('/attendence-report', 'Attendence@attendence_report');
Route::get('/attendence-recover', 'Attendence@attendence_recover');

Route::post('/attendence/manage-all-employees-attendence', 'Attendence@manage_all_employees_attendence');

// items
Route::get('/citems', 'Citems@view');
Route::get('/citems/add', 'Citems@add');
Route::post('/citems/save', 'Citems@save');
Route::get('/citems/edit/{id}', 'Citems@edit');
Route::post('/citems/update/{id}', 'Citems@update');
Route::get('/citems/delete/{id}', 'Citems@delete');

// warehouses
Route::get('/cwarehouses', 'Cwarehouses@view');
Route::get('/cwarehouses/add', 'Cwarehouses@add');
Route::post('/cwarehouses/save', 'Cwarehouses@save');
Route::get('/cwarehouses/edit/{id}', 'Cwarehouses@edit');
Route::post('/cwarehouses/update/{id}', 'Cwarehouses@update');
Route::get('/cwarehouses/delete/{id}', 'Cwarehouses@delete');
Route::get('/cwarehouses/details/{id}', 'Cwarehouses@details');

// items
Route::get('/cpurchases', 'Cpurchases@view');
Route::get('/cpurchases/add', 'Cpurchases@add');
Route::post('/cpurchases/save', 'Cpurchases@save');
Route::get('/cpurchases/edit/{id}', 'Cpurchases@edit');
Route::post('/cpurchases/update/{id}', 'Cpurchases@update');
Route::get('/cpurchases/delete/{id}', 'Cpurchases@delete');
Route::get('/cpurchases/invoice/{id}', 'Cpurchases@invoice');

// contracts
Route::get('/ccontracts', 'Ccontracts@view');
Route::get('/ccontracts/add', 'Ccontracts@add');
Route::post('/ccontracts/save', 'Ccontracts@save');
Route::get('/ccontracts/edit/{id}', 'Ccontracts@edit');
Route::post('/ccontracts/update/{id}', 'Ccontracts@update');
Route::get('/ccontracts/delete/{id}', 'Ccontracts@delete');


// project assign
Route::get('/projects-assign', 'Projects_assign@view');
Route::get('/projects-assign/print', 'Projects_assign@print_view');
Route::get('/projects-assign/add', 'Projects_assign@add');
Route::post('/projects-assign/save', 'Projects_assign@save');
Route::get('/projects-assign/edit/{id}', 'Projects_assign@edit');
Route::post('/projects-assign/update/{id}', 'Projects_assign@update');
Route::get('/projects-assign/delete/{id}', 'Projects_assign@delete');
Route::get('/projects-assign/status/{id}', 'Projects_assign@status');
Route::post('/projects-assign/get-warehouse-items', 'Projects_assign@warehouse_items');

// project assign
Route::get('/project-assign-user', 'Project_assign_user@view');
Route::get('/project-assign-user/add', 'Project_assign_user@add');
Route::post('/project-assign-user/save', 'Project_assign_user@save');
Route::get('/project-assign-user/edit/{id}', 'Project_assign_user@edit');
Route::post('/project-assign-user/update/{id}', 'Project_assign_user@update');
Route::get('/project-assign-user/delete/{id}', 'Project_assign_user@delete');

// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------






// ---------------------------------------------------------------------------
// showroom routes
// ---------------------------------------------------------------------------

Route::get('/showroom', 'Showroom@view');
Route::post('/showroom/upload-images', 'Showroom@upload_images');
Route::post('/showroom/delete-images', 'Showroom@delete_images');

// sales
Route::get('/showroom-sales', 'Showroom_sales@view');
Route::get('/showroom-sales/add/{id}', 'Showroom_sales@add');
Route::post('/showroom-sales/save', 'Showroom_sales@save');
Route::get('/showroom-sales/edit/{id}', 'Showroom_sales@edit');
Route::post('/showroom-sales/update/{id}', 'Showroom_sales@update');
Route::get('/showroom-sales/delete/{id}', 'Showroom_sales@delete');
Route::get('/showroom-sales/invoice/{id}', 'Showroom_sales@invoice');

// car purchases
Route::get('/car-purchases', 'Car_purchases@view');
Route::get('/car-purchases/add', 'Car_purchases@add');
Route::post('/car-purchases/save', 'Car_purchases@save');
Route::get('/car-purchases/edit/{id}', 'Car_purchases@edit');
Route::post('/car-purchases/update/{id}', 'Car_purchases@update');
Route::get('/car-purchases/delete/{id}', 'Car_purchases@delete');
Route::get('/car-purchases/invoice/{id}', 'Car_purchases@invoice');

// car purchases
Route::get('/buy-cars', 'Buy_cars@view');
Route::get('/buy-cars/add', 'Buy_cars@add');
Route::post('/buy-cars/save', 'Buy_cars@save');
Route::get('/buy-cars/edit/{id}', 'Buy_cars@edit');
Route::post('/buy-cars/update/{id}', 'Buy_cars@update');
Route::get('/buy-cars/delete/{id}', 'Buy_cars@delete');
Route::get('/buy-cars/invoice/{id}', 'Buy_cars@invoice');
Route::get('/buy-cars/delete-images/{id}', 'Buy_cars@delete_images');


Route::get('/buy-cars/sale/view', 'Buy_cars@sale_view');
Route::get('/buy-cars/sale/{id}', 'Buy_cars@sale');
Route::post('/buy-cars/sale/save', 'Buy_cars@save_sale');
Route::get('/buy-cars/sale/edit/{id}', 'Buy_cars@sale_edit');
Route::post('/buy-cars/sale/update/{id}', 'Buy_cars@sale_update');
Route::get('/buy-cars/sale/delete/{id}', 'Buy_cars@sale_delete');

// people showrrom
Route::get('/people-showroom', 'People_showroom@view');
Route::get('/people-showroom/add', 'People_showroom@add');
Route::post('/people-showroom/save', 'People_showroom@save');
Route::get('/people-showroom/edit/{id}', 'People_showroom@edit');
Route::post('/people-showroom/update/{id}', 'People_showroom@update');
Route::get('/people-showroom/delete/{id}', 'People_showroom@delete');
Route::get('/people-showroom/invoice/{id}', 'People_showroom@invoice');
Route::get('/people-showroom/delete-images/{id}', 'People_showroom@delete_images');


Route::get('/people-showroom/sale/view', 'People_showroom@sale_view');
Route::get('/people-showroom/sale/{id}', 'People_showroom@sale');
Route::post('/people-showroom/sale/save', 'People_showroom@save_sale');
Route::get('/people-showroom/sale/edit/{id}', 'People_showroom@sale_edit');
Route::post('/people-showroom/sale/update/{id}', 'People_showroom@sale_update');
Route::get('/people-showroom/sale/delete/{id}', 'People_showroom@sale_delete');

// load deliveries
Route::get('/load-deliveries', 'Load_delivery@view');
Route::get('/load-deliveries/add', 'Load_delivery@add');
Route::post('/load-deliveries/save', 'Load_delivery@save');
Route::get('/load-deliveries/edit/{id}', 'Load_delivery@edit');
Route::post('/load-deliveries/update/{id}', 'Load_delivery@update');
Route::get('/load-deliveries/delete/{id}', 'Load_delivery@delete');

// custom expenses
Route::get('/custom-expenses', 'Custom_expenses@view');
Route::get('/custom-expenses/add', 'Custom_expenses@add');
Route::post('/custom-expenses/save', 'Custom_expenses@save');
Route::get('/custom-expenses/edit/{id}', 'Custom_expenses@edit');
Route::post('/custom-expenses/update/{id}', 'Custom_expenses@update');
Route::get('/custom-expenses/delete/{id}', 'Custom_expenses@delete');

// custom charges
Route::get('/custom-charges', 'Custom_charges@view');
Route::get('/custom-charges/add', 'Custom_charges@add');
Route::post('/custom-charges/save', 'Custom_charges@save');
Route::get('/custom-charges/edit/{id}', 'Custom_charges@edit');
Route::post('/custom-charges/update/{id}', 'Custom_charges@update');
Route::get('/custom-charges/delete/{id}', 'Custom_charges@delete');
Route::get('/custom-charges/invoice/{id}', 'Custom_charges@invoice');

// fixing expenses
Route::get('/fixing-expenses', 'Fixing_expenses@view');
Route::get('/fixing-expenses/add', 'Fixing_expenses@add');
Route::post('/fixing-expenses/save', 'Fixing_expenses@save');
Route::get('/fixing-expenses/edit/{id}', 'Fixing_expenses@edit');
Route::post('/fixing-expenses/update/{id}', 'Fixing_expenses@update');
Route::get('/fixing-expenses/delete/{id}', 'Fixing_expenses@delete');
Route::get('/fixing-expenses/invoice/{id}', 'Fixing_expenses@invoice');

// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------



// synchronization routes
Route::get('/synchronization', 'Admin@synchronization');
Route::get('/synchronization/sync-local', 'Admin@sync_local');
Route::post('/synchronization/sync-live', 'Synchronization@sync_live');



Route::get('/help/english', 'Help@english');
Route::get('/help/pashto', 'Help@pashto');
Route::get('/help/dari', 'Help@dari');



// services routes
Route::get('/services', 'Services@view');
Route::get('/services/add', 'Services@add');
Route::post('/services/save', 'Services@save');
Route::get('/services/edit/{id}', 'Services@edit');
Route::post('/services/update/{id}', 'Services@update');
Route::get('/services/delete/{id}', 'Services@delete');
Route::get('/services/invoice/{id}', 'Services@invoice');

// services quotation routes
Route::get('/services-quotation', 'Services_quotation@view');
Route::get('/services-quotation/converted', 'Services_quotation@view_converted');
Route::get('/services-quotation/add', 'Services_quotation@add');
Route::post('/services-quotation/save', 'Services_quotation@save');
Route::get('/services-quotation/edit/{id}', 'Services_quotation@edit');
Route::post('/services-quotation/update/{id}', 'Services_quotation@update');
Route::get('/services-quotation/delete/{id}', 'Services_quotation@delete');
Route::get('/services-quotation/invoice/{id}', 'Services_quotation@invoice');


// services routes
Route::get('/services-cat', 'Services_cat@view');
Route::get('/services-cat/add', 'Services_cat@add');
Route::post('/services-cat/save', 'Services_cat@save');
Route::get('/services-cat/edit/{id}', 'Services_cat@edit');
Route::post('/services-cat/update/{id}', 'Services_cat@update');
Route::get('/services-cat/delete/{id}', 'Services_cat@delete');
Route::get('/services-cat/invoice/{id}', 'Services_cat@invoice');

// marketers routes
Route::get('/marketers', 'Marketers@view');
Route::get('/marketers/add', 'Marketers@add');
Route::post('/marketers/save', 'Marketers@save');
Route::get('/marketers/edit/{id}', 'Marketers@edit');
Route::post('/marketers/update/{id}', 'Marketers@update');
Route::get('/marketers/delete/{id}', 'Marketers@delete');
Route::get('/marketers/invoice/{id}', 'Marketers@invoice');

Route::get('/email-alerts', 'Accounts@email_alerts');
Route::post('/send-mails', 'Accounts@send_mails');
Route::get('/message-alerts', 'Accounts@message_alerts');
Route::post('/send-message', 'Accounts@send_message');


// pharone routes

// client-categories routes
Route::get('/client-categories', 'Client_categories@view');
Route::get('/client-categories/add', 'Client_categories@add');
Route::post('/client-categories/save', 'Client_categories@save');
Route::get('/client-categories/edit/{id}', 'Client_categories@edit');
Route::post('/client-categories/update/{id}', 'Client_categories@update');
Route::get('/client-categories/delete/{id}', 'Client_categories@delete');


// sales-man routes
Route::get('/sales-man', 'Sales_man@view');
Route::get('/sales-man/add', 'Sales_man@add');
Route::post('/sales-man/save', 'Sales_man@save');
Route::get('/sales-man/edit/{id}', 'Sales_man@edit');
Route::post('/sales-man/update/{id}', 'Sales_man@update');
Route::get('/sales-man/delete/{id}', 'Sales_man@delete');
Route::get('/sales-man/invoice/{id}', 'Sales_man@invoice');
Route::get('/sales-man/report/{id}', 'Sales_man@report');
Route::get('/sales-man/sales/{id}', 'Sales_man@sales');

// money receipts
Route::get('/money-receipts', 'Money_receipts@view');
Route::get('/money-receipts/add', 'Money_receipts@add');
Route::post('/money-receipts/save', 'Money_receipts@save');
Route::get('/money-receipts/edit/{id}', 'Money_receipts@edit');
Route::post('/money-receipts/update/{id}', 'Money_receipts@update');
Route::get('/money-receipts/delete/{id}', 'Money_receipts@delete');
Route::get('/money-receipts/invoice/{id}', 'Money_receipts@invoice');

Route::post('/money-receipts/get-client-balance', 'Money_receipts@get_client_balance');
Route::get('/db-my-sales', 'Money_receipts@sales');

// activities
Route::get('/activities', 'Activities@view');
Route::get('/activities/add', 'Activities@add');
Route::post('/activities/save', 'Activities@save');
Route::get('/activities/edit/{id}', 'Activities@edit');
Route::post('/activities/update/{id}', 'Activities@update');
Route::get('/activities/delete/{id}', 'Activities@delete');
Route::get('/activities/invoice/{id}', 'Activities@invoice');

Route::get('/approvals', 'Approvals@view');
Route::get('/approved', 'Approvals@approved');
Route::get('/approved-print', 'Approvals@approved_print');
Route::post('/receipts/update-status', 'Approvals@update_status');

Route::get('/approvals/activities', 'Approvals@view_activities');
Route::get('/approvals/activities-approved', 'Approvals@view_activities_approved');
Route::post('/approvals/update-status', 'Approvals@update_status_activities');


// sales-return routes
Route::get('/sales-return', 'Sales_return@view');
Route::get('/sales-return/add', 'Sales_return@add');
Route::post('/sales-return/save', 'Sales_return@save');
Route::get('/sales-return/edit/{id}', 'Sales_return@edit');
Route::post('/sales-return/update/{id}', 'Sales_return@update');
Route::get('/sales-return/delete/{id}', 'Sales_return@delete');
Route::get('/sales-return/invoice/{id}', 'Sales_return@invoice');

Route::post('/sales-return/get-client-invoices', 'Sales_return@get_client_invoices');



// transfer-in routes
Route::get('/transfer-in', 'Transfer_in@view');
Route::get('/transfer-in/add', 'Transfer_in@add');
Route::post('/transfer-in/save', 'Transfer_in@save');
Route::get('/transfer-in/edit/{id}', 'Transfer_in@edit');
Route::post('/transfer-in/update/{id}', 'Transfer_in@update');
Route::get('/transfer-in/delete/{id}', 'Transfer_in@delete');
Route::get('/transfer-in/invoice/{id}', 'Transfer_in@invoice');


// transfer-in routes
Route::get('/transfer-out', 'Transfer_out@view');
Route::get('/transfer-out/add', 'Transfer_out@add');
Route::post('/transfer-out/save', 'Transfer_out@save');
Route::get('/transfer-out/edit/{id}', 'Transfer_out@edit');
Route::post('/transfer-out/update/{id}', 'Transfer_out@update');
Route::get('/transfer-out/delete/{id}', 'Transfer_out@delete');
Route::get('/transfer-out/invoice/{id}', 'Transfer_out@invoice');


// my bookings
Route::get('/bookings', 'Bookings@view');
Route::get('/bookings/processed', 'Bookings@view_processed');
Route::get('/bookings/add', 'Bookings@add');
Route::post('/bookings/save', 'Bookings@save');
Route::get('/bookings/edit/{id}', 'Bookings@edit');
Route::post('/bookings/update/{id}', 'Bookings@update');
Route::get('/bookings/delete/{id}', 'Bookings@delete');
Route::get('/bookings/invoice/{id}', 'Bookings@invoice');
Route::get('/bookings/invoice-process/{id}', 'Bookings@invoice_process');
Route::get('/bookings/sales', 'Bookings@sales');

// suggestions routes
Route::get('/suggestions', 'Suggestions@view');
Route::get('/suggestions/add', 'Suggestions@add');
Route::post('/suggestions/save', 'Suggestions@save');
Route::get('/suggestions/edit/{id}', 'Suggestions@edit');
Route::post('/suggestions/update/{id}', 'Suggestions@update');
Route::get('/suggestions/delete/{id}', 'Suggestions@delete');

// orders
Route::get('/orders', 'Orders@view');
Route::get('/orders/processed', 'Orders@processed');
Route::get('/orders/add', 'Orders@add');
Route::post('/orders/save', 'Orders@save');
Route::get('/orders/edit/{id}', 'Orders@edit');
Route::post('/orders/update/{id}', 'Orders@update');
Route::get('/orders/delete/{id}', 'Orders@delete');
Route::get('/orders/invoice/{id}', 'Orders@invoice');
Route::post('/orders/update-status', 'Orders@update_status');
Route::get('/orders/process/{id}', 'Orders@process');
Route::post('/orders/process/add', 'Orders@process_add');


// suggestions routes
Route::get('/b-to-b-transfer', 'Branch_to_branch_transfer@view');
Route::get('/b-to-b-transfer/add', 'Branch_to_branch_transfer@add');
Route::post('/b-to-b-transfer/save', 'Branch_to_branch_transfer@save');
Route::get('/b-to-b-transfer/edit/{id}', 'Branch_to_branch_transfer@edit');
Route::post('/b-to-b-transfer/update/{id}', 'Branch_to_branch_transfer@update');
Route::get('/b-to-b-transfer/delete/{id}', 'Branch_to_branch_transfer@delete');


Route::get('/share-capitals-categories', 'Share_capitals_categories@view');
Route::get('/share-capitals-categories/add', 'Share_capitals_categories@add');
Route::post('/share-capitals-categories/save', 'Share_capitals_categories@save');
Route::get('/share-capitals-categories/edit/{id}', 'Share_capitals_categories@edit');
Route::post('/share-capitals-categories/update/{id}', 'Share_capitals_categories@update');
Route::get('/share-capitals-categories/delete/{id}', 'Share_capitals_categories@delete');

Route::get('/share-capitals', 'Share_capitals@view');
Route::get('/share-capitals/add', 'Share_capitals@add');
Route::post('/share-capitals/save', 'Share_capitals@save');
Route::get('/share-capitals/edit/{id}', 'Share_capitals@edit');
Route::post('/share-capitals/update/{id}', 'Share_capitals@update');
Route::get('/share-capitals/delete/{id}', 'Share_capitals@delete');


Route::get('/metu', 'Metu@view');
Route::get('/metu/add', 'Metu@add');
Route::post('/metu/save', 'Metu@save');
Route::get('/metu/edit/{id}', 'Metu@edit');
Route::post('/metu/update/{id}', 'Metu@update');
Route::get('/metu/delete/{id}', 'Metu@delete');
Route::get('/metu/report', 'Metu@report');

Route::get('/metu-purchases', 'Metu_purchases@view');
Route::get('/metu-purchases/add', 'Metu_purchases@add');
Route::post('/metu-purchases/save', 'Metu_purchases@save');
Route::get('/metu-purchases/edit/{id}', 'Metu_purchases@edit');
Route::post('/metu-purchases/update/{id}', 'Metu_purchases@update');
Route::get('/metu-purchases/delete/{id}', 'Metu_purchases@delete');

Route::get('/metu-sales', 'Metu_sales@view');
Route::get('/metu-sales/add', 'Metu_sales@add');
Route::post('/metu-sales/save', 'Metu_sales@save');
Route::get('/metu-sales/edit/{id}', 'Metu_sales@edit');
Route::post('/metu-sales/update/{id}', 'Metu_sales@update');
Route::get('/metu-sales/delete/{id}', 'Metu_sales@delete');

Route::get('/system-approvals', 'System_approvals@approvals');
Route::get('/system-approvals', 'System_approvals@approvals');
Route::post('/process-system-approvals', 'System_approvals@process');